/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.views.pfly.modal;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import javax.enterprise.context.Dependent;
import org.gwtbootstrap3.client.shared.event.ModalHiddenEvent;
import org.gwtbootstrap3.client.shared.event.ModalHiddenHandler;
import org.gwtbootstrap3.client.shared.event.ModalShownEvent;
import org.gwtbootstrap3.client.shared.event.ModalShownHandler;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.Modal;
import org.gwtbootstrap3.client.ui.ModalBody;
import org.gwtbootstrap3.client.ui.ModalFooter;
import org.gwtbootstrap3.client.ui.constants.ButtonDismiss;
import org.gwtbootstrap3.client.ui.constants.ModalBackdrop;
import org.uberfire.client.resources.WorkbenchResources;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.mvp.Command;

@Dependent
public class Bs3Modal
extends Modal {
    private final ModalBody body = new ModalBody();
    private final ModalFooter footer = new ModalFooter();
    boolean hasBeenShown;

    public Bs3Modal() {
        this.add((Widget)this.body);
        this.add((Widget)this.footer);
        this.setDataBackdrop(ModalBackdrop.STATIC);
        this.setFade(true);
        this.getElement().setAttribute("role", "dialog");
        this.getElement().setAttribute("tabindex", "-1");
        this.addStyleName(WorkbenchResources.INSTANCE.CSS().modal());
        Button close = new Button("OK");
        close.setDataDismiss(ButtonDismiss.MODAL);
        close.addStyleName("btn-primary");
        this.footer.add((Widget)close);
    }

    public void show(final Command afterShown, final Command afterClosed) {
        PortablePreconditions.checkNotNull((String)"afterShown", (Object)afterShown);
        PortablePreconditions.checkNotNull((String)"afterClosed", (Object)afterClosed);
        this.addShownHandler(new ModalShownHandler(){

            public void onShown(ModalShownEvent showEvent) {
                if (afterShown != null) {
                    afterShown.execute();
                }
            }
        });
        this.addHiddenHandler(new ModalHiddenHandler(){

            public void onHidden(ModalHiddenEvent hiddenEvent) {
                if (afterClosed != null) {
                    afterClosed.execute();
                }
            }
        });
        this.show();
    }

    public void show() {
        if (this.hasBeenShown) {
            throw new IllegalStateException("This modal has already been shown. Create a new instance if you want to show another modal.");
        }
        super.show();
    }

    public void setContent(IsWidget content) {
        this.body.clear();
        this.body.add(content);
    }

    public void setModalTitle(String title) {
        this.setTitle(SafeHtmlUtils.htmlEscape((String)title));
    }

    public void setFooterContent(IsWidget content) {
        this.footer.clear();
        this.footer.add(content);
    }

    public void setBodyHeight(int height) {
        this.body.setHeight(height + "px");
    }
}

