/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.workbench.widgets.toolbar;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.gwt.user.client.ui.IsWidget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.uberfire.client.mvp.Activity;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.WorkbenchActivity;
import org.uberfire.client.workbench.events.ClosePlaceEvent;
import org.uberfire.client.workbench.events.PlaceGainFocusEvent;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.model.toolbar.ToolBar;

@ApplicationScoped
public class WorkbenchToolBarPresenter {
    @Inject
    private View view;
    @Inject
    private PlaceManager placeManager;
    private final List<ToolBar> workbenchItems = new ArrayList<ToolBar>();
    private final List<ToolBar> workbenchPerspectiveItems = new ArrayList<ToolBar>();
    private final Multimap<PlaceRequest, ToolBar> workbenchContextItems = ArrayListMultimap.create();

    public IsWidget getView() {
        return this.view;
    }

    public int getHeight() {
        return this.view.getHeight();
    }

    public void hide() {
        this.view.hide();
    }

    public void show() {
        this.view.show();
    }

    private void removeItemsFor(PlaceRequest place) {
        Collection removed = this.workbenchContextItems.removeAll((Object)place);
        for (ToolBar toolBar : removed) {
            this.view.removeToolBar(toolBar);
        }
    }

    public void addItemsFor(PlaceRequest place) {
        Activity activity = this.placeManager.getActivity(place);
        if (activity == null) {
            return;
        }
        if (!(activity instanceof WorkbenchActivity)) {
            return;
        }
        WorkbenchActivity wbActivity = (WorkbenchActivity)activity;
        ToolBar toolBar = wbActivity.getToolBar();
        if (toolBar == null) {
            return;
        }
        ToolBar filteredToolBar = this.filterToolBarItemsByPermission(toolBar);
        if (!filteredToolBar.getItems().isEmpty()) {
            this.workbenchContextItems.put((Object)place, (Object)filteredToolBar);
            this.view.addToolBar(filteredToolBar);
        }
    }

    void onWorkbenchPartClose(@Observes ClosePlaceEvent event) {
        this.removeItemsFor(event.getPlace());
    }

    void onWorkbenchPartOnFocus(@Observes PlaceGainFocusEvent event) {
        if (!this.workbenchContextItems.containsKey((Object)event.getPlace())) {
            this.addItemsFor(event.getPlace());
        }
    }

    public void addWorkbenchItem(ToolBar toolBar) {
        ToolBar filteredToolBar = this.filterToolBarItemsByPermission(toolBar);
        if (!filteredToolBar.getItems().isEmpty()) {
            this.workbenchItems.add(filteredToolBar);
            this.view.addToolBar(filteredToolBar);
        }
    }

    public void addWorkbenchPerspective(ToolBar toolBar) {
        ToolBar filteredToolBar = this.filterToolBarItemsByPermission(toolBar);
        if (!filteredToolBar.getItems().isEmpty()) {
            this.workbenchPerspectiveItems.add(filteredToolBar);
            this.view.addToolBar(filteredToolBar);
        }
    }

    private ToolBar filterToolBarItemsByPermission(ToolBar toolBar) {
        return toolBar;
    }

    public void clearWorkbenchItems() {
        if (this.workbenchItems.isEmpty()) {
            return;
        }
        for (ToolBar item : this.workbenchItems) {
            this.view.removeToolBar(item);
        }
        this.workbenchItems.clear();
    }

    public void clearWorkbenchPerspectiveItems() {
        if (this.workbenchPerspectiveItems.isEmpty()) {
            return;
        }
        for (ToolBar item : this.workbenchPerspectiveItems) {
            this.view.removeToolBar(item);
        }
        this.workbenchPerspectiveItems.clear();
    }

    public static interface View
    extends IsWidget {
        public void addToolBar(ToolBar var1);

        public void removeToolBar(ToolBar var1);

        public int getHeight();

        public void hide();

        public void show();
    }
}

