/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.views.pfly.listbar;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.DragStartEvent;
import com.google.gwt.event.dom.client.DragStartHandler;
import com.google.gwt.event.dom.client.MouseDownEvent;
import com.google.gwt.event.dom.client.MouseDownHandler;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.event.logical.shared.HasCloseHandlers;
import com.google.gwt.event.logical.shared.HasSelectionHandlers;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import java.util.Map;
import org.gwtbootstrap3.client.ui.Anchor;
import org.gwtbootstrap3.client.ui.Icon;
import org.gwtbootstrap3.client.ui.ListItem;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.gwtbootstrap3.client.ui.html.Span;
import org.gwtbootstrap3.client.ui.html.Text;
import org.uberfire.client.views.pfly.dropdown.ListDropdown;
import org.uberfire.client.workbench.part.WorkbenchPartPresenter;
import org.uberfire.client.workbench.widgets.dnd.DragArea;
import org.uberfire.client.workbench.widgets.dnd.WorkbenchDragAndDropManager;
import org.uberfire.workbench.model.PartDefinition;

public class PartListDropdown
extends ListDropdown
implements HasSelectionHandlers<PartDefinition>,
HasCloseHandlers<PartDefinition> {
    public static final String DEBUG_TITLE_PREFIX = "PartList-title-";
    private Map<PartDefinition, Widget> partOptions = new HashMap<PartDefinition, Widget>();
    private Map<PartDefinition, Widget> partTitles = new HashMap<PartDefinition, Widget>();
    private Map<PartDefinition, WorkbenchPartPresenter.View> partView = new HashMap<PartDefinition, WorkbenchPartPresenter.View>();
    private HandlerRegistration noDragHandler;
    private WorkbenchDragAndDropManager dndManager;
    private boolean dndEnabled = true;

    public PartListDropdown() {
        this.addDomHandler((EventHandler)new NoMouseDownHandler(), MouseDownEvent.getType());
    }

    public void setDndManager(WorkbenchDragAndDropManager dndManager) {
        this.dndManager = dndManager;
    }

    public void addPart(WorkbenchPartPresenter.View view) {
        PartDefinition part = view.getPresenter().getDefinition();
        this.partView.put(part, view);
        Widget title = this.buildTitleWidget(view.getPresenter().getTitle(), view.getPresenter().getTitleDecoration());
        this.partTitles.put(part, title);
        Widget option = this.buildTitleDropdownMenuItem(view.getPresenter().getTitle(), part);
        this.partOptions.put(part, option);
        this.add(option);
        if (this.partTitles.size() == 1) {
            this.selectPart(part);
        }
    }

    public void removePart(PartDefinition part) {
        this.partTitles.remove(part);
        this.partView.remove(part);
        Widget option = this.partOptions.remove(part);
        this.remove(option);
    }

    public void selectPart(PartDefinition part) {
        Widget title = this.partTitles.get(part);
        this.setText(title);
        for (Map.Entry<PartDefinition, Widget> entry : this.partOptions.entrySet()) {
            if (entry.getKey().equals(part)) {
                entry.getValue().addStyleName("uf-part-list-dropdown-selected");
                continue;
            }
            entry.getValue().removeStyleName("uf-part-list-dropdown-selected");
        }
        this.makeDraggable(title, this.partView.get(part));
    }

    public void changeTitle(PartDefinition part, String title, IsWidget titleDecoration) {
        Widget titleWidget = this.buildTitleWidget(title, titleDecoration);
        this.partTitles.put(part, titleWidget);
    }

    private Widget buildTitleWidget(String title, IsWidget titleDecoration) {
        String titleWidget = titleDecoration instanceof Image ? titleDecoration.toString() : "";
        Text text = new Text(SafeHtmlUtils.htmlEscape((String)(titleWidget + " " + title)));
        DragArea dragArea = new DragArea((Widget)text);
        dragArea.ensureDebugId(DEBUG_TITLE_PREFIX + title);
        dragArea.addStyleName("pull-left");
        dragArea.addMouseDownHandler((MouseDownHandler)new NoMouseDownHandler());
        return dragArea;
    }

    private Widget buildTitleDropdownMenuItem(String title, final PartDefinition part) {
        ListItem li = new ListItem();
        li.addDomHandler((EventHandler)new ClickHandler(){

            public void onClick(ClickEvent event) {
                SelectionEvent.fire((HasSelectionHandlers)PartListDropdown.this, (Object)part);
            }
        }, ClickEvent.getType());
        Span span = new Span();
        span.add((Widget)new Text(title));
        Icon icon = new Icon(IconType.TIMES);
        icon.addDomHandler((EventHandler)new ClickHandler(){

            public void onClick(ClickEvent event) {
                CloseEvent.fire((HasCloseHandlers)PartListDropdown.this, (Object)part);
                boolean openMenu = PartListDropdown.this.getElement().hasClassName("open");
                if (openMenu) {
                    Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                        public void execute() {
                            PartListDropdown.this.getElement().addClassName("open");
                        }
                    });
                }
            }
        }, ClickEvent.getType());
        icon.addStyleName("pull-right");
        Anchor anchor = new Anchor();
        anchor.add((Widget)icon);
        anchor.add((Widget)span);
        li.add((Widget)anchor);
        return li;
    }

    public void enableDragAndDrop() {
        this.dndEnabled = true;
        if (this.noDragHandler != null) {
            this.noDragHandler.removeHandler();
            this.noDragHandler = null;
        }
        for (Map.Entry<PartDefinition, Widget> entry : this.partTitles.entrySet()) {
            Widget title = entry.getValue();
            WorkbenchPartPresenter.View view = this.partView.get(entry.getKey());
            this.makeDraggable(title, view);
        }
    }

    private void makeDraggable(Widget title, WorkbenchPartPresenter.View view) {
        if (this.dndManager == null || !this.dndEnabled) {
            return;
        }
        this.dndManager.makeDraggable((IsWidget)view, (IsWidget)title);
    }

    public void disableDragAndDrop() {
        this.dndEnabled = false;
        if (this.noDragHandler == null) {
            this.noDragHandler = this.addDomHandler((EventHandler)new DragStartHandler(){

                public void onDragStart(DragStartEvent event) {
                    event.preventDefault();
                }
            }, DragStartEvent.getType());
        }
    }

    public boolean isDndEnabled() {
        return this.dndEnabled;
    }

    @Override
    public void clear() {
        super.clear();
        this.partOptions.clear();
        this.partTitles.clear();
        this.partView.clear();
    }

    public HandlerRegistration addSelectionHandler(SelectionHandler<PartDefinition> handler) {
        return super.addHandler(handler, SelectionEvent.getType());
    }

    public HandlerRegistration addCloseHandler(CloseHandler<PartDefinition> handler) {
        return super.addHandler(handler, CloseEvent.getType());
    }

    private class NoMouseDownHandler
    implements MouseDownHandler {
        private NoMouseDownHandler() {
        }

        public void onMouseDown(MouseDownEvent event) {
            event.preventDefault();
        }
    }
}

