/*
 * Decompiled with CFR 0.152.
 */
package org.wymiwyg.commons.util.http;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;

public class HttpURLTools {
    private URL url;
    private String acceptLanguage;
    private String accept;
    private URLConnection connection;

    public HttpURLTools(URL url) {
        this.url = url;
    }

    public HttpURLTools(URL url, String acceptLanguage) {
        this.url = url;
        this.acceptLanguage = acceptLanguage;
    }

    private void prepareConnection() throws IOException {
        this.connection = this.url.openConnection();
        if (this.acceptLanguage != null) {
            this.connection.setRequestProperty("Accept-Language", this.acceptLanguage);
        }
        if (this.accept != null) {
            this.connection.setRequestProperty("Accept", this.accept);
        }
    }

    public InputStream openStream() throws IOException {
        if (this.connection == null) {
            this.prepareConnection();
        }
        return this.connection.getInputStream();
    }

    public URLConnection getConnection() throws IOException {
        if (this.connection == null) {
            this.prepareConnection();
        }
        return this.connection;
    }

    public String getAcceptLanguage() {
        return this.acceptLanguage;
    }

    public void setAcceptLanguage(String string) {
        this.acceptLanguage = string;
    }

    public String getAccept() {
        return this.accept;
    }

    public void setAccept(String accept) {
        this.accept = accept;
    }
}

