/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah.benchmark;

import com.googlecode.javaewah.EWAHCompressedBitmap;
import com.googlecode.javaewah.FastAggregation;
import com.googlecode.javaewah.IntIterator;
import com.googlecode.javaewah.IteratingRLW;
import com.googlecode.javaewah.IteratorAggregation;
import com.googlecode.javaewah.IteratorUtil;
import com.googlecode.javaewah.LogicalElement;
import com.googlecode.javaewah.benchmark.ClusteredDataGenerator;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.List;

public class Benchmark {
    public static int[] unite2by2(int[] set1, int[] set2) {
        int[] buffer;
        int pos;
        block11: {
            pos = 0;
            int k1 = 0;
            int k2 = 0;
            if (0 == set1.length) {
                return Arrays.copyOf(set2, set2.length);
            }
            if (0 == set2.length) {
                return Arrays.copyOf(set1, set1.length);
            }
            buffer = new int[set1.length + set2.length];
            while (true) {
                if (set1[k1] < set2[k2]) {
                    buffer[pos++] = set1[k1];
                    if (++k1 < set1.length) continue;
                    while (k2 < set2.length) {
                        buffer[pos++] = set2[k2];
                        ++k2;
                    }
                    break block11;
                }
                if (set1[k1] == set2[k2]) {
                    buffer[pos++] = set1[k1];
                    ++k2;
                    if (++k1 >= set1.length) {
                        while (k2 < set2.length) {
                            buffer[pos++] = set2[k2];
                            ++k2;
                        }
                    } else {
                        if (k2 < set2.length) continue;
                        while (k1 < set1.length) {
                            buffer[pos++] = set1[k1];
                            ++k1;
                        }
                    }
                    break block11;
                }
                buffer[pos++] = set2[k2];
                if (++k2 >= set2.length) break;
            }
            while (k1 < set1.length) {
                buffer[pos++] = set1[k1];
                ++k1;
            }
        }
        return Arrays.copyOf(buffer, pos);
    }

    public static void main(String[] args) {
        Benchmark.test(100, 16, 1);
    }

    public static void test(int N, int nbr, int repeat) {
        DecimalFormat df = new DecimalFormat("0.###");
        ClusteredDataGenerator cdg = new ClusteredDataGenerator();
        for (int sparsity = 1; sparsity < 30 - nbr; sparsity += 2) {
            int k;
            int k2;
            int r;
            long bogus = 0L;
            String line = "";
            line = line + sparsity;
            int[][] data = new int[N][];
            int Max = 1 << nbr + sparsity;
            System.out.println("# generating random data...");
            int[] inter = cdg.generateClustered(1 << nbr / 2, Max);
            for (int k3 = 0; k3 < N; ++k3) {
                data[k3] = Benchmark.unite2by2(cdg.generateClustered(1 << nbr, Max), inter);
            }
            System.out.println("# generating random data... ok.");
            long bef = System.currentTimeMillis();
            EWAHCompressedBitmap[] ewah = new EWAHCompressedBitmap[N];
            int size = 0;
            for (r = 0; r < repeat; ++r) {
                size = 0;
                for (k2 = 0; k2 < N; ++k2) {
                    ewah[k2] = new EWAHCompressedBitmap();
                    for (int x = 0; x < data[k2].length; ++x) {
                        ewah[k2].set(data[k2][x]);
                    }
                    size += ewah[k2].sizeInBytes();
                }
            }
            long aft = System.currentTimeMillis();
            line = line + "\t" + size;
            line = line + "\t" + df.format((double)(aft - bef) / 1000.0);
            bef = System.currentTimeMillis();
            for (r = 0; r < repeat; ++r) {
                for (k2 = 0; k2 < N; ++k2) {
                    int[] array = ewah[k2].toArray();
                    bogus += (long)array.length;
                }
            }
            aft = System.currentTimeMillis();
            line = line + "\t" + df.format((double)(aft - bef) / 1000.0);
            bef = System.currentTimeMillis();
            for (r = 0; r < repeat; ++r) {
                for (k2 = 0; k2 < N; ++k2) {
                    int[] array = new int[ewah[k2].cardinality()];
                    int c = 0;
                    for (int x : ewah[k2]) {
                        array[c++] = x;
                    }
                }
            }
            aft = System.currentTimeMillis();
            line = line + "\t" + df.format((double)(aft - bef) / 1000.0);
            bef = System.currentTimeMillis();
            for (r = 0; r < repeat; ++r) {
                for (k2 = 0; k2 < N; ++k2) {
                    List<Integer> L = ewah[k2].getPositions();
                    int[] array = new int[L.size()];
                    int c = 0;
                    for (int x : L) {
                        array[c++] = x;
                    }
                }
            }
            aft = System.currentTimeMillis();
            line = line + "\t" + df.format((double)(aft - bef) / 1000.0);
            bef = System.currentTimeMillis();
            for (r = 0; r < repeat; ++r) {
                for (k2 = 0; k2 < N; ++k2) {
                    IntIterator iter = ewah[k2].intIterator();
                    while (iter.hasNext()) {
                        bogus += (long)iter.next();
                    }
                }
            }
            aft = System.currentTimeMillis();
            line = line + "\t" + df.format((double)(aft - bef) / 1000.0);
            line = line + "\t\t\t";
            bef = System.currentTimeMillis();
            for (r = 0; r < repeat; ++r) {
                for (k2 = 0; k2 < N; ++k2) {
                    EWAHCompressedBitmap ewahor = ewah[0];
                    for (int j = 1; j < k2 + 1; ++j) {
                        ewahor = ewahor.or(ewah[j]);
                    }
                    bogus += (long)ewahor.sizeInBits();
                }
            }
            aft = System.currentTimeMillis();
            line = line + "\t" + df.format((double)(aft - bef) / 1000.0);
            bef = System.currentTimeMillis();
            for (r = 0; r < repeat; ++r) {
                for (k2 = 0; k2 < N; ++k2) {
                    EWAHCompressedBitmap[] ewahcp = new EWAHCompressedBitmap[k2 + 1];
                    for (int j = 0; j < k2 + 1; ++j) {
                        ewahcp[j] = ewah[j];
                    }
                    EWAHCompressedBitmap ewahor = EWAHCompressedBitmap.or(ewahcp);
                    bogus += (long)ewahor.sizeInBits();
                }
            }
            aft = System.currentTimeMillis();
            line = line + "\t" + df.format((double)(aft - bef) / 1000.0);
            bef = System.currentTimeMillis();
            for (r = 0; r < repeat; ++r) {
                for (k2 = 0; k2 < N; ++k2) {
                    LogicalElement[] ewahcp = new EWAHCompressedBitmap[k2 + 1];
                    for (int j = 0; j < k2 + 1; ++j) {
                        ewahcp[j] = ewah[j];
                    }
                    EWAHCompressedBitmap ewahor = (EWAHCompressedBitmap)FastAggregation.or((LogicalElement[])ewahcp);
                    bogus += (long)ewahor.sizeInBits();
                }
            }
            aft = System.currentTimeMillis();
            line = line + "\t" + df.format((double)(aft - bef) / 1000.0);
            for (k = 0; k < N; ++k) {
                EWAHCompressedBitmap mewahor;
                IteratingRLW[] ewahcp = new IteratingRLW[k + 1];
                for (int j = 0; j < k + 1; ++j) {
                    ewahcp[j] = ewah[j].getIteratingRLW();
                }
                IteratingRLW ewahor = IteratorAggregation.bufferedor(ewahcp);
                EWAHCompressedBitmap ewahorp = EWAHCompressedBitmap.or(Arrays.copyOf(ewah, k + 1));
                if (ewahorp.equals(mewahor = IteratorUtil.materialize(ewahor))) continue;
                throw new RuntimeException("bug");
            }
            bef = System.currentTimeMillis();
            for (r = 0; r < repeat; ++r) {
                for (int k4 = 0; k4 < N; ++k4) {
                    IteratingRLW[] ewahcp = new IteratingRLW[k4 + 1];
                    for (int j = 0; j < k4 + 1; ++j) {
                        ewahcp[j] = ewah[j].getIteratingRLW();
                    }
                    IteratingRLW ewahor = IteratorAggregation.bufferedor(ewahcp);
                    bogus += (long)IteratorUtil.materialize(ewahor).sizeInBits();
                }
            }
            aft = System.currentTimeMillis();
            line = line + "\t" + df.format((double)(aft - bef) / 1000.0);
            line = line + "\t\t\t";
            bef = System.currentTimeMillis();
            for (r = 0; r < repeat; ++r) {
                for (int k5 = 0; k5 < N; ++k5) {
                    EWAHCompressedBitmap ewahand = ewah[0];
                    for (int j = 1; j < k5 + 1; ++j) {
                        ewahand = ewahand.and(ewah[j]);
                    }
                    bogus += (long)ewahand.sizeInBits();
                }
            }
            aft = System.currentTimeMillis();
            line = line + "\t" + df.format((double)(aft - bef) / 1000.0);
            bef = System.currentTimeMillis();
            for (r = 0; r < repeat; ++r) {
                for (int k6 = 0; k6 < N; ++k6) {
                    EWAHCompressedBitmap[] ewahcp = new EWAHCompressedBitmap[k6 + 1];
                    for (int j = 0; j < k6 + 1; ++j) {
                        ewahcp[j] = ewah[j];
                    }
                    EWAHCompressedBitmap ewahand = EWAHCompressedBitmap.and(ewahcp);
                    bogus += (long)ewahand.sizeInBits();
                }
            }
            aft = System.currentTimeMillis();
            line = line + "\t" + df.format((double)(aft - bef) / 1000.0);
            for (k = 0; k < N; ++k) {
                EWAHCompressedBitmap mewahand;
                IteratingRLW[] ewahcp = new IteratingRLW[k + 1];
                for (int j = 0; j < k + 1; ++j) {
                    ewahcp[j] = ewah[j].getIteratingRLW();
                }
                IteratingRLW ewahand = IteratorAggregation.bufferedand(ewahcp);
                EWAHCompressedBitmap ewahandp = EWAHCompressedBitmap.and(Arrays.copyOf(ewah, k + 1));
                if (ewahandp.equals(mewahand = IteratorUtil.materialize(ewahand))) continue;
                throw new RuntimeException("bug");
            }
            bef = System.currentTimeMillis();
            for (r = 0; r < repeat; ++r) {
                for (int k7 = 0; k7 < N; ++k7) {
                    IteratingRLW[] ewahcp = new IteratingRLW[k7 + 1];
                    for (int j = 0; j < k7 + 1; ++j) {
                        ewahcp[j] = ewah[j].getIteratingRLW();
                    }
                    IteratingRLW ewahand = IteratorAggregation.bufferedand(ewahcp);
                    bogus += (long)IteratorUtil.materialize(ewahand).sizeInBits();
                }
            }
            aft = System.currentTimeMillis();
            line = line + "\t" + df.format((double)(aft - bef) / 1000.0);
            System.out.println("time for building, toArray(), Java iterator, intIterator,\t\t\t logical or (2-by-2), logical or (grouped), FastAggregation.or, iterator-based or, \t\t\t (2-by-2) and,  logical and (grouped), iterator-based and");
            System.out.println(line);
            System.out.println("# bogus =" + bogus);
        }
    }
}

