/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.io;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.annotation.PostConstruct;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.uberfire.commons.async.SimpleAsyncExecutorService;
import org.uberfire.commons.cluster.ClusterService;
import org.uberfire.commons.cluster.ClusterServiceFactory;
import org.uberfire.commons.lifecycle.Disposable;
import org.uberfire.commons.lifecycle.PriorityDisposable;
import org.uberfire.java.nio.file.api.FileSystemProviders;
import org.uberfire.java.nio.file.spi.FileSystemProvider;

public class DisposableShutdownService
implements ServletContextListener {
    @Inject
    private Instance<PriorityDisposable> disposables;
    @Inject
    @Named(value="clusterServiceFactory")
    private ClusterServiceFactory clusterServiceFactory;
    private ClusterService clusterService = null;

    @PostConstruct
    public void init() {
        if (this.clusterServiceFactory != null) {
            this.clusterService = this.clusterServiceFactory.build(null);
        }
    }

    public void contextInitialized(ServletContextEvent sce) {
    }

    public void contextDestroyed(ServletContextEvent sce) {
        ArrayList<PriorityDisposable> collection = new ArrayList<PriorityDisposable>();
        for (PriorityDisposable disposable : this.disposables) {
            collection.add(disposable);
        }
        Collections.sort(collection, new Comparator<PriorityDisposable>(){

            @Override
            public int compare(PriorityDisposable o1, PriorityDisposable o2) {
                return o2.priority() < o1.priority() ? -1 : (o2.priority() == o1.priority() ? 0 : 1);
            }
        });
        if (this.clusterService != null) {
            this.clusterService.lock();
        }
        for (PriorityDisposable disposable : collection) {
            disposable.dispose();
        }
        SimpleAsyncExecutorService.shutdownInstances();
        for (FileSystemProvider fileSystemProvider : FileSystemProviders.installedProviders()) {
            if (!(fileSystemProvider instanceof Disposable)) continue;
            ((Disposable)fileSystemProvider).dispose();
        }
        if (this.clusterService != null) {
            this.clusterService.unlock();
            this.clusterService.dispose();
        }
    }
}

