/*
 * Decompiled with CFR 0.152.
 */
package org.wymiwyg.commons.util.http;

import java.util.StringTokenizer;

public class ServerAddress {
    String host;
    int port;
    private String scheme;

    public ServerAddress(String name) {
        StringTokenizer tokens = new StringTokenizer(name, ":/");
        this.scheme = tokens.nextToken();
        this.host = tokens.nextToken();
        this.port = tokens.hasMoreElements() ? Integer.parseInt(tokens.nextToken()) : (this.scheme.equals("https") ? 443 : 80);
    }

    public ServerAddress(String scheme, String host, int port) {
        this.scheme = scheme;
        this.host = host;
        this.port = port;
    }

    public boolean equals(Object obj) {
        try {
            ServerAddress other = (ServerAddress)obj;
            return other.getHost().equals(this.host) && other.getPort() == this.port && other.getScheme().equals(this.scheme);
        }
        catch (Exception e) {
            return false;
        }
    }

    public int hashCode() {
        return this.host.hashCode() & this.port & this.scheme.hashCode();
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(this.getScheme());
        result.append("://");
        result.append(this.getHost());
        int port = this.getPort();
        if (this.scheme.equals("https")) {
            if (port != 443) {
                result.append(':');
                result.append(port);
            }
        } else if (port != 80) {
            result.append(':');
            result.append(port);
        }
        result.append('/');
        return result.toString();
    }
}

