/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.relocated.freemarker.core;

import org.uberfire.relocated.freemarker.core.ArithmeticEngine;
import org.uberfire.relocated.freemarker.core.Environment;
import org.uberfire.relocated.freemarker.core.Expression;
import org.uberfire.relocated.freemarker.core.NonNumericalException;
import org.uberfire.relocated.freemarker.template.SimpleNumber;
import org.uberfire.relocated.freemarker.template.TemplateException;
import org.uberfire.relocated.freemarker.template.TemplateModel;
import org.uberfire.relocated.freemarker.template.TemplateNumberModel;

final class UnaryPlusMinusExpression
extends Expression {
    private final Expression target;
    private final boolean isMinus;
    private static final Integer MINUS_ONE = new Integer(-1);

    UnaryPlusMinusExpression(Expression target, boolean isMinus) {
        this.target = target;
        this.isMinus = isMinus;
    }

    TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
        TemplateNumberModel targetModel = null;
        try {
            targetModel = (TemplateNumberModel)this.target.getAsTemplateModel(env);
        }
        catch (ClassCastException cce) {
            String msg = "Error " + this.getStartLocation();
            msg = msg + "\nExpression " + this.target + " is not numerical.";
            throw new NonNumericalException(msg, env);
        }
        if (!this.isMinus) {
            return targetModel;
        }
        Number n = targetModel.getAsNumber();
        n = ArithmeticEngine.CONSERVATIVE_ENGINE.multiply(MINUS_ONE, n);
        return new SimpleNumber(n);
    }

    public String getCanonicalForm() {
        String op = this.isMinus ? "-" : "+";
        return op + this.target.getCanonicalForm();
    }

    boolean isLiteral() {
        return this.target.isLiteral();
    }

    Expression _deepClone(String name, Expression subst) {
        return new UnaryPlusMinusExpression(this.target.deepClone(name, subst), this.isMinus);
    }
}

