/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.rdf.core.impl.graphmatching;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

class PermutationIterator<T>
implements Iterator<List<T>> {
    private Iterator<List<T>> restIterator;
    private List<T> list;
    private List<T> next;
    int posInList = 0;

    PermutationIterator(List<T> list) {
        this.list = Collections.unmodifiableList(list);
        if (list.size() > 1) {
            this.createRestList();
        }
        this.prepareNext();
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public List<T> next() {
        List<T> result = this.next;
        if (result == null) {
            throw new NoSuchElementException();
        }
        this.prepareNext();
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported");
    }

    private void createRestList() {
        ArrayList<T> restList = new ArrayList<T>(this.list);
        restList.remove(this.posInList);
        this.restIterator = new PermutationIterator<T>(restList);
    }

    private void prepareNext() {
        this.next = this.getNext();
    }

    private List<T> getNext() {
        if (this.list.size() == 0) {
            return null;
        }
        if (this.list.size() == 1) {
            if (this.posInList++ == 0) {
                return new ArrayList<T>(this.list);
            }
            return null;
        }
        if (!this.restIterator.hasNext()) {
            if (this.posInList < this.list.size() - 1) {
                ++this.posInList;
                this.createRestList();
            } else {
                return null;
            }
        }
        List<T> result = this.restIterator.next();
        result.add(this.list.get(this.posInList));
        return result;
    }
}

