/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.helix.HelixProperty;
import org.apache.helix.PropertyType;
import org.apache.helix.model.CurrentState;
import org.apache.helix.model.ExternalView;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.InstanceConfig;
import org.apache.helix.model.LeaderHistory;
import org.apache.helix.model.LiveInstance;
import org.apache.helix.model.Message;
import org.apache.helix.model.PauseSignal;
import org.apache.helix.model.StateModelDefinition;
import org.apache.helix.model.StatusUpdate;
import org.apache.log4j.Logger;

public class PropertyPathConfig {
    private static Logger logger = Logger.getLogger(PropertyPathConfig.class);
    static final Map<PropertyType, Map<Integer, String>> templateMap = new HashMap<PropertyType, Map<Integer, String>>();
    static final Map<PropertyType, Class<? extends HelixProperty>> typeToClassMapping = new HashMap<PropertyType, Class<? extends HelixProperty>>();
    static Pattern pattern;

    private static void addEntry(PropertyType type, int numKeys, String template) {
        if (!templateMap.containsKey((Object)type)) {
            templateMap.put(type, new HashMap());
        }
        logger.trace((Object)("Adding template for type:" + (Object)((Object)type.getType()) + " arguments:" + numKeys + " template:" + template));
        templateMap.get((Object)type).put(numKeys, template);
    }

    public static String getPath(PropertyType type, String clusterName, String ... keys) {
        if (clusterName == null) {
            logger.warn((Object)("ClusterName can't be null for type:" + (Object)((Object)type)));
            return null;
        }
        if (keys == null) {
            keys = new String[]{};
        }
        String template = null;
        if (templateMap.containsKey((Object)type)) {
            template = templateMap.get((Object)type).get(keys.length + 1);
        }
        String result = null;
        if (template != null) {
            result = template;
            Matcher matcher = pattern.matcher(template);
            int count = 0;
            while (matcher.find()) {
                String var = matcher.group();
                if (++count == 1) {
                    result = result.replace(var, clusterName);
                    continue;
                }
                result = result.replace(var, keys[count - 2]);
            }
        }
        if (result == null || result.indexOf(123) > -1 || result.indexOf(125) > -1) {
            logger.warn((Object)("Unable to instantiate template:" + template + " using clusterName:" + clusterName + " and keys:" + Arrays.toString(keys)));
        }
        return result;
    }

    public static String getInstanceNameFromPath(String path) {
        String[] split;
        if (path.contains("/" + (Object)((Object)PropertyType.INSTANCES) + "/") && (split = path.split("\\/")).length > 3) {
            return split[3];
        }
        return null;
    }

    static {
        typeToClassMapping.put(PropertyType.LIVEINSTANCES, LiveInstance.class);
        typeToClassMapping.put(PropertyType.IDEALSTATES, IdealState.class);
        typeToClassMapping.put(PropertyType.CONFIGS, InstanceConfig.class);
        typeToClassMapping.put(PropertyType.EXTERNALVIEW, ExternalView.class);
        typeToClassMapping.put(PropertyType.STATEMODELDEFS, StateModelDefinition.class);
        typeToClassMapping.put(PropertyType.MESSAGES, Message.class);
        typeToClassMapping.put(PropertyType.CURRENTSTATES, CurrentState.class);
        typeToClassMapping.put(PropertyType.STATUSUPDATES, StatusUpdate.class);
        typeToClassMapping.put(PropertyType.HISTORY, LeaderHistory.class);
        typeToClassMapping.put(PropertyType.PAUSE, PauseSignal.class);
        PropertyPathConfig.addEntry(PropertyType.CONFIGS, 1, "/{clusterName}/CONFIGS");
        PropertyPathConfig.addEntry(PropertyType.CONFIGS, 2, "/{clusterName}/CONFIGS/{scope}");
        PropertyPathConfig.addEntry(PropertyType.CONFIGS, 3, "/{clusterName}/CONFIGS/{scope}/{scopeKey}");
        PropertyPathConfig.addEntry(PropertyType.LIVEINSTANCES, 1, "/{clusterName}/LIVEINSTANCES");
        PropertyPathConfig.addEntry(PropertyType.LIVEINSTANCES, 2, "/{clusterName}/LIVEINSTANCES/{instanceName}");
        PropertyPathConfig.addEntry(PropertyType.INSTANCES, 1, "/{clusterName}/INSTANCES");
        PropertyPathConfig.addEntry(PropertyType.INSTANCES, 2, "/{clusterName}/INSTANCES/{instanceName}");
        PropertyPathConfig.addEntry(PropertyType.IDEALSTATES, 1, "/{clusterName}/IDEALSTATES");
        PropertyPathConfig.addEntry(PropertyType.IDEALSTATES, 2, "/{clusterName}/IDEALSTATES/{resourceName}");
        PropertyPathConfig.addEntry(PropertyType.EXTERNALVIEW, 1, "/{clusterName}/EXTERNALVIEW");
        PropertyPathConfig.addEntry(PropertyType.EXTERNALVIEW, 2, "/{clusterName}/EXTERNALVIEW/{resourceName}");
        PropertyPathConfig.addEntry(PropertyType.STATEMODELDEFS, 1, "/{clusterName}/STATEMODELDEFS");
        PropertyPathConfig.addEntry(PropertyType.STATEMODELDEFS, 2, "/{clusterName}/STATEMODELDEFS/{stateModelName}");
        PropertyPathConfig.addEntry(PropertyType.CONTROLLER, 1, "/{clusterName}/CONTROLLER");
        PropertyPathConfig.addEntry(PropertyType.PROPERTYSTORE, 1, "/{clusterName}/PROPERTYSTORE");
        PropertyPathConfig.addEntry(PropertyType.MESSAGES, 2, "/{clusterName}/INSTANCES/{instanceName}/MESSAGES");
        PropertyPathConfig.addEntry(PropertyType.MESSAGES, 3, "/{clusterName}/INSTANCES/{instanceName}/MESSAGES/{msgId}");
        PropertyPathConfig.addEntry(PropertyType.CURRENTSTATES, 2, "/{clusterName}/INSTANCES/{instanceName}/CURRENTSTATES");
        PropertyPathConfig.addEntry(PropertyType.CURRENTSTATES, 3, "/{clusterName}/INSTANCES/{instanceName}/CURRENTSTATES/{sessionId}");
        PropertyPathConfig.addEntry(PropertyType.CURRENTSTATES, 4, "/{clusterName}/INSTANCES/{instanceName}/CURRENTSTATES/{sessionId}/{resourceName}");
        PropertyPathConfig.addEntry(PropertyType.CURRENTSTATES, 5, "/{clusterName}/INSTANCES/{instanceName}/CURRENTSTATES/{sessionId}/{resourceName}/{bucketName}");
        PropertyPathConfig.addEntry(PropertyType.STATUSUPDATES, 2, "/{clusterName}/INSTANCES/{instanceName}/STATUSUPDATES");
        PropertyPathConfig.addEntry(PropertyType.STATUSUPDATES, 3, "/{clusterName}/INSTANCES/{instanceName}/STATUSUPDATES/{sessionId}");
        PropertyPathConfig.addEntry(PropertyType.STATUSUPDATES, 4, "/{clusterName}/INSTANCES/{instanceName}/STATUSUPDATES/{sessionId}/{subPath}");
        PropertyPathConfig.addEntry(PropertyType.STATUSUPDATES, 5, "/{clusterName}/INSTANCES/{instanceName}/STATUSUPDATES/{sessionId}/{subPath}/{recordName}");
        PropertyPathConfig.addEntry(PropertyType.ERRORS, 2, "/{clusterName}/INSTANCES/{instanceName}/ERRORS");
        PropertyPathConfig.addEntry(PropertyType.ERRORS, 3, "/{clusterName}/INSTANCES/{instanceName}/ERRORS/{sessionId}");
        PropertyPathConfig.addEntry(PropertyType.ERRORS, 4, "/{clusterName}/INSTANCES/{instanceName}/ERRORS/{sessionId}/{subPath}");
        PropertyPathConfig.addEntry(PropertyType.ERRORS, 5, "/{clusterName}/INSTANCES/{instanceName}/ERRORS/{sessionId}/{subPath}/{recordName}");
        PropertyPathConfig.addEntry(PropertyType.HEALTHREPORT, 2, "/{clusterName}/INSTANCES/{instanceName}/HEALTHREPORT");
        PropertyPathConfig.addEntry(PropertyType.HEALTHREPORT, 3, "/{clusterName}/INSTANCES/{instanceName}/HEALTHREPORT/{reportName}");
        PropertyPathConfig.addEntry(PropertyType.MESSAGES_CONTROLLER, 1, "/{clusterName}/CONTROLLER/MESSAGES");
        PropertyPathConfig.addEntry(PropertyType.MESSAGES_CONTROLLER, 2, "/{clusterName}/CONTROLLER/MESSAGES/{msgId}");
        PropertyPathConfig.addEntry(PropertyType.ERRORS_CONTROLLER, 1, "/{clusterName}/CONTROLLER/ERRORS");
        PropertyPathConfig.addEntry(PropertyType.ERRORS_CONTROLLER, 2, "/{clusterName}/CONTROLLER/ERRORS/{errorId}");
        PropertyPathConfig.addEntry(PropertyType.STATUSUPDATES_CONTROLLER, 1, "/{clusterName}/CONTROLLER/STATUSUPDATES");
        PropertyPathConfig.addEntry(PropertyType.STATUSUPDATES_CONTROLLER, 2, "/{clusterName}/CONTROLLER/STATUSUPDATES/{subPath}");
        PropertyPathConfig.addEntry(PropertyType.STATUSUPDATES_CONTROLLER, 3, "/{clusterName}/CONTROLLER/STATUSUPDATES/{subPath}/{recordName}");
        PropertyPathConfig.addEntry(PropertyType.LEADER, 1, "/{clusterName}/CONTROLLER/LEADER");
        PropertyPathConfig.addEntry(PropertyType.HISTORY, 1, "/{clusterName}/CONTROLLER/HISTORY");
        PropertyPathConfig.addEntry(PropertyType.PAUSE, 1, "/{clusterName}/CONTROLLER/PAUSE");
        pattern = Pattern.compile("(\\{.+?\\})");
    }
}

