/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.channel;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.channel.AbstractChannel;
import org.apache.sshd.common.channel.Window;
import org.apache.sshd.common.channel.WindowClosedException;
import org.apache.sshd.common.util.Buffer;
import org.slf4j.Logger;

public class ChannelOutputStream
extends OutputStream {
    private final AbstractChannel channel;
    private final Window remoteWindow;
    private final Logger log;
    private final byte cmd;
    private final byte[] b = new byte[1];
    private Buffer buffer;
    private boolean closed;
    private int bufferLength;
    private int lastSize;
    private boolean noDelay = false;

    public ChannelOutputStream(AbstractChannel channel, Window remoteWindow, Logger log, byte cmd) {
        this.channel = channel;
        this.remoteWindow = remoteWindow;
        this.log = log;
        this.cmd = cmd;
        this.newBuffer(0);
    }

    public void setNoDelay(boolean noDelay) {
        this.noDelay = noDelay;
    }

    public boolean isNoDelay() {
        return this.noDelay;
    }

    public synchronized void write(int w) throws IOException {
        this.b[0] = (byte)w;
        this.write(this.b, 0, 1);
    }

    public synchronized void write(byte[] buf, int s, int l) throws IOException {
        if (this.closed) {
            throw new SshException("Already closed");
        }
        while (l > 0) {
            int _l = Math.min(l, Math.min(this.remoteWindow.getSize() + this.lastSize, this.remoteWindow.getPacketSize()) - this.bufferLength);
            if (_l <= 0) {
                if (this.bufferLength > 0) {
                    this.flush();
                    continue;
                }
                try {
                    this.remoteWindow.waitForSpace();
                    continue;
                }
                catch (WindowClosedException e) {
                    this.closed = true;
                    throw e;
                }
                catch (InterruptedException e) {
                    throw (IOException)new InterruptedIOException().initCause(e);
                }
            }
            this.buffer.putRawBytes(buf, s, _l);
            this.bufferLength += _l;
            s += _l;
            l -= _l;
        }
        if (this.noDelay) {
            this.flush();
        }
    }

    public synchronized void flush() throws IOException {
        if (this.closed) {
            throw new SshException("Already closed");
        }
        try {
            while (this.bufferLength > 0) {
                Buffer buf = this.buffer;
                int total = this.bufferLength;
                int length = Math.min(Math.min(this.remoteWindow.waitForSpace(), total), this.remoteWindow.getPacketSize());
                int pos = buf.wpos();
                buf.wpos(this.cmd == 95 ? 14 : 10);
                buf.putInt(length);
                buf.wpos(buf.wpos() + length);
                if (total == length) {
                    this.newBuffer(length);
                } else {
                    int leftover = total - length;
                    this.newBuffer(Math.max(leftover, length));
                    this.buffer.putRawBytes(buf.array(), pos - leftover, leftover);
                    this.bufferLength = leftover;
                }
                this.lastSize = length;
                this.remoteWindow.waitAndConsume(length);
                this.log.debug("Send {} on channel {}", (Object)(this.cmd == 94 ? "SSH_MSG_CHANNEL_DATA" : "SSH_MSG_CHANNEL_EXTENDED_DATA"), (Object)this.channel.getId());
                this.channel.writePacket(buf);
            }
        }
        catch (WindowClosedException e) {
            this.closed = true;
            throw e;
        }
        catch (SshException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SshException(e);
        }
    }

    public synchronized void close() throws IOException {
        this.flush();
        this.closed = true;
    }

    private void newBuffer(int size) {
        this.buffer = this.channel.getSession().createBuffer(this.cmd, size <= 0 ? 0 : 12 + size);
        this.buffer.putInt(this.channel.getRecipient());
        if (this.cmd == 95) {
            this.buffer.putInt(1L);
        }
        this.buffer.putInt(0L);
        this.bufferLength = 0;
    }
}

