/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.task;

import com.google.common.base.Joiner;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.I0Itec.zkclient.DataUpdater;
import org.apache.helix.AccessOption;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixDefinedState;
import org.apache.helix.HelixManager;
import org.apache.helix.PropertyKey;
import org.apache.helix.ZNRecord;
import org.apache.helix.controller.rebalancer.Rebalancer;
import org.apache.helix.controller.rebalancer.internal.MappingCalculator;
import org.apache.helix.controller.stages.ClusterDataCache;
import org.apache.helix.controller.stages.CurrentStateOutput;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.Message;
import org.apache.helix.model.Partition;
import org.apache.helix.model.Resource;
import org.apache.helix.model.ResourceAssignment;
import org.apache.helix.task.JobConfig;
import org.apache.helix.task.JobContext;
import org.apache.helix.task.JobDag;
import org.apache.helix.task.ScheduleConfig;
import org.apache.helix.task.TargetState;
import org.apache.helix.task.TaskConfig;
import org.apache.helix.task.TaskDriver;
import org.apache.helix.task.TaskPartitionState;
import org.apache.helix.task.TaskState;
import org.apache.helix.task.TaskUtil;
import org.apache.helix.task.Workflow;
import org.apache.helix.task.WorkflowConfig;
import org.apache.helix.task.WorkflowContext;
import org.apache.log4j.Logger;

public abstract class TaskRebalancer
implements Rebalancer,
MappingCalculator {
    private static final Logger LOG = Logger.getLogger(TaskRebalancer.class);
    private static final BiMap<String, Date> SCHEDULED_TIMES = HashBiMap.create();
    private static final ScheduledExecutorService SCHEDULED_EXECUTOR = Executors.newSingleThreadScheduledExecutor();
    private HelixManager _manager;

    public abstract Set<Integer> getAllTaskPartitions(JobConfig var1, JobContext var2, WorkflowConfig var3, WorkflowContext var4, ClusterDataCache var5);

    public abstract Map<String, SortedSet<Integer>> getTaskAssignment(CurrentStateOutput var1, ResourceAssignment var2, Collection<String> var3, JobConfig var4, JobContext var5, WorkflowConfig var6, WorkflowContext var7, Set<Integer> var8, ClusterDataCache var9);

    @Override
    public void init(HelixManager manager) {
        this._manager = manager;
    }

    @Override
    public ResourceAssignment computeBestPossiblePartitionState(ClusterDataCache clusterData, IdealState taskIs, Resource resource, CurrentStateOutput currStateOutput) {
        String resourceName = resource.getResourceName();
        JobConfig jobCfg = TaskUtil.getJobCfg(this._manager, resourceName);
        if (jobCfg == null) {
            return TaskRebalancer.emptyAssignment(resourceName, currStateOutput);
        }
        String workflowResource = jobCfg.getWorkflow();
        WorkflowConfig workflowCfg = TaskUtil.getWorkflowCfg(this._manager, workflowResource);
        if (workflowCfg == null) {
            return TaskRebalancer.emptyAssignment(resourceName, currStateOutput);
        }
        WorkflowContext workflowCtx = TaskUtil.getWorkflowContext(this._manager, workflowResource);
        if (workflowCtx == null) {
            workflowCtx = new WorkflowContext(new ZNRecord("WorkflowContext"));
            workflowCtx.setStartTime(System.currentTimeMillis());
        }
        for (String parent : workflowCfg.getJobDag().getDirectParents(resourceName)) {
            if (workflowCtx.getJobState(parent) != null && workflowCtx.getJobState(parent).equals((Object)TaskState.COMPLETED)) continue;
            return TaskRebalancer.emptyAssignment(resourceName, currStateOutput);
        }
        TargetState targetState = workflowCfg.getTargetState();
        if (targetState == TargetState.DELETE) {
            TaskRebalancer.cleanup(this._manager, resourceName, workflowCfg, workflowResource);
            return TaskRebalancer.emptyAssignment(resourceName, currStateOutput);
        }
        if (workflowCtx.getFinishTime() != -1L && workflowCtx.getFinishTime() + workflowCfg.getExpiry() <= System.currentTimeMillis()) {
            TaskRebalancer.markForDeletion(this._manager, workflowResource);
            TaskRebalancer.cleanup(this._manager, resourceName, workflowCfg, workflowResource);
            return TaskRebalancer.emptyAssignment(resourceName, currStateOutput);
        }
        JobContext jobCtx = TaskUtil.getJobContext(this._manager, resourceName);
        if (jobCtx == null) {
            jobCtx = new JobContext(new ZNRecord("TaskContext"));
            jobCtx.setStartTime(System.currentTimeMillis());
        }
        long jobFinishTime = jobCtx.getFinishTime();
        if (!workflowCfg.isTerminable() && jobFinishTime != -1L && jobFinishTime + workflowCfg.getExpiry() <= System.currentTimeMillis()) {
            TaskRebalancer.cleanup(this._manager, resourceName, workflowCfg, workflowResource);
            return TaskRebalancer.emptyAssignment(resourceName, currStateOutput);
        }
        if (workflowCtx.getJobState(resourceName) == TaskState.FAILED || workflowCtx.getJobState(resourceName) == TaskState.COMPLETED) {
            return TaskRebalancer.emptyAssignment(resourceName, currStateOutput);
        }
        boolean isReady = this.scheduleIfNotReady(workflowCfg, workflowCtx, workflowResource, resourceName, clusterData);
        if (!isReady) {
            return TaskRebalancer.emptyAssignment(resourceName, currStateOutput);
        }
        ResourceAssignment prevAssignment = TaskUtil.getPrevResourceAssignment(this._manager, resourceName);
        if (prevAssignment == null) {
            prevAssignment = new ResourceAssignment(resourceName);
        }
        TreeSet<Integer> partitionsToDrop = new TreeSet<Integer>();
        ResourceAssignment newAssignment = this.computeResourceMapping(resourceName, workflowCfg, jobCfg, prevAssignment, clusterData.getLiveInstances().keySet(), currStateOutput, workflowCtx, jobCtx, partitionsToDrop, clusterData);
        if (!partitionsToDrop.isEmpty()) {
            for (Integer pId : partitionsToDrop) {
                taskIs.getRecord().getMapFields().remove(TaskRebalancer.pName(resourceName, pId));
            }
            HelixDataAccessor accessor = this._manager.getHelixDataAccessor();
            PropertyKey propertyKey = accessor.keyBuilder().idealStates(resourceName);
            accessor.setProperty(propertyKey, taskIs);
        }
        TaskUtil.setJobContext(this._manager, resourceName, jobCtx);
        TaskUtil.setWorkflowContext(this._manager, workflowResource, workflowCtx);
        TaskUtil.setPrevResourceAssignment(this._manager, resourceName, newAssignment);
        return newAssignment;
    }

    private ResourceAssignment computeResourceMapping(String jobResource, WorkflowConfig workflowConfig, JobConfig jobCfg, ResourceAssignment prevAssignment, Collection<String> liveInstances, CurrentStateOutput currStateOutput, WorkflowContext workflowCtx, JobContext jobCtx, Set<Integer> partitionsToDropFromIs, ClusterDataCache cache) {
        TargetState jobTgtState = workflowConfig.getTargetState();
        if (jobTgtState == TargetState.STOP) {
            workflowCtx.setJobState(jobResource, TaskState.STOPPED);
            if (TaskRebalancer.isWorkflowStopped(workflowCtx, workflowConfig)) {
                workflowCtx.setWorkflowState(TaskState.STOPPED);
            }
        } else {
            workflowCtx.setJobState(jobResource, TaskState.IN_PROGRESS);
            workflowCtx.setWorkflowState(TaskState.IN_PROGRESS);
        }
        HashSet<Integer> assignedPartitions = new HashSet<Integer>();
        HashSet<Integer> skippedPartitions = new HashSet<Integer>();
        TreeMap<Integer, PartitionAssignment> paMap = new TreeMap<Integer, PartitionAssignment>();
        Set<Integer> allPartitions = this.getAllTaskPartitions(jobCfg, jobCtx, workflowConfig, workflowCtx, cache);
        Map<String, SortedSet<Integer>> taskAssignments = TaskRebalancer.getTaskPartitionAssignments(liveInstances, prevAssignment, allPartitions);
        long currentTime = System.currentTimeMillis();
        for (String instance : taskAssignments.keySet()) {
            Set pSet = taskAssignments.get(instance);
            TreeSet<Integer> donePartitions = new TreeSet<Integer>();
            Iterator i$ = pSet.iterator();
            block7: while (i$.hasNext()) {
                int pId = (Integer)i$.next();
                String pName = TaskRebalancer.pName(jobResource, pId);
                Message pendingMessage = currStateOutput.getPendingState(jobResource, new Partition(pName), instance);
                if (pendingMessage != null) {
                    Map<String, String> stateMap = prevAssignment.getReplicaMap(new Partition(pName));
                    if (stateMap == null) continue;
                    String prevState = stateMap.get(instance);
                    paMap.put(pId, new PartitionAssignment(instance, prevState));
                    assignedPartitions.add(pId);
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)String.format("Task partition %s has a pending state transition on instance %s. Using the previous ideal state which was %s.", pName, instance, prevState));
                    continue;
                }
                TaskPartitionState currState = TaskPartitionState.valueOf(currStateOutput.getCurrentState(jobResource, new Partition(pName), instance));
                jobCtx.setPartitionState(pId, currState);
                String requestedStateStr = currStateOutput.getRequestedState(jobResource, new Partition(pName), instance);
                if (requestedStateStr != null && !requestedStateStr.isEmpty()) {
                    TaskPartitionState requestedState = TaskPartitionState.valueOf(requestedStateStr);
                    if (requestedState.equals((Object)currState)) {
                        LOG.warn((Object)String.format("Requested state %s is the same as the current state for instance %s.", new Object[]{requestedState, instance}));
                    }
                    paMap.put(pId, new PartitionAssignment(instance, requestedState.name()));
                    assignedPartitions.add(pId);
                    LOG.debug((Object)String.format("Instance %s requested a state transition to %s for partition %s.", new Object[]{instance, requestedState, pName}));
                    continue;
                }
                switch (currState) {
                    case RUNNING: 
                    case STOPPED: {
                        TaskPartitionState nextState = jobTgtState == TargetState.START ? TaskPartitionState.RUNNING : TaskPartitionState.STOPPED;
                        paMap.put(pId, new PartitionAssignment(instance, nextState.name()));
                        assignedPartitions.add(pId);
                        LOG.debug((Object)String.format("Setting task partition %s state to %s on instance %s.", new Object[]{pName, nextState, instance}));
                        continue block7;
                    }
                    case COMPLETED: {
                        donePartitions.add(pId);
                        LOG.debug((Object)String.format("Task partition %s has completed with state %s. Marking as such in rebalancer context.", new Object[]{pName, currState}));
                        partitionsToDropFromIs.add(pId);
                        TaskRebalancer.markPartitionCompleted(jobCtx, pId);
                        continue block7;
                    }
                    case TIMED_OUT: 
                    case TASK_ERROR: 
                    case ERROR: {
                        donePartitions.add(pId);
                        LOG.debug((Object)String.format("Task partition %s has error state %s. Marking as such in rebalancer context.", new Object[]{pName, currState}));
                        TaskRebalancer.markPartitionError(jobCtx, pId, currState, true);
                        if (jobCtx.getPartitionNumAttempts(pId) >= jobCfg.getMaxAttemptsPerTask()) {
                            TaskConfig taskConfig;
                            boolean successOptional = false;
                            String taskId = jobCtx.getTaskIdForPartition(pId);
                            if (taskId != null && (taskConfig = jobCfg.getTaskConfig(taskId)) != null) {
                                successOptional = taskConfig.isSuccessOptional();
                            }
                            if (skippedPartitions.size() < jobCfg.getFailureThreshold()) {
                                successOptional = true;
                            }
                            if (!successOptional) {
                                long finishTime = currentTime;
                                workflowCtx.setJobState(jobResource, TaskState.FAILED);
                                if (workflowConfig.isTerminable()) {
                                    workflowCtx.setWorkflowState(TaskState.FAILED);
                                    workflowCtx.setFinishTime(finishTime);
                                }
                                jobCtx.setFinishTime(finishTime);
                                TaskRebalancer.markAllPartitionsError(jobCtx, currState, false);
                                TaskRebalancer.addAllPartitions(allPartitions, partitionsToDropFromIs);
                                return TaskRebalancer.emptyAssignment(jobResource, currStateOutput);
                            }
                            skippedPartitions.add(pId);
                            partitionsToDropFromIs.add(pId);
                            continue block7;
                        }
                        TaskRebalancer.markPartitionDelayed(jobCfg, jobCtx, pId);
                        continue block7;
                    }
                    case INIT: 
                    case DROPPED: {
                        donePartitions.add(pId);
                        LOG.debug((Object)String.format("Task partition %s has state %s. It will be dropped from the current ideal state.", new Object[]{pName, currState}));
                        continue block7;
                    }
                }
                throw new AssertionError((Object)("Unknown enum symbol: " + (Object)((Object)currState)));
            }
            pSet.removeAll(donePartitions);
        }
        this.scheduleForNextTask(jobResource, jobCtx, currentTime);
        if (TaskRebalancer.isJobComplete(jobCtx, allPartitions, skippedPartitions, jobCfg)) {
            workflowCtx.setJobState(jobResource, TaskState.COMPLETED);
            jobCtx.setFinishTime(currentTime);
            if (TaskRebalancer.isWorkflowComplete(workflowCtx, workflowConfig)) {
                workflowCtx.setWorkflowState(TaskState.COMPLETED);
                workflowCtx.setFinishTime(currentTime);
            }
        }
        if (jobTgtState == TargetState.START) {
            TreeSet excludeSet = Sets.newTreeSet(assignedPartitions);
            TaskRebalancer.addCompletedPartitions(excludeSet, jobCtx, allPartitions);
            TaskRebalancer.addGiveupPartitions(excludeSet, jobCtx, allPartitions, jobCfg);
            excludeSet.addAll(skippedPartitions);
            excludeSet.addAll(TaskRebalancer.getNonReadyPartitions(jobCtx, currentTime));
            Map<String, SortedSet<Integer>> tgtPartitionAssignments = this.getTaskAssignment(currStateOutput, prevAssignment, liveInstances, jobCfg, jobCtx, workflowConfig, workflowCtx, allPartitions, cache);
            for (Map.Entry<String, SortedSet<Integer>> entry : taskAssignments.entrySet()) {
                String instance = entry.getKey();
                if (!tgtPartitionAssignments.containsKey(instance)) continue;
                Set pSet = entry.getValue();
                int numToAssign = jobCfg.getNumConcurrentTasksPerInstance() - pSet.size();
                if (numToAssign <= 0) continue;
                List<Integer> nextPartitions = TaskRebalancer.getNextPartitions(tgtPartitionAssignments.get(instance), excludeSet, numToAssign);
                for (Integer pId : nextPartitions) {
                    String pName = TaskRebalancer.pName(jobResource, pId);
                    paMap.put(pId, new PartitionAssignment(instance, TaskPartitionState.RUNNING.name()));
                    excludeSet.add(pId);
                    jobCtx.setAssignedParticipant(pId, instance);
                    jobCtx.setPartitionState(pId, TaskPartitionState.INIT);
                    LOG.debug((Object)String.format("Setting task partition %s state to %s on instance %s.", new Object[]{pName, TaskPartitionState.RUNNING, instance}));
                }
            }
        }
        ResourceAssignment ra = new ResourceAssignment(jobResource);
        for (Map.Entry e : paMap.entrySet()) {
            PartitionAssignment pa = (PartitionAssignment)e.getValue();
            ra.addReplicaMap(new Partition(TaskRebalancer.pName(jobResource, (Integer)e.getKey())), (Map<String, String>)ImmutableMap.of((Object)pa._instance, (Object)pa._state));
        }
        return ra;
    }

    private boolean scheduleIfNotReady(WorkflowConfig workflowCfg, WorkflowContext workflowCtx, String workflowResource, String jobResource, ClusterDataCache cache) {
        if (workflowCfg == null || workflowCfg.getScheduleConfig() == null) {
            return true;
        }
        ScheduleConfig scheduleConfig = workflowCfg.getScheduleConfig();
        Date startTime = scheduleConfig.getStartTime();
        long currentTime = new Date().getTime();
        long delayFromStart = startTime.getTime() - currentTime;
        if (delayFromStart <= 0L) {
            Date scheduledTime = (Date)SCHEDULED_TIMES.get((Object)workflowResource);
            if (scheduledTime != null && currentTime > scheduledTime.getTime()) {
                SCHEDULED_TIMES.remove((Object)workflowResource);
            }
            if (scheduleConfig.isRecurring()) {
                WorkflowContext lastWorkflowCtx;
                if (!workflowCfg.getTargetState().equals((Object)TargetState.START)) {
                    return false;
                }
                String lastScheduled = workflowCtx.getLastScheduledSingleWorkflow();
                if (lastScheduled != null && ((lastWorkflowCtx = TaskUtil.getWorkflowContext(this._manager, lastScheduled)) == null || lastWorkflowCtx.getFinishTime() == -1L)) {
                    return false;
                }
                long period = scheduleConfig.getRecurrenceUnit().toMillis(scheduleConfig.getRecurrenceInterval());
                long offsetMultiplier = -delayFromStart / period;
                long timeToSchedule = period * offsetMultiplier + startTime.getTime();
                String newWorkflowName = workflowResource + "_" + "SCHEDULED" + "_" + offsetMultiplier;
                if (lastScheduled == null || !lastScheduled.equals(newWorkflowName)) {
                    Workflow clonedWf = TaskUtil.cloneWorkflow(this._manager, workflowResource, newWorkflowName, new Date(timeToSchedule));
                    TaskDriver driver = new TaskDriver(this._manager);
                    try {
                        driver.start(clonedWf);
                    }
                    catch (Exception e) {
                        LOG.error((Object)("Failed to schedule cloned workflow " + newWorkflowName), (Throwable)e);
                    }
                    workflowCtx.setLastScheduledSingleWorkflow(newWorkflowName);
                    TaskUtil.setWorkflowContext(this._manager, workflowResource, workflowCtx);
                }
                startTime = new Date(timeToSchedule + period);
                delayFromStart = startTime.getTime() - System.currentTimeMillis();
            } else {
                return true;
            }
        }
        if (SCHEDULED_TIMES.containsKey((Object)workflowResource) || SCHEDULED_TIMES.inverse().containsKey((Object)startTime)) {
            return false;
        }
        this.scheduleRebalance(workflowResource, jobResource, startTime, delayFromStart);
        return false;
    }

    private void scheduleRebalance(String id, String jobResource, Date startTime, long delayFromStart) {
        if (SCHEDULED_TIMES.containsKey((Object)id) || SCHEDULED_TIMES.inverse().containsKey((Object)startTime)) {
            return;
        }
        RebalanceInvoker rebalanceInvoker = new RebalanceInvoker(this._manager, jobResource);
        SCHEDULED_TIMES.put((Object)id, (Object)startTime);
        SCHEDULED_EXECUTOR.schedule(rebalanceInvoker, delayFromStart, TimeUnit.MILLISECONDS);
    }

    private void scheduleForNextTask(String jobResource, JobContext ctx, long now) {
        long currentTime = now;
        Date scheduledTime = (Date)SCHEDULED_TIMES.get((Object)jobResource);
        if (scheduledTime != null && currentTime > scheduledTime.getTime()) {
            SCHEDULED_TIMES.remove((Object)jobResource);
        }
        boolean shouldSchedule = false;
        long earliestTime = Long.MAX_VALUE;
        for (int p : ctx.getPartitionSet()) {
            long retryTime = ctx.getNextRetryTime(p);
            TaskPartitionState state = ctx.getPartitionState(p);
            TaskPartitionState taskPartitionState = state = state != null ? state : TaskPartitionState.INIT;
            HashSet errorStates = Sets.newHashSet((Object[])new TaskPartitionState[]{TaskPartitionState.ERROR, TaskPartitionState.TASK_ERROR, TaskPartitionState.TIMED_OUT});
            if (!errorStates.contains((Object)state) || retryTime <= currentTime || retryTime >= earliestTime) continue;
            earliestTime = retryTime;
            shouldSchedule = true;
        }
        if (shouldSchedule) {
            long delay = earliestTime - currentTime;
            Date startTime = new Date(earliestTime);
            this.scheduleRebalance(jobResource, jobResource, startTime, delay);
        }
    }

    private static boolean isJobComplete(JobContext ctx, Set<Integer> allPartitions, Set<Integer> skippedPartitions, JobConfig cfg) {
        for (Integer pId : allPartitions) {
            TaskPartitionState state = ctx.getPartitionState(pId);
            if (skippedPartitions.contains(pId) || state == TaskPartitionState.COMPLETED || TaskRebalancer.isTaskGivenup(ctx, cfg, pId)) continue;
            return false;
        }
        return true;
    }

    private static boolean isWorkflowComplete(WorkflowContext ctx, WorkflowConfig cfg) {
        if (!cfg.isTerminable()) {
            return false;
        }
        for (String job : cfg.getJobDag().getAllNodes()) {
            if (ctx.getJobState(job) == TaskState.COMPLETED) continue;
            return false;
        }
        return true;
    }

    private static boolean isWorkflowStopped(WorkflowContext ctx, WorkflowConfig cfg) {
        for (String job : cfg.getJobDag().getAllNodes()) {
            if (ctx.getJobState(job) == TaskState.STOPPED || ctx.getJobState(job) == null) continue;
            return false;
        }
        return true;
    }

    private static void markForDeletion(HelixManager mgr, String resourceName) {
        mgr.getConfigAccessor().set(TaskUtil.getResourceConfigScope(mgr.getClusterName(), resourceName), "TargetState", TargetState.DELETE.name());
    }

    private static void cleanup(HelixManager mgr, final String resourceName, WorkflowConfig cfg, String workflowResource) {
        HelixDataAccessor accessor = mgr.getHelixDataAccessor();
        PropertyKey workflowKey = TaskRebalancer.getConfigPropertyKey(accessor, workflowResource);
        DataUpdater<ZNRecord> dagRemover = new DataUpdater<ZNRecord>(){

            public ZNRecord update(ZNRecord currentData) {
                JobDag jobDag = JobDag.fromJson(currentData.getSimpleField("Dag"));
                for (String child : jobDag.getDirectChildren(resourceName)) {
                    jobDag.getChildrenToParents().get(child).remove(resourceName);
                }
                for (String parent : jobDag.getDirectParents(resourceName)) {
                    jobDag.getParentsToChildren().get(parent).remove(resourceName);
                }
                jobDag.getChildrenToParents().remove(resourceName);
                jobDag.getParentsToChildren().remove(resourceName);
                jobDag.getAllNodes().remove(resourceName);
                try {
                    currentData.setSimpleField("Dag", jobDag.toJson());
                }
                catch (Exception e) {
                    LOG.equals("Could not update DAG for job " + resourceName);
                }
                return currentData;
            }
        };
        accessor.getBaseDataAccessor().update(workflowKey.getPath(), dagRemover, AccessOption.PERSISTENT);
        PropertyKey cfgKey = TaskRebalancer.getConfigPropertyKey(accessor, resourceName);
        if (!accessor.removeProperty(cfgKey)) {
            throw new RuntimeException(String.format("Error occurred while trying to clean up job %s. Failed to remove node %s from Helix. Aborting further clean up steps.", resourceName, cfgKey));
        }
        String propStoreKey = TaskRebalancer.getRebalancerPropStoreKey(resourceName);
        if (!mgr.getHelixPropertyStore().remove(propStoreKey, AccessOption.PERSISTENT)) {
            throw new RuntimeException(String.format("Error occurred while trying to clean up job %s. Failed to remove node %s from Helix. Aborting further clean up steps.", resourceName, propStoreKey));
        }
        PropertyKey isKey = TaskRebalancer.getISPropertyKey(accessor, resourceName);
        if (!accessor.removeProperty(isKey)) {
            throw new RuntimeException(String.format("Error occurred while trying to clean up task %s. Failed to remove node %s from Helix.", resourceName, isKey));
        }
        LOG.info((Object)String.format("Successfully cleaned up job resource %s.", resourceName));
        boolean lastInWorkflow = true;
        for (String job : cfg.getJobDag().getAllNodes()) {
            if (!mgr.getHelixPropertyStore().exists(TaskRebalancer.getRebalancerPropStoreKey(job), AccessOption.PERSISTENT) && accessor.getProperty(TaskRebalancer.getConfigPropertyKey(accessor, job)) == null && accessor.getProperty(TaskRebalancer.getISPropertyKey(accessor, job)) == null) continue;
            lastInWorkflow = false;
        }
        if (lastInWorkflow && cfg.isTerminable()) {
            PropertyKey workflowCfgKey = TaskRebalancer.getConfigPropertyKey(accessor, workflowResource);
            if (!accessor.removeProperty(workflowCfgKey)) {
                throw new RuntimeException(String.format("Error occurred while trying to clean up workflow %s. Failed to remove node %s from Helix. Aborting further clean up steps.", workflowResource, workflowCfgKey));
            }
            String workflowPropStoreKey = TaskRebalancer.getRebalancerPropStoreKey(workflowResource);
            if (!mgr.getHelixPropertyStore().remove(workflowPropStoreKey, AccessOption.PERSISTENT)) {
                throw new RuntimeException(String.format("Error occurred while trying to clean up workflow %s. Failed to remove node %s from Helix. Aborting further clean up steps.", workflowResource, workflowPropStoreKey));
            }
        }
    }

    private static String getRebalancerPropStoreKey(String resource) {
        return Joiner.on((String)"/").join((Object)"/TaskRebalancer", (Object)resource, new Object[0]);
    }

    private static PropertyKey getISPropertyKey(HelixDataAccessor accessor, String resource) {
        return accessor.keyBuilder().idealStates(resource);
    }

    private static PropertyKey getConfigPropertyKey(HelixDataAccessor accessor, String resource) {
        return accessor.keyBuilder().resourceConfig(resource);
    }

    private static void addAllPartitions(Set<Integer> toAdd, Set<Integer> destination) {
        for (Integer pId : toAdd) {
            destination.add(pId);
        }
    }

    private static ResourceAssignment emptyAssignment(String name, CurrentStateOutput currStateOutput) {
        ResourceAssignment assignment = new ResourceAssignment(name);
        Set<Partition> partitions = currStateOutput.getCurrentStateMappedPartitions(name);
        for (Partition partition : partitions) {
            Map<String, String> currentStateMap = currStateOutput.getCurrentStateMap(name, partition);
            HashMap replicaMap = Maps.newHashMap();
            for (String instanceName : currentStateMap.keySet()) {
                replicaMap.put(instanceName, HelixDefinedState.DROPPED.toString());
            }
            assignment.addReplicaMap(partition, replicaMap);
        }
        return assignment;
    }

    private static void addCompletedPartitions(Set<Integer> set, JobContext ctx, Iterable<Integer> pIds) {
        for (Integer pId : pIds) {
            TaskPartitionState state = ctx.getPartitionState(pId);
            if (state != TaskPartitionState.COMPLETED) continue;
            set.add(pId);
        }
    }

    private static boolean isTaskGivenup(JobContext ctx, JobConfig cfg, int pId) {
        return ctx.getPartitionNumAttempts(pId) >= cfg.getMaxAttemptsPerTask();
    }

    private static void addGiveupPartitions(Set<Integer> set, JobContext ctx, Iterable<Integer> pIds, JobConfig cfg) {
        for (Integer pId : pIds) {
            if (!TaskRebalancer.isTaskGivenup(ctx, cfg, pId)) continue;
            set.add(pId);
        }
    }

    private static List<Integer> getNextPartitions(SortedSet<Integer> candidatePartitions, Set<Integer> excluded, int n) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (Integer pId : candidatePartitions) {
            if (result.size() >= n) break;
            if (excluded.contains(pId)) continue;
            result.add(pId);
        }
        return result;
    }

    private static void markPartitionDelayed(JobConfig cfg, JobContext ctx, int p) {
        long delayInterval = cfg.getTaskRetryDelay();
        if (delayInterval <= 0L) {
            return;
        }
        long nextStartTime = ctx.getPartitionFinishTime(p) + delayInterval;
        ctx.setNextRetryTime(p, nextStartTime);
    }

    private static void markPartitionCompleted(JobContext ctx, int pId) {
        ctx.setPartitionState(pId, TaskPartitionState.COMPLETED);
        ctx.setPartitionFinishTime(pId, System.currentTimeMillis());
        ctx.incrementNumAttempts(pId);
    }

    private static void markPartitionError(JobContext ctx, int pId, TaskPartitionState state, boolean incrementAttempts) {
        ctx.setPartitionState(pId, state);
        ctx.setPartitionFinishTime(pId, System.currentTimeMillis());
        if (incrementAttempts) {
            ctx.incrementNumAttempts(pId);
        }
    }

    private static void markAllPartitionsError(JobContext ctx, TaskPartitionState state, boolean incrementAttempts) {
        for (int pId : ctx.getPartitionSet()) {
            TaskRebalancer.markPartitionError(ctx, pId, state, incrementAttempts);
        }
    }

    private static Map<String, SortedSet<Integer>> getTaskPartitionAssignments(Iterable<String> instanceList, ResourceAssignment assignment, Set<Integer> includeSet) {
        HashMap<String, SortedSet<Integer>> result = new HashMap<String, SortedSet<Integer>>();
        for (String instance : instanceList) {
            result.put(instance, new TreeSet());
        }
        for (Partition partition : assignment.getMappedPartitions()) {
            int pId = TaskRebalancer.pId(partition.getPartitionName());
            if (!includeSet.contains(pId)) continue;
            Map<String, String> replicaMap = assignment.getReplicaMap(partition);
            for (String instance : replicaMap.keySet()) {
                SortedSet pList = (SortedSet)result.get(instance);
                if (pList == null) continue;
                pList.add(pId);
            }
        }
        return result;
    }

    private static Set<Integer> getNonReadyPartitions(JobContext ctx, long now) {
        HashSet nonReadyPartitions = Sets.newHashSet();
        for (int p : ctx.getPartitionSet()) {
            long toStart = ctx.getNextRetryTime(p);
            if (now >= toStart) continue;
            nonReadyPartitions.add(p);
        }
        return nonReadyPartitions;
    }

    protected static String pName(String resource, int pId) {
        return resource + "_" + pId;
    }

    protected static int pId(String pName) {
        String[] tokens = pName.split("_");
        return Integer.valueOf(tokens[tokens.length - 1]);
    }

    @Override
    public IdealState computeNewIdealState(String resourceName, IdealState currentIdealState, CurrentStateOutput currentStateOutput, ClusterDataCache clusterData) {
        return currentIdealState;
    }

    private static class RebalanceInvoker
    implements Runnable {
        private final HelixManager _manager;
        private final String _resource;

        public RebalanceInvoker(HelixManager manager, String resource) {
            this._manager = manager;
            this._resource = resource;
        }

        @Override
        public void run() {
            TaskUtil.invokeRebalance(this._manager, this._resource);
        }
    }

    private static class PartitionAssignment {
        private final String _instance;
        private final String _state;

        private PartitionAssignment(String instance, String state) {
            this._instance = instance;
            this._state = state;
        }
    }
}

