/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.relocated.freemarker.cache;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.ServletContext;
import org.uberfire.relocated.freemarker.cache.TemplateLoader;
import org.uberfire.relocated.freemarker.cache.URLTemplateSource;
import org.uberfire.relocated.freemarker.log.Logger;
import org.uberfire.relocated.freemarker.template.utility.StringUtil;

public class WebappTemplateLoader
implements TemplateLoader {
    private static final Logger logger = Logger.getLogger("org.uberfire.relocated.freemarker.cache");
    private final ServletContext servletContext;
    private final String path;

    public WebappTemplateLoader(ServletContext servletContext) {
        this(servletContext, "/");
    }

    public WebappTemplateLoader(ServletContext servletContext, String path) {
        if (servletContext == null) {
            throw new IllegalArgumentException("servletContext == null");
        }
        if (path == null) {
            throw new IllegalArgumentException("path == null");
        }
        if (!(path = path.replace('\\', '/')).endsWith("/")) {
            path = path + "/";
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        this.path = path;
        this.servletContext = servletContext;
    }

    public Object findTemplateSource(String name) throws IOException {
        String fullPath = this.path + name;
        try {
            String realPath = this.servletContext.getRealPath(fullPath);
            if (realPath != null) {
                File file = new File(realPath);
                if (!file.isFile()) {
                    return null;
                }
                if (file.canRead()) {
                    return file;
                }
            }
        }
        catch (SecurityException e) {
            // empty catch block
        }
        URL url = null;
        try {
            url = this.servletContext.getResource(fullPath);
        }
        catch (MalformedURLException e) {
            logger.warn("Could not retrieve resource " + StringUtil.jQuoteNoXSS(fullPath), e);
            return null;
        }
        return url == null ? null : new URLTemplateSource(url);
    }

    public long getLastModified(Object templateSource) {
        if (templateSource instanceof File) {
            return ((File)templateSource).lastModified();
        }
        return ((URLTemplateSource)templateSource).lastModified();
    }

    public Reader getReader(Object templateSource, String encoding) throws IOException {
        if (templateSource instanceof File) {
            return new InputStreamReader((InputStream)new FileInputStream((File)templateSource), encoding);
        }
        return new InputStreamReader(((URLTemplateSource)templateSource).getInputStream(), encoding);
    }

    public void closeTemplateSource(Object templateSource) throws IOException {
        if (!(templateSource instanceof File)) {
            ((URLTemplateSource)templateSource).close();
        }
    }
}

