/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.relocated.freemarker.ext.jython;

import org.python.core.PyException;
import org.python.core.PyObject;
import org.uberfire.relocated.freemarker.ext.jython.JythonModel;
import org.uberfire.relocated.freemarker.ext.jython.JythonVersionAdapter;
import org.uberfire.relocated.freemarker.ext.jython.JythonWrapper;
import org.uberfire.relocated.freemarker.ext.util.ModelFactory;
import org.uberfire.relocated.freemarker.template.ObjectWrapper;
import org.uberfire.relocated.freemarker.template.TemplateCollectionModel;
import org.uberfire.relocated.freemarker.template.TemplateHashModelEx;
import org.uberfire.relocated.freemarker.template.TemplateModel;
import org.uberfire.relocated.freemarker.template.TemplateModelException;

public class JythonHashModel
extends JythonModel
implements TemplateHashModelEx {
    private static final String KEYS = "keys";
    private static final String KEYSET = "keySet";
    private static final String VALUES = "values";
    static final ModelFactory FACTORY = new ModelFactory(){

        public TemplateModel create(Object object, ObjectWrapper wrapper) {
            return new JythonHashModel((PyObject)object, (JythonWrapper)wrapper);
        }
    };

    public JythonHashModel(PyObject object, JythonWrapper wrapper) {
        super(object, wrapper);
    }

    public int size() throws TemplateModelException {
        try {
            return this.object.__len__();
        }
        catch (PyException e) {
            throw new TemplateModelException((Exception)((Object)e));
        }
    }

    public TemplateCollectionModel keys() throws TemplateModelException {
        try {
            PyObject method = this.object.__findattr__(KEYS);
            if (method == null) {
                method = this.object.__findattr__(KEYSET);
            }
            if (method != null) {
                return (TemplateCollectionModel)this.wrapper.wrap(method.__call__());
            }
        }
        catch (PyException e) {
            throw new TemplateModelException((Exception)((Object)e));
        }
        throw new TemplateModelException("'?keys' is not supported as there is no 'keys' nor 'keySet' attribute on an instance of " + JythonVersionAdapter.getInstance().getPythonClassName(this.object));
    }

    public TemplateCollectionModel values() throws TemplateModelException {
        try {
            PyObject method = this.object.__findattr__(VALUES);
            if (method != null) {
                return (TemplateCollectionModel)this.wrapper.wrap(method.__call__());
            }
        }
        catch (PyException e) {
            throw new TemplateModelException((Exception)((Object)e));
        }
        throw new TemplateModelException("'?values' is not supported as there is no 'values' attribute on an instance of " + JythonVersionAdapter.getInstance().getPythonClassName(this.object));
    }
}

