/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.relocated.freemarker.core;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.uberfire.relocated.freemarker.core.AddConcatExpression;
import org.uberfire.relocated.freemarker.core.AndExpression;
import org.uberfire.relocated.freemarker.core.ArithmeticExpression;
import org.uberfire.relocated.freemarker.core.Assignment;
import org.uberfire.relocated.freemarker.core.AssignmentInstruction;
import org.uberfire.relocated.freemarker.core.AttemptBlock;
import org.uberfire.relocated.freemarker.core.BlockAssignment;
import org.uberfire.relocated.freemarker.core.BodyInstruction;
import org.uberfire.relocated.freemarker.core.BooleanLiteral;
import org.uberfire.relocated.freemarker.core.BreakInstruction;
import org.uberfire.relocated.freemarker.core.BuiltIn;
import org.uberfire.relocated.freemarker.core.BuiltinVariable;
import org.uberfire.relocated.freemarker.core.Case;
import org.uberfire.relocated.freemarker.core.Comment;
import org.uberfire.relocated.freemarker.core.ComparisonExpression;
import org.uberfire.relocated.freemarker.core.CompressedBlock;
import org.uberfire.relocated.freemarker.core.ConditionalBlock;
import org.uberfire.relocated.freemarker.core.DefaultToExpression;
import org.uberfire.relocated.freemarker.core.DollarVariable;
import org.uberfire.relocated.freemarker.core.Dot;
import org.uberfire.relocated.freemarker.core.DynamicKeyName;
import org.uberfire.relocated.freemarker.core.EscapeBlock;
import org.uberfire.relocated.freemarker.core.ExistsExpression;
import org.uberfire.relocated.freemarker.core.Expression;
import org.uberfire.relocated.freemarker.core.FMParserConstants;
import org.uberfire.relocated.freemarker.core.FMParserTokenManager;
import org.uberfire.relocated.freemarker.core.FallbackInstruction;
import org.uberfire.relocated.freemarker.core.FlushInstruction;
import org.uberfire.relocated.freemarker.core.HashLiteral;
import org.uberfire.relocated.freemarker.core.Identifier;
import org.uberfire.relocated.freemarker.core.IfBlock;
import org.uberfire.relocated.freemarker.core.Include;
import org.uberfire.relocated.freemarker.core.IteratorBlock;
import org.uberfire.relocated.freemarker.core.LibraryLoad;
import org.uberfire.relocated.freemarker.core.ListLiteral;
import org.uberfire.relocated.freemarker.core.Macro;
import org.uberfire.relocated.freemarker.core.MethodCall;
import org.uberfire.relocated.freemarker.core.MixedContent;
import org.uberfire.relocated.freemarker.core.NoEscapeBlock;
import org.uberfire.relocated.freemarker.core.NotExpression;
import org.uberfire.relocated.freemarker.core.NumberLiteral;
import org.uberfire.relocated.freemarker.core.NumericalOutput;
import org.uberfire.relocated.freemarker.core.OrExpression;
import org.uberfire.relocated.freemarker.core.ParentheticalExpression;
import org.uberfire.relocated.freemarker.core.ParseException;
import org.uberfire.relocated.freemarker.core.PropertySetting;
import org.uberfire.relocated.freemarker.core.Range;
import org.uberfire.relocated.freemarker.core.RecoveryBlock;
import org.uberfire.relocated.freemarker.core.RecurseNode;
import org.uberfire.relocated.freemarker.core.ReturnInstruction;
import org.uberfire.relocated.freemarker.core.SimpleCharStream;
import org.uberfire.relocated.freemarker.core.StopInstruction;
import org.uberfire.relocated.freemarker.core.StringLiteral;
import org.uberfire.relocated.freemarker.core.SwitchBlock;
import org.uberfire.relocated.freemarker.core.TemplateElement;
import org.uberfire.relocated.freemarker.core.TemplateObject;
import org.uberfire.relocated.freemarker.core.TextBlock;
import org.uberfire.relocated.freemarker.core.Token;
import org.uberfire.relocated.freemarker.core.TransformBlock;
import org.uberfire.relocated.freemarker.core.TrimInstruction;
import org.uberfire.relocated.freemarker.core.UnaryPlusMinusExpression;
import org.uberfire.relocated.freemarker.core.UnifiedCall;
import org.uberfire.relocated.freemarker.core.VisitNode;
import org.uberfire.relocated.freemarker.template.Configuration;
import org.uberfire.relocated.freemarker.template.Template;
import org.uberfire.relocated.freemarker.template.TemplateBooleanModel;
import org.uberfire.relocated.freemarker.template.TemplateHashModelEx;
import org.uberfire.relocated.freemarker.template.TemplateModel;
import org.uberfire.relocated.freemarker.template.TemplateModelException;
import org.uberfire.relocated.freemarker.template.TemplateScalarModel;
import org.uberfire.relocated.freemarker.template.utility.DeepUnwrap;
import org.uberfire.relocated.freemarker.template.utility.StringUtil;

public class FMParser
implements FMParserConstants {
    Template template;
    private String templateName;
    private int loopNesting;
    private int switchNesting;
    private boolean inMacro;
    private boolean inFunction;
    private boolean stripWhitespace;
    private boolean stripText;
    private LinkedList escapes = new LinkedList();
    private int contentNesting;
    public FMParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    public boolean lookingAhead = false;
    private boolean jj_semLA;
    private int jj_gen;
    private final int[] jj_la1 = new int[83];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private static int[] jj_la1_3;
    private static int[] jj_la1_4;
    private final JJCalls[] jj_2_rtns = new JJCalls[17];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public static FMParser createExpressionParser(String s) {
        SimpleCharStream scs = new SimpleCharStream(new StringReader(s), 1, 1, s.length());
        FMParserTokenManager token_source = new FMParserTokenManager(scs);
        token_source.SwitchTo(2);
        return new FMParser(token_source);
    }

    public FMParser(Template template, Reader reader, boolean strictEscapeSyntax, boolean stripWhitespace) {
        this(reader);
        this.template = template;
        this.token_source.strictEscapeSyntax = strictEscapeSyntax;
        this.token_source.templateName = this.templateName = template != null ? template.getName() : "";
        this.stripWhitespace = stripWhitespace;
    }

    public FMParser(Template template, Reader reader, boolean strictEscapeSyntax, boolean stripWhitespace, int tagSyntax) {
        this(template, reader, strictEscapeSyntax, stripWhitespace, tagSyntax, Configuration.PARSED_DEFAULT_INCOMPATIBLE_ENHANCEMENTS);
    }

    public FMParser(Template template, Reader reader, boolean strictEscapeSyntax, boolean stripWhitespace, int tagSyntax, int incompatibleChanges) {
        this(template, reader, strictEscapeSyntax, stripWhitespace);
        switch (tagSyntax) {
            case 0: {
                this.token_source.autodetectTagSyntax = true;
                break;
            }
            case 1: {
                this.token_source.altDirectiveSyntax = false;
                break;
            }
            case 2: {
                this.token_source.altDirectiveSyntax = true;
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal argument for tagSyntax");
            }
        }
        this.token_source.incompatibleChanges = incompatibleChanges;
    }

    public FMParser(String template) {
        this(null, new StringReader(template), true, true);
    }

    private String getErrorStart(Token t) {
        return "Error in template: " + this.template.getName() + "\non line " + t.beginLine + ", column " + t.beginColumn;
    }

    private void notStringLiteral(Expression exp, String expected) throws ParseException {
        if (exp instanceof StringLiteral) {
            String msg = "Error " + exp.getStartLocation() + "\nFound string literal: " + exp + "\nExpecting: " + expected;
            throw new ParseException(msg, exp);
        }
    }

    private void notNumberLiteral(Expression exp, String expected) throws ParseException {
        if (exp instanceof NumberLiteral) {
            String msg = "Error " + exp.getStartLocation() + "\nFound number literal: " + exp.getCanonicalForm() + "\nExpecting " + expected;
            throw new ParseException(msg, exp);
        }
    }

    private void notBooleanLiteral(Expression exp, String expected) throws ParseException {
        if (exp instanceof BooleanLiteral) {
            String msg = "Error " + exp.getStartLocation() + "\nFound: " + exp.getCanonicalForm() + "\nExpecting " + expected;
            throw new ParseException(msg, exp);
        }
    }

    private void notHashLiteral(Expression exp, String expected) throws ParseException {
        if (exp instanceof HashLiteral) {
            String msg = "Error " + exp.getStartLocation() + "\nFound hash literal: " + exp.getCanonicalForm() + "\nExpecting " + expected;
            throw new ParseException(msg, exp);
        }
    }

    private void notListLiteral(Expression exp, String expected) throws ParseException {
        if (exp instanceof ListLiteral) {
            String msg = "Error " + exp.getStartLocation() + "\nFound list literal: " + exp.getCanonicalForm() + "\nExpecting " + expected;
            throw new ParseException(msg, exp);
        }
    }

    private void numberLiteralOnly(Expression exp) throws ParseException {
        this.notStringLiteral(exp, "number");
        this.notListLiteral(exp, "number");
        this.notHashLiteral(exp, "number");
        this.notBooleanLiteral(exp, "number");
    }

    private void stringLiteralOnly(Expression exp) throws ParseException {
        this.notNumberLiteral(exp, "number");
        this.notListLiteral(exp, "number");
        this.notHashLiteral(exp, "number");
        this.notBooleanLiteral(exp, "number");
    }

    private void booleanLiteralOnly(Expression exp) throws ParseException {
        this.notStringLiteral(exp, "boolean (true/false)");
        this.notListLiteral(exp, "boolean (true/false)");
        this.notHashLiteral(exp, "boolean (true/false)");
        this.notNumberLiteral(exp, "boolean (true/false)");
    }

    private Expression escapedExpression(Expression exp) {
        if (!this.escapes.isEmpty()) {
            return ((EscapeBlock)this.escapes.getFirst()).doEscape(exp);
        }
        return exp;
    }

    private boolean getBoolean(Expression exp) throws ParseException {
        TemplateModel tm = null;
        try {
            tm = exp.getAsTemplateModel(null);
        }
        catch (Exception e) {
            throw new ParseException(e.getMessage() + "\nCould not evaluate expression: " + exp.getCanonicalForm() + exp.getStartLocation(), exp);
        }
        if (tm instanceof TemplateBooleanModel) {
            try {
                return ((TemplateBooleanModel)tm).getAsBoolean();
            }
            catch (TemplateModelException tme) {
                // empty catch block
            }
        }
        if (tm instanceof TemplateScalarModel) {
            try {
                return StringUtil.getYesNo(((TemplateScalarModel)tm).getAsString());
            }
            catch (Exception e) {
                throw new ParseException(e.getMessage() + "\nExpecting yes/no, found: " + exp.getCanonicalForm() + exp.getStartLocation(), exp);
            }
        }
        throw new ParseException("Expecting boolean (yes/no) parameter" + exp.getStartLocation(), exp);
    }

    public final Expression Expression() throws ParseException {
        Expression exp = this.OrExpression();
        return exp;
    }

    public final Expression PrimaryExpression() throws ParseException {
        Expression exp;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 85: 
            case 86: {
                exp = this.NumberLiteral();
                break;
            }
            case 115: {
                exp = this.HashLiteral();
                break;
            }
            case 81: 
            case 82: {
                exp = this.StringLiteral(true);
                break;
            }
            case 83: 
            case 84: {
                exp = this.BooleanLiteral();
                break;
            }
            case 111: {
                exp = this.ListLiteral();
                break;
            }
            case 120: {
                exp = this.Identifier();
                break;
            }
            case 113: {
                exp = this.Parenthesis();
                break;
            }
            case 87: {
                exp = this.BuiltinVariable();
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        while (this.jj_2_1(Integer.MAX_VALUE)) {
            exp = this.AddSubExpression(exp);
        }
        return exp;
    }

    public final Expression Parenthesis() throws ParseException {
        Token start = this.jj_consume_token(113);
        Expression exp = this.Expression();
        Token end = this.jj_consume_token(114);
        ParentheticalExpression result = new ParentheticalExpression(exp);
        result.setLocation(this.template, start, end);
        return result;
    }

    public final Expression UnaryExpression() throws ParseException {
        Expression result;
        boolean haveNot = false;
        Object t = null;
        Object start = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 98: 
            case 99: {
                result = this.UnaryPlusMinusExpression();
                break;
            }
            case 107: {
                result = this.NotExpression();
                break;
            }
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 111: 
            case 113: 
            case 115: 
            case 120: {
                result = this.PrimaryExpression();
                break;
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return result;
    }

    public final Expression NotExpression() throws ParseException {
        NotExpression result = null;
        ArrayList<Token> nots = new ArrayList<Token>();
        block3: while (true) {
            Token t = this.jj_consume_token(107);
            nots.add(t);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 107: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[2] = this.jj_gen;
        Expression exp = this.PrimaryExpression();
        for (int i = 0; i < nots.size(); ++i) {
            result = new NotExpression(exp);
            Token tok = (Token)nots.get(nots.size() - i - 1);
            result.setLocation(this.template, tok, (TemplateObject)exp);
            exp = result;
        }
        return result;
    }

    public final Expression UnaryPlusMinusExpression() throws ParseException {
        Token t;
        boolean isMinus = false;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 98: {
                t = this.jj_consume_token(98);
                break;
            }
            case 99: {
                t = this.jj_consume_token(99);
                isMinus = true;
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        Expression exp = this.PrimaryExpression();
        UnaryPlusMinusExpression result = new UnaryPlusMinusExpression(exp, isMinus);
        result.setLocation(this.template, t, (TemplateObject)exp);
        return result;
    }

    public final Expression AdditiveExpression() throws ParseException {
        Expression lhs;
        Expression result = lhs = this.MultiplicativeExpression();
        while (this.jj_2_2(Integer.MAX_VALUE)) {
            boolean plus;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 98: {
                    this.jj_consume_token(98);
                    plus = true;
                    break;
                }
                case 99: {
                    this.jj_consume_token(99);
                    plus = false;
                    break;
                }
                default: {
                    this.jj_la1[4] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            Expression rhs = this.MultiplicativeExpression();
            if (plus) {
                result = new AddConcatExpression(lhs, rhs);
            } else {
                this.numberLiteralOnly(lhs);
                this.numberLiteralOnly(rhs);
                result = new ArithmeticExpression(lhs, rhs, 0);
            }
            result.setLocation(this.template, (TemplateObject)lhs, (TemplateObject)rhs);
            lhs = result;
        }
        return result;
    }

    public final Expression MultiplicativeExpression() throws ParseException {
        Expression lhs;
        int operation = 1;
        Expression result = lhs = this.UnaryExpression();
        while (this.jj_2_3(Integer.MAX_VALUE)) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 100: {
                    this.jj_consume_token(100);
                    operation = 1;
                    break;
                }
                case 103: {
                    this.jj_consume_token(103);
                    operation = 2;
                    break;
                }
                case 104: {
                    this.jj_consume_token(104);
                    operation = 3;
                    break;
                }
                default: {
                    this.jj_la1[5] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            Expression rhs = this.UnaryExpression();
            this.numberLiteralOnly(lhs);
            this.numberLiteralOnly(rhs);
            result = new ArithmeticExpression(lhs, rhs, operation);
            result.setLocation(this.template, (TemplateObject)lhs, (TemplateObject)rhs);
            lhs = result;
        }
        return result;
    }

    public final Expression EqualityExpression() throws ParseException {
        Expression lhs;
        Expression result = lhs = this.RelationalExpression();
        if (this.jj_2_4(Integer.MAX_VALUE)) {
            Token t;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 93: {
                    t = this.jj_consume_token(93);
                    break;
                }
                case 91: {
                    t = this.jj_consume_token(91);
                    break;
                }
                case 92: {
                    t = this.jj_consume_token(92);
                    break;
                }
                default: {
                    this.jj_la1[6] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            Expression rhs = this.RelationalExpression();
            this.notHashLiteral(lhs, "scalar");
            this.notHashLiteral(rhs, "scalar");
            this.notListLiteral(lhs, "scalar");
            this.notListLiteral(rhs, "scalar");
            result = new ComparisonExpression(lhs, rhs, t.image);
            result.setLocation(this.template, (TemplateObject)lhs, (TemplateObject)rhs);
        }
        return result;
    }

    public final Expression RelationalExpression() throws ParseException {
        Expression lhs;
        Expression result = lhs = this.RangeExpression();
        if (this.jj_2_5(Integer.MAX_VALUE)) {
            Token t;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 126: {
                    t = this.jj_consume_token(126);
                    break;
                }
                case 97: {
                    t = this.jj_consume_token(97);
                    break;
                }
                case 125: {
                    t = this.jj_consume_token(125);
                    break;
                }
                case 96: {
                    t = this.jj_consume_token(96);
                    break;
                }
                case 95: {
                    t = this.jj_consume_token(95);
                    break;
                }
                case 94: {
                    t = this.jj_consume_token(94);
                    break;
                }
                default: {
                    this.jj_la1[7] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            Expression rhs = this.RangeExpression();
            this.notHashLiteral(lhs, "scalar");
            this.notHashLiteral(rhs, "scalar");
            this.notListLiteral(lhs, "scalar");
            this.notListLiteral(rhs, "scalar");
            this.notStringLiteral(lhs, "number");
            this.notStringLiteral(rhs, "number");
            result = new ComparisonExpression(lhs, rhs, t.image);
            result.setLocation(this.template, (TemplateObject)lhs, (TemplateObject)rhs);
        }
        return result;
    }

    public final Expression RangeExpression() throws ParseException {
        Expression lhs;
        Expression rhs = null;
        Expression result = lhs = this.AdditiveExpression();
        if (this.jj_2_7(Integer.MAX_VALUE)) {
            this.jj_consume_token(88);
            if (this.jj_2_6(Integer.MAX_VALUE)) {
                rhs = this.AdditiveExpression();
            }
            this.numberLiteralOnly(lhs);
            if (rhs != null) {
                this.numberLiteralOnly(rhs);
            }
            Range range = new Range(lhs, rhs);
            if (rhs != null) {
                range.setLocation(this.template, (TemplateObject)lhs, (TemplateObject)rhs);
            } else {
                range.setLocation(this.template, (TemplateObject)lhs, (TemplateObject)lhs);
            }
            result = range;
        }
        return result;
    }

    public final Expression AndExpression() throws ParseException {
        Expression lhs;
        Expression result = lhs = this.EqualityExpression();
        while (this.jj_2_8(Integer.MAX_VALUE)) {
            this.jj_consume_token(105);
            Expression rhs = this.EqualityExpression();
            this.booleanLiteralOnly(lhs);
            this.booleanLiteralOnly(rhs);
            result = new AndExpression(lhs, rhs);
            result.setLocation(this.template, (TemplateObject)lhs, (TemplateObject)rhs);
            lhs = result;
        }
        return result;
    }

    public final Expression OrExpression() throws ParseException {
        Expression lhs;
        Expression result = lhs = this.AndExpression();
        while (this.jj_2_9(Integer.MAX_VALUE)) {
            this.jj_consume_token(106);
            Expression rhs = this.AndExpression();
            this.booleanLiteralOnly(lhs);
            this.booleanLiteralOnly(rhs);
            result = new OrExpression(lhs, rhs);
            result.setLocation(this.template, (TemplateObject)lhs, (TemplateObject)rhs);
            lhs = result;
        }
        return result;
    }

    public final ListLiteral ListLiteral() throws ParseException {
        ArrayList values = new ArrayList();
        Token begin = this.jj_consume_token(111);
        values = this.PositionalArgs();
        Token end = this.jj_consume_token(112);
        ListLiteral result = new ListLiteral(values);
        result.setLocation(this.template, begin, end);
        return result;
    }

    public final Expression NumberLiteral() throws ParseException {
        Token t;
        Token op = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 85: {
                t = this.jj_consume_token(85);
                break;
            }
            case 86: {
                t = this.jj_consume_token(86);
                break;
            }
            default: {
                this.jj_la1[8] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        String s = t.image;
        NumberLiteral result = new NumberLiteral(this.template.getArithmeticEngine().toNumber(s));
        Token startToken = op != null ? op : t;
        result.setLocation(this.template, startToken, t);
        return result;
    }

    public final Identifier Identifier() throws ParseException {
        Token t = this.jj_consume_token(120);
        Identifier id = new Identifier(t.image);
        id.setLocation(this.template, t, t);
        return id;
    }

    public final Expression IdentifierOrStringLiteral() throws ParseException {
        Expression exp;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 120: {
                exp = this.Identifier();
                break;
            }
            case 81: 
            case 82: {
                exp = this.StringLiteral(false);
                break;
            }
            default: {
                this.jj_la1[9] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return exp;
    }

    public final BuiltinVariable BuiltinVariable() throws ParseException {
        Token dot = this.jj_consume_token(87);
        Token name = this.jj_consume_token(120);
        BuiltinVariable result = null;
        try {
            result = new BuiltinVariable(name.image);
        }
        catch (ParseException pe) {
            pe.lineNumber = dot.beginLine;
            pe.columnNumber = dot.beginColumn;
            throw pe;
        }
        result.setLocation(this.template, dot, name);
        return result;
    }

    public final Expression AddSubExpression(Expression exp) throws ParseException {
        Expression result = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 87: {
                result = this.DotVariable(exp);
                break;
            }
            case 111: {
                result = this.DynamicKey(exp);
                break;
            }
            case 113: {
                result = this.MethodArgs(exp);
                break;
            }
            case 89: {
                result = this.BuiltIn(exp);
                break;
            }
            case 107: 
            case 128: {
                result = this.DefaultTo(exp);
                break;
            }
            case 90: {
                result = this.Exists(exp);
                break;
            }
            default: {
                this.jj_la1[10] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return result;
    }

    public final Expression DefaultTo(Expression exp) throws ParseException {
        Token t;
        Expression rhs = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 128: {
                t = this.jj_consume_token(128);
                break;
            }
            case 107: {
                t = this.jj_consume_token(107);
                if (!this.jj_2_10(Integer.MAX_VALUE)) break;
                rhs = this.Expression();
                break;
            }
            default: {
                this.jj_la1[11] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        DefaultToExpression result = new DefaultToExpression(exp, rhs);
        if (rhs == null) {
            result.setLocation(this.template, (TemplateObject)exp, t);
        } else {
            result.setLocation(this.template, (TemplateObject)exp, (TemplateObject)rhs);
        }
        return result;
    }

    public final Expression Exists(Expression exp) throws ParseException {
        Token t = this.jj_consume_token(90);
        ExistsExpression result = new ExistsExpression(exp);
        result.setLocation(this.template, (TemplateObject)exp, t);
        return result;
    }

    public final Expression BuiltIn(Expression exp) throws ParseException {
        Token t = null;
        this.jj_consume_token(89);
        t = this.jj_consume_token(120);
        BuiltIn result = null;
        try {
            result = BuiltIn.newBuiltIn(exp, t.image, t, this.templateName);
        }
        catch (ParseException pe) {
            pe.lineNumber = t.beginLine;
            pe.columnNumber = t.beginColumn;
            throw pe;
        }
        result.setLocation(this.template, (TemplateObject)exp, t);
        return result;
    }

    public final Expression DotVariable(Expression exp) throws ParseException {
        Token t;
        this.jj_consume_token(87);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 120: {
                t = this.jj_consume_token(120);
                break;
            }
            case 100: {
                t = this.jj_consume_token(100);
                break;
            }
            case 101: {
                t = this.jj_consume_token(101);
                break;
            }
            case 83: 
            case 84: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 117: 
            case 118: 
            case 119: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 94: {
                        t = this.jj_consume_token(94);
                        break;
                    }
                    case 95: {
                        t = this.jj_consume_token(95);
                        break;
                    }
                    case 96: {
                        t = this.jj_consume_token(96);
                        break;
                    }
                    case 97: {
                        t = this.jj_consume_token(97);
                        break;
                    }
                    case 83: {
                        t = this.jj_consume_token(83);
                        break;
                    }
                    case 84: {
                        t = this.jj_consume_token(84);
                        break;
                    }
                    case 117: {
                        t = this.jj_consume_token(117);
                        break;
                    }
                    case 118: {
                        t = this.jj_consume_token(118);
                        break;
                    }
                    case 119: {
                        t = this.jj_consume_token(119);
                        break;
                    }
                    default: {
                        this.jj_la1[12] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                if (Character.isLetter(t.image.charAt(0))) break;
                String msg = this.getErrorStart(t) + "\n" + t.image + " is not a valid identifier.";
                throw new ParseException(msg, t.beginLine, t.beginColumn);
            }
            default: {
                this.jj_la1[13] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.notListLiteral(exp, "hash");
        this.notStringLiteral(exp, "hash");
        this.notBooleanLiteral(exp, "hash");
        Dot dot = new Dot(exp, t.image);
        dot.setLocation(this.template, (TemplateObject)exp, t);
        return dot;
    }

    public final Expression DynamicKey(Expression exp) throws ParseException {
        this.jj_consume_token(111);
        Expression arg = this.Expression();
        Token t = this.jj_consume_token(112);
        this.notBooleanLiteral(exp, "list or hash");
        this.notNumberLiteral(exp, "list or hash");
        DynamicKeyName dkn = new DynamicKeyName(exp, arg);
        dkn.setLocation(this.template, (TemplateObject)exp, t);
        return dkn;
    }

    public final MethodCall MethodArgs(Expression exp) throws ParseException {
        ArrayList args = new ArrayList();
        this.jj_consume_token(113);
        args = this.PositionalArgs();
        Token end = this.jj_consume_token(114);
        args.trimToSize();
        MethodCall result = new MethodCall(exp, args);
        result.setLocation(this.template, (TemplateObject)exp, end);
        return result;
    }

    public final StringLiteral StringLiteral(boolean interpolate) throws ParseException {
        Token t;
        boolean raw = false;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 81: {
                t = this.jj_consume_token(81);
                break;
            }
            case 82: {
                t = this.jj_consume_token(82);
                raw = true;
                break;
            }
            default: {
                this.jj_la1[14] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        String s = t.image;
        s = s.substring(1, s.length() - 1);
        if (raw) {
            s = s.substring(1);
        } else {
            try {
                s = StringUtil.FTLStringLiteralDec(s);
            }
            catch (ParseException pe) {
                pe.lineNumber = t.beginLine;
                pe.columnNumber = t.beginColumn;
                throw pe;
            }
        }
        StringLiteral result = new StringLiteral(s);
        result.setLocation(this.template, t, t);
        if (interpolate && !raw && (t.image.indexOf("${") >= 0 || t.image.indexOf("#{") >= 0)) {
            result.checkInterpolation();
        }
        return result;
    }

    public final Expression BooleanLiteral() throws ParseException {
        BooleanLiteral result;
        Token t;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 83: {
                t = this.jj_consume_token(83);
                result = new BooleanLiteral(false);
                break;
            }
            case 84: {
                t = this.jj_consume_token(84);
                result = new BooleanLiteral(true);
                break;
            }
            default: {
                this.jj_la1[15] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        result.setLocation(this.template, t, t);
        return result;
    }

    public final HashLiteral HashLiteral() throws ParseException {
        ArrayList<Expression> keys = new ArrayList<Expression>();
        ArrayList<Expression> values = new ArrayList<Expression>();
        Token begin = this.jj_consume_token(115);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 98: 
            case 99: 
            case 107: 
            case 111: 
            case 113: 
            case 115: 
            case 120: {
                Expression key = this.Expression();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 108: {
                        this.jj_consume_token(108);
                        break;
                    }
                    case 110: {
                        this.jj_consume_token(110);
                        break;
                    }
                    default: {
                        this.jj_la1[16] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                Expression value = this.Expression();
                this.stringLiteralOnly(key);
                keys.add(key);
                values.add(value);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 108: {
                            break;
                        }
                        default: {
                            this.jj_la1[17] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(108);
                    key = this.Expression();
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 108: {
                            this.jj_consume_token(108);
                            break;
                        }
                        case 110: {
                            this.jj_consume_token(110);
                            break;
                        }
                        default: {
                            this.jj_la1[18] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    value = this.Expression();
                    this.stringLiteralOnly(key);
                    keys.add(key);
                    values.add(value);
                }
            }
            default: {
                this.jj_la1[19] = this.jj_gen;
            }
        }
        Token end = this.jj_consume_token(116);
        HashLiteral result = new HashLiteral(keys, values);
        result.setLocation(this.template, begin, end);
        return result;
    }

    public final DollarVariable StringOutput() throws ParseException {
        Token begin = this.jj_consume_token(71);
        Expression exp = this.Expression();
        this.notHashLiteral(exp, "scalar");
        this.notListLiteral(exp, "scalar");
        this.notBooleanLiteral(exp, "scalar");
        Token end = this.jj_consume_token(116);
        DollarVariable result = new DollarVariable(exp, this.escapedExpression(exp));
        result.setLocation(this.template, begin, end);
        return result;
    }

    public final NumericalOutput NumericalOutput() throws ParseException {
        NumericalOutput result;
        Token fmt = null;
        Token begin = this.jj_consume_token(72);
        Expression exp = this.Expression();
        this.numberLiteralOnly(exp);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 109: {
                this.jj_consume_token(109);
                fmt = this.jj_consume_token(120);
                break;
            }
            default: {
                this.jj_la1[20] = this.jj_gen;
            }
        }
        Token end = this.jj_consume_token(116);
        if (fmt != null) {
            String msg;
            int minFrac = -1;
            int maxFrac = -1;
            StringTokenizer st = new StringTokenizer(fmt.image, "mM", true);
            int type = 45;
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                try {
                    if (type != 45) {
                        switch (type) {
                            case 109: {
                                if (minFrac != -1) {
                                    throw new ParseException("invalid formatting string", fmt.beginLine, fmt.beginColumn);
                                }
                                minFrac = Integer.parseInt(token);
                                break;
                            }
                            case 77: {
                                if (maxFrac != -1) {
                                    throw new ParseException("invalid formatting string", fmt.beginLine, fmt.beginColumn);
                                }
                                maxFrac = Integer.parseInt(token);
                                break;
                            }
                            default: {
                                throw new ParseException();
                            }
                        }
                        type = 45;
                        continue;
                    }
                    if (token.equals("m")) {
                        type = 109;
                        continue;
                    }
                    if (token.equals("M")) {
                        type = 77;
                        continue;
                    }
                    throw new ParseException();
                }
                catch (ParseException e) {
                    String msg2 = this.getErrorStart(fmt) + "\nInvalid format specifier " + fmt.image;
                    throw new ParseException(msg2, fmt.beginLine, fmt.beginColumn);
                }
                catch (NumberFormatException e) {
                    String msg3 = this.getErrorStart(fmt) + "\nInvalid number in the format specifier " + fmt.image;
                    throw new ParseException(msg3, fmt.beginLine, fmt.beginColumn);
                }
            }
            if (maxFrac == -1) {
                if (minFrac == -1) {
                    msg = this.getErrorStart(fmt) + "\nInvalid format specification, at least one of m and M must be specified!";
                    throw new ParseException(msg, fmt.beginLine, fmt.beginColumn);
                }
                maxFrac = minFrac;
            } else if (minFrac == -1) {
                minFrac = 0;
            }
            if (minFrac > maxFrac) {
                msg = this.getErrorStart(fmt) + "\nInvalid format specification, min cannot be greater than max!";
                throw new ParseException(msg, fmt.beginLine, fmt.beginColumn);
            }
            if (minFrac > 50 || maxFrac > 50) {
                msg = this.getErrorStart(fmt) + "\nCannot specify more than 50 fraction digits";
                throw new ParseException(msg, fmt.beginLine, fmt.beginColumn);
            }
            result = new NumericalOutput(exp, minFrac, maxFrac);
        } else {
            result = new NumericalOutput(exp);
        }
        result.setLocation(this.template, begin, end);
        return result;
    }

    public final TemplateElement If() throws ParseException {
        Token t;
        Token start = this.jj_consume_token(8);
        Expression condition = this.Expression();
        this.jj_consume_token(123);
        TemplateElement block = this.OptionalBlock();
        ConditionalBlock cblock = new ConditionalBlock(condition, block, true);
        cblock.setLocation(this.template, start, (TemplateObject)block);
        IfBlock ifBlock = new IfBlock(cblock);
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 9: {
                    break;
                }
                default: {
                    this.jj_la1[21] = this.jj_gen;
                    break block6;
                }
            }
            t = this.jj_consume_token(9);
            condition = this.Expression();
            this.LooseDirectiveEnd();
            block = this.OptionalBlock();
            cblock = new ConditionalBlock(condition, block, false);
            cblock.setLocation(this.template, t, (TemplateObject)block);
            ifBlock.addBlock(cblock);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 44: {
                t = this.jj_consume_token(44);
                block = this.OptionalBlock();
                cblock = new ConditionalBlock(null, block, false);
                cblock.setLocation(this.template, t, (TemplateObject)block);
                ifBlock.addBlock(cblock);
                break;
            }
            default: {
                this.jj_la1[22] = this.jj_gen;
            }
        }
        Token end = this.jj_consume_token(31);
        ifBlock.setLocation(this.template, start, end);
        return ifBlock;
    }

    public final AttemptBlock Attempt() throws ParseException {
        Token end;
        Token start = this.jj_consume_token(6);
        TemplateElement block = this.OptionalBlock();
        RecoveryBlock recoveryBlock = this.Recover();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 33: {
                end = this.jj_consume_token(33);
                break;
            }
            case 34: {
                end = this.jj_consume_token(34);
                break;
            }
            default: {
                this.jj_la1[23] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        AttemptBlock result = new AttemptBlock(block, recoveryBlock);
        result.setLocation(this.template, start, end);
        return result;
    }

    public final RecoveryBlock Recover() throws ParseException {
        Token start = this.jj_consume_token(7);
        TemplateElement block = this.OptionalBlock();
        RecoveryBlock result = new RecoveryBlock(block);
        result.setLocation(this.template, start, (TemplateObject)block);
        return result;
    }

    public final IteratorBlock List() throws ParseException {
        Token start = this.jj_consume_token(10);
        ++this.loopNesting;
        Expression exp = this.Expression();
        this.jj_consume_token(118);
        Token index = this.jj_consume_token(120);
        this.jj_consume_token(123);
        TemplateElement block = this.OptionalBlock();
        Token end = this.jj_consume_token(32);
        --this.loopNesting;
        IteratorBlock result = new IteratorBlock(exp, index.image, block, false);
        result.setLocation(this.template, start, end);
        return result;
    }

    public final IteratorBlock ForEach() throws ParseException {
        Token start = this.jj_consume_token(11);
        ++this.loopNesting;
        Token index = this.jj_consume_token(120);
        this.jj_consume_token(117);
        Expression exp = this.Expression();
        this.jj_consume_token(123);
        TemplateElement block = this.OptionalBlock();
        Token end = this.jj_consume_token(35);
        --this.loopNesting;
        IteratorBlock result = new IteratorBlock(exp, index.image, block, true);
        result.setLocation(this.template, start, end);
        return result;
    }

    public final VisitNode Visit() throws ParseException {
        Expression namespaces = null;
        Token start = this.jj_consume_token(22);
        Expression targetNode = this.Expression();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 119: {
                this.jj_consume_token(119);
                namespaces = this.Expression();
                break;
            }
            default: {
                this.jj_la1[24] = this.jj_gen;
            }
        }
        Token end = this.LooseDirectiveEnd();
        VisitNode result = new VisitNode(targetNode, namespaces);
        result.setLocation(this.template, start, end);
        return result;
    }

    public final RecurseNode Recurse() throws ParseException {
        Token start;
        Token end = null;
        Expression node = null;
        Expression namespaces = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 56: {
                start = this.jj_consume_token(56);
                break;
            }
            case 57: {
                start = this.jj_consume_token(57);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 81: 
                    case 82: 
                    case 83: 
                    case 84: 
                    case 85: 
                    case 86: 
                    case 87: 
                    case 98: 
                    case 99: 
                    case 107: 
                    case 111: 
                    case 113: 
                    case 115: 
                    case 120: {
                        node = this.Expression();
                        break;
                    }
                    default: {
                        this.jj_la1[25] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 119: {
                        this.jj_consume_token(119);
                        namespaces = this.Expression();
                        break;
                    }
                    default: {
                        this.jj_la1[26] = this.jj_gen;
                    }
                }
                end = this.LooseDirectiveEnd();
                break;
            }
            default: {
                this.jj_la1[27] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (end == null) {
            end = start;
        }
        RecurseNode result = new RecurseNode(node, namespaces);
        result.setLocation(this.template, start, end);
        return result;
    }

    public final FallbackInstruction FallBack() throws ParseException {
        Token tok = this.jj_consume_token(58);
        if (!this.inMacro) {
            throw new ParseException(this.getErrorStart(tok) + "\nCannot fall back " + " outside a macro.", tok.beginLine, tok.beginColumn);
        }
        FallbackInstruction result = new FallbackInstruction();
        result.setLocation(this.template, tok, tok);
        return result;
    }

    public final BreakInstruction Break() throws ParseException {
        Token start = this.jj_consume_token(45);
        if (this.loopNesting < 1 && this.switchNesting < 1) {
            String msg = this.getErrorStart(start) + "\n" + start.image + " occurred outside a loop or a switch block.";
            throw new ParseException(msg, start.beginLine, start.beginColumn);
        }
        BreakInstruction result = new BreakInstruction();
        result.setLocation(this.template, start, start);
        return result;
    }

    public final ReturnInstruction Return() throws ParseException {
        Token start;
        Token end = null;
        Expression exp = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 46: {
                end = start = this.jj_consume_token(46);
                break;
            }
            case 24: {
                start = this.jj_consume_token(24);
                exp = this.Expression();
                end = this.LooseDirectiveEnd();
                break;
            }
            default: {
                this.jj_la1[28] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (this.inMacro) {
            if (exp != null) {
                String msg = this.getErrorStart(start) + "\nA macro cannot return a value";
                throw new ParseException(msg, start.beginLine, start.beginColumn);
            }
        } else if (this.inFunction) {
            if (exp == null) {
                String msg = this.getErrorStart(start) + "\nA function must return a value";
                throw new ParseException(msg, start.beginLine, start.beginColumn);
            }
        } else if (exp == null) {
            String msg = this.getErrorStart(start) + "\nA return instruction can only occur inside a macro of function";
            throw new ParseException(msg, start.beginLine, start.beginColumn);
        }
        ReturnInstruction result = new ReturnInstruction(exp);
        result.setLocation(this.template, start, end);
        return result;
    }

    public final StopInstruction Stop() throws ParseException {
        Token start = null;
        Expression exp = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 47: {
                start = this.jj_consume_token(47);
                break;
            }
            case 23: {
                start = this.jj_consume_token(23);
                exp = this.Expression();
                this.LooseDirectiveEnd();
                break;
            }
            default: {
                this.jj_la1[29] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        StopInstruction result = new StopInstruction(exp);
        result.setLocation(this.template, start, start);
        return result;
    }

    public final TemplateElement Nested() throws ParseException {
        Token t;
        BodyInstruction result = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 54: {
                t = this.jj_consume_token(54);
                result = new BodyInstruction(null);
                result.setLocation(this.template, t, t);
                break;
            }
            case 55: {
                t = this.jj_consume_token(55);
                ArrayList bodyParameters = this.PositionalArgs();
                Token end = this.LooseDirectiveEnd();
                result = new BodyInstruction(bodyParameters);
                result.setLocation(this.template, t, end);
                break;
            }
            default: {
                this.jj_la1[30] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (!this.inMacro) {
            throw new ParseException(this.getErrorStart(t) + "\nCannot use a " + t.image + " instruction outside a macro.", t.beginLine, t.beginColumn);
        }
        return result;
    }

    public final TemplateElement Flush() throws ParseException {
        Token t = this.jj_consume_token(48);
        FlushInstruction result = new FlushInstruction();
        result.setLocation(this.template, t, t);
        return result;
    }

    public final TemplateElement Trim() throws ParseException {
        Token t;
        TrimInstruction result = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 49: {
                t = this.jj_consume_token(49);
                result = new TrimInstruction(true, true);
                break;
            }
            case 50: {
                t = this.jj_consume_token(50);
                result = new TrimInstruction(true, false);
                break;
            }
            case 51: {
                t = this.jj_consume_token(51);
                result = new TrimInstruction(false, true);
                break;
            }
            case 52: {
                t = this.jj_consume_token(52);
                result = new TrimInstruction(false, false);
                break;
            }
            default: {
                this.jj_la1[31] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        result.setLocation(this.template, t, t);
        return result;
    }

    public final TemplateElement Assign() throws ParseException {
        int scope;
        Token start;
        Token id = null;
        Expression nsExp = null;
        ArrayList<Assignment> assignments = new ArrayList<Assignment>();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 14: {
                start = this.jj_consume_token(14);
                scope = 1;
                break;
            }
            case 15: {
                start = this.jj_consume_token(15);
                scope = 3;
                break;
            }
            case 16: {
                start = this.jj_consume_token(16);
                scope = 2;
                scope = 2;
                if (this.inMacro || this.inFunction) break;
                String msg = this.getErrorStart(start) + "\nLocal variable assigned outside a macro.";
                throw new ParseException(msg, start.beginLine, start.beginColumn);
            }
            default: {
                this.jj_la1[32] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        Expression nameExp = this.IdentifierOrStringLiteral();
        String varName = nameExp instanceof StringLiteral ? ((StringLiteral)nameExp).getAsString() : nameExp.toString();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 91: {
                this.jj_consume_token(91);
                Expression exp = this.Expression();
                Assignment ass = new Assignment(varName, exp, scope);
                ass.setLocation(this.template, (TemplateObject)nameExp, (TemplateObject)exp);
                assignments.add(ass);
                while (this.jj_2_11(Integer.MAX_VALUE)) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 108: {
                            this.jj_consume_token(108);
                            break;
                        }
                        default: {
                            this.jj_la1[33] = this.jj_gen;
                        }
                    }
                    nameExp = this.IdentifierOrStringLiteral();
                    varName = nameExp instanceof StringLiteral ? ((StringLiteral)nameExp).getAsString() : nameExp.toString();
                    this.jj_consume_token(91);
                    exp = this.Expression();
                    ass = new Assignment(varName, exp, scope);
                    ass.setLocation(this.template, (TemplateObject)nameExp, (TemplateObject)exp);
                    assignments.add(ass);
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 117: {
                        id = this.jj_consume_token(117);
                        nsExp = this.Expression();
                        if (scope == 1) break;
                        throw new ParseException(this.getErrorStart(id) + "\nCannot assign to namespace here.", id.beginLine, id.beginColumn);
                    }
                    default: {
                        this.jj_la1[34] = this.jj_gen;
                    }
                }
                Token end = this.LooseDirectiveEnd();
                AssignmentInstruction ai = new AssignmentInstruction(scope);
                for (int i = 0; i < assignments.size(); ++i) {
                    ai.addAssignment((Assignment)assignments.get(i));
                }
                ai.setNamespaceExp(nsExp);
                ai.setLocation(this.template, start, end);
                return ai;
            }
            case 117: 
            case 123: {
                Token end;
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 117: {
                        id = this.jj_consume_token(117);
                        nsExp = this.Expression();
                        if (scope == 1) break;
                        throw new ParseException(this.getErrorStart(id) + "\nCannot assign to namespace here.", id.beginLine, id.beginColumn);
                    }
                    default: {
                        this.jj_la1[35] = this.jj_gen;
                    }
                }
                this.jj_consume_token(123);
                TemplateElement block = this.OptionalBlock();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 36: {
                        end = this.jj_consume_token(36);
                        if (scope == 2) break;
                        throw new ParseException(this.getErrorStart(end) + "\nMismatched assignment tags.", end.beginLine, end.beginColumn);
                    }
                    case 38: {
                        end = this.jj_consume_token(38);
                        if (scope == 1) break;
                        throw new ParseException(this.getErrorStart(end) + "\nMismatched assignment tags.", end.beginLine, end.beginColumn);
                    }
                    case 37: {
                        end = this.jj_consume_token(37);
                        if (scope == 3) break;
                        throw new ParseException(this.getErrorStart(end) + "\nMismatched assignment tags", end.beginLine, end.beginColumn);
                    }
                    default: {
                        this.jj_la1[36] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                BlockAssignment ba = new BlockAssignment(block, varName, scope, nsExp);
                ba.setLocation(this.template, start, end);
                return ba;
            }
        }
        this.jj_la1[37] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Include Include() throws ParseException {
        Expression nameExp;
        Token start;
        Expression encodingExp;
        Expression parseExp;
        block8: {
            Token att;
            parseExp = null;
            encodingExp = null;
            start = this.jj_consume_token(17);
            nameExp = this.Expression();
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 109: {
                    this.jj_consume_token(109);
                    break;
                }
                default: {
                    this.jj_la1[38] = this.jj_gen;
                }
            }
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 120: {
                        break;
                    }
                    default: {
                        this.jj_la1[39] = this.jj_gen;
                        break block8;
                    }
                }
                att = this.jj_consume_token(120);
                this.jj_consume_token(91);
                Expression exp = this.Expression();
                String attString = att.image;
                if (attString.equalsIgnoreCase("parse")) {
                    parseExp = exp;
                    continue;
                }
                if (!attString.equalsIgnoreCase("encoding")) break;
                encodingExp = exp;
            }
            String msg = this.getErrorStart(att) + "\nexpecting parse= or encoding= to be specified.";
            throw new ParseException(msg, att.beginLine, att.beginColumn);
        }
        Token end = this.LooseDirectiveEnd();
        Include result = new Include(this.template, nameExp, encodingExp, parseExp);
        result.setLocation(this.template, start, end);
        return result;
    }

    public final LibraryLoad Import() throws ParseException {
        Token start = this.jj_consume_token(18);
        Expression nameExp = this.Expression();
        this.jj_consume_token(118);
        Token ns = this.jj_consume_token(120);
        Token end = this.LooseDirectiveEnd();
        LibraryLoad result = new LibraryLoad(this.template, nameExp, ns.image);
        result.setLocation(this.template, start, end);
        this.template.addImport(result);
        return result;
    }

    public final Macro Macro() throws ParseException {
        Token end;
        Token start;
        ArrayList<String> argNames = new ArrayList<String>();
        HashMap<String, Expression> args = new HashMap<String, Expression>();
        ArrayList<String> defNames = new ArrayList<String>();
        Expression defValue = null;
        boolean isFunction = false;
        boolean hasDefaults = false;
        boolean isCatchAll = false;
        String catchAll = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 20: {
                start = this.jj_consume_token(20);
                break;
            }
            case 19: {
                start = this.jj_consume_token(19);
                isFunction = true;
                break;
            }
            default: {
                this.jj_la1[40] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (this.inMacro || this.inFunction) {
            throw new ParseException(this.getErrorStart(start) + "\nMacros cannot be nested.", start.beginLine, start.endLine);
        }
        if (isFunction) {
            this.inFunction = true;
        } else {
            this.inMacro = true;
        }
        Expression nameExp = this.IdentifierOrStringLiteral();
        String name = nameExp instanceof StringLiteral ? ((StringLiteral)nameExp).getAsString() : nameExp.toString();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 113: {
                this.jj_consume_token(113);
                break;
            }
            default: {
                this.jj_la1[41] = this.jj_gen;
            }
        }
        block26: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 120: {
                    break;
                }
                default: {
                    this.jj_la1[42] = this.jj_gen;
                    break block26;
                }
            }
            Token arg = this.jj_consume_token(120);
            defValue = null;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 102: {
                    this.jj_consume_token(102);
                    isCatchAll = true;
                    break;
                }
                default: {
                    this.jj_la1[43] = this.jj_gen;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 91: {
                    this.jj_consume_token(91);
                    defValue = this.Expression();
                    defNames.add(arg.image);
                    hasDefaults = true;
                    break;
                }
                default: {
                    this.jj_la1[44] = this.jj_gen;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 108: {
                    this.jj_consume_token(108);
                    break;
                }
                default: {
                    this.jj_la1[45] = this.jj_gen;
                }
            }
            if (catchAll != null) {
                throw new ParseException(this.getErrorStart(arg) + "\nThere may only be one \"catch-all\" parameter in a macro declaration, " + "and it must be the last parameter.", arg.beginLine, arg.endLine);
            }
            if (isCatchAll) {
                if (defValue != null) {
                    throw new ParseException(this.getErrorStart(arg) + "\n\"Catch-all\" macro parameter may not have a default value.", arg.beginLine, arg.endLine);
                }
                catchAll = arg.image;
                continue;
            }
            argNames.add(arg.image);
            if (hasDefaults && defValue == null) {
                throw new ParseException(this.getErrorStart(arg) + "\nIn a macro declaration, parameters without a default value " + "must all occur before the parameters with default values.", arg.beginLine, arg.endLine);
            }
            args.put(arg.image, defValue);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 114: {
                this.jj_consume_token(114);
                break;
            }
            default: {
                this.jj_la1[46] = this.jj_gen;
            }
        }
        this.jj_consume_token(123);
        TemplateElement block = this.OptionalBlock();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 40: {
                end = this.jj_consume_token(40);
                if (!isFunction) break;
                throw new ParseException(this.getErrorStart(start) + "\nExpected function end tag here.", start.beginLine, start.endLine);
            }
            case 39: {
                end = this.jj_consume_token(39);
                if (isFunction) break;
                throw new ParseException(this.getErrorStart(start) + "\nExpected macro end tag here.", start.beginLine, start.endLine);
            }
            default: {
                this.jj_la1[47] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.inFunction = false;
        this.inMacro = false;
        Macro result = new Macro(name, argNames, args, block);
        result.setCatchAll(catchAll);
        result.isFunction = isFunction;
        result.setLocation(this.template, start, end);
        this.template.addMacro(result);
        return result;
    }

    public final CompressedBlock Compress() throws ParseException {
        Token start = this.jj_consume_token(27);
        TemplateElement block = this.OptionalBlock();
        Token end = this.jj_consume_token(41);
        CompressedBlock cb = new CompressedBlock(block);
        cb.setLocation(this.template, start, end);
        return cb;
    }

    public final TemplateElement UnifiedMacroTransform() throws ParseException {
        Token end;
        Token start = null;
        HashMap namedArgs = null;
        ArrayList positionalArgs = null;
        ArrayList<String> bodyParameters = null;
        String directiveName = null;
        TemplateElement nestedBlock = null;
        start = this.jj_consume_token(63);
        Expression exp = this.Expression();
        if (exp instanceof Identifier || exp instanceof Dot && ((Dot)exp).onlyHasIdentifiers()) {
            directiveName = exp.getCanonicalForm();
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 127: {
                this.jj_consume_token(127);
                break;
            }
            default: {
                this.jj_la1[48] = this.jj_gen;
            }
        }
        if (this.jj_2_12(Integer.MAX_VALUE)) {
            namedArgs = this.NamedArgs();
        } else {
            positionalArgs = this.PositionalArgs();
        }
        block3 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 109: {
                this.jj_consume_token(109);
                bodyParameters = new ArrayList<String>();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 120: 
                    case 127: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 127: {
                                this.jj_consume_token(127);
                                break;
                            }
                            default: {
                                this.jj_la1[49] = this.jj_gen;
                            }
                        }
                        Token t = this.jj_consume_token(120);
                        bodyParameters.add(t.image);
                        while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 108: 
                                case 127: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[50] = this.jj_gen;
                                    break block3;
                                }
                            }
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 127: {
                                    this.jj_consume_token(127);
                                    break;
                                }
                                default: {
                                    this.jj_la1[51] = this.jj_gen;
                                }
                            }
                            this.jj_consume_token(108);
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 127: {
                                    this.jj_consume_token(127);
                                    break;
                                }
                                default: {
                                    this.jj_la1[52] = this.jj_gen;
                                }
                            }
                            t = this.jj_consume_token(120);
                            bodyParameters.add(t.image);
                        }
                    }
                }
                this.jj_la1[53] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[54] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 124: {
                end = this.jj_consume_token(124);
                break;
            }
            case 123: {
                this.jj_consume_token(123);
                nestedBlock = this.OptionalBlock();
                end = this.jj_consume_token(64);
                String s = end.image.substring(3);
                s = s.substring(0, s.length() - 1).trim();
                if (s.length() <= 0 || s.equals(directiveName)) break;
                String msg = this.getErrorStart(end);
                if (directiveName == null) {
                    throw new ParseException(msg + "\nExpecting </@>", end.beginLine, end.beginColumn);
                }
                throw new ParseException(msg + "\nExpecting </@> or </@" + directiveName + ">", end.beginLine, end.beginColumn);
            }
            default: {
                this.jj_la1[55] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        UnifiedCall result = positionalArgs != null ? new UnifiedCall(exp, positionalArgs, nestedBlock, bodyParameters) : new UnifiedCall(exp, namedArgs, nestedBlock, bodyParameters);
        result.setLocation(this.template, start, end);
        return result;
    }

    public final TemplateElement Call() throws ParseException {
        HashMap namedArgs = null;
        ArrayList positionalArgs = null;
        String macroName = null;
        Token start = this.jj_consume_token(25);
        Token id = this.jj_consume_token(120);
        macroName = id.image;
        if (this.jj_2_14(Integer.MAX_VALUE)) {
            namedArgs = this.NamedArgs();
        } else {
            if (this.jj_2_13(Integer.MAX_VALUE)) {
                this.jj_consume_token(113);
            }
            positionalArgs = this.PositionalArgs();
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 114: {
                    this.jj_consume_token(114);
                    break;
                }
                default: {
                    this.jj_la1[56] = this.jj_gen;
                }
            }
        }
        Token end = this.LooseDirectiveEnd();
        UnifiedCall result = null;
        result = positionalArgs != null ? new UnifiedCall((Expression)new Identifier(macroName), positionalArgs, null, null) : new UnifiedCall((Expression)new Identifier(macroName), namedArgs, null, null);
        result.legacySyntax = true;
        result.setLocation(this.template, start, end);
        return result;
    }

    public final HashMap NamedArgs() throws ParseException {
        HashMap<String, Expression> result = new HashMap<String, Expression>();
        block3: while (true) {
            Token t = this.jj_consume_token(120);
            this.jj_consume_token(91);
            this.token_source.SwitchTo(4);
            this.token_source.inInvocation = true;
            Expression exp = this.Expression();
            result.put(t.image, exp);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 120: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[57] = this.jj_gen;
        this.token_source.inInvocation = false;
        return result;
    }

    public final ArrayList PositionalArgs() throws ParseException {
        ArrayList<Expression> result = new ArrayList<Expression>();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 98: 
            case 99: 
            case 107: 
            case 111: 
            case 113: 
            case 115: 
            case 120: {
                Expression arg = this.Expression();
                result.add(arg);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 81: 
                        case 82: 
                        case 83: 
                        case 84: 
                        case 85: 
                        case 86: 
                        case 87: 
                        case 98: 
                        case 99: 
                        case 107: 
                        case 108: 
                        case 111: 
                        case 113: 
                        case 115: 
                        case 120: {
                            break;
                        }
                        default: {
                            this.jj_la1[58] = this.jj_gen;
                            break block0;
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 108: {
                            this.jj_consume_token(108);
                            break;
                        }
                        default: {
                            this.jj_la1[59] = this.jj_gen;
                        }
                    }
                    arg = this.Expression();
                    result.add(arg);
                }
            }
            default: {
                this.jj_la1[60] = this.jj_gen;
            }
        }
        return result;
    }

    public final Comment Comment() throws ParseException {
        Token start;
        StringBuffer buf = new StringBuffer();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 28: {
                start = this.jj_consume_token(28);
                break;
            }
            case 29: {
                start = this.jj_consume_token(29);
                break;
            }
            default: {
                this.jj_la1[61] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        Token end = this.UnparsedContent(buf);
        Comment result = new Comment(buf.toString());
        result.setLocation(this.template, start, end);
        return result;
    }

    public final TextBlock NoParse() throws ParseException {
        StringBuffer buf = new StringBuffer();
        Token start = this.jj_consume_token(30);
        Token end = this.UnparsedContent(buf);
        TextBlock result = new TextBlock(buf.toString(), true);
        result.setLocation(this.template, start, end);
        return result;
    }

    public final TransformBlock Transform() throws ParseException {
        Token end;
        TemplateElement content = null;
        HashMap<String, Expression> args = null;
        Token start = this.jj_consume_token(21);
        Expression exp = this.Expression();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 109: {
                this.jj_consume_token(109);
                break;
            }
            default: {
                this.jj_la1[62] = this.jj_gen;
            }
        }
        block10: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 120: {
                    break;
                }
                default: {
                    this.jj_la1[63] = this.jj_gen;
                    break block10;
                }
            }
            Token argName = this.jj_consume_token(120);
            this.jj_consume_token(91);
            Expression argExp = this.Expression();
            if (args == null) {
                args = new HashMap<String, Expression>();
            }
            args.put(argName.image, argExp);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 124: {
                end = this.jj_consume_token(124);
                break;
            }
            case 123: {
                this.jj_consume_token(123);
                content = this.OptionalBlock();
                end = this.jj_consume_token(42);
                break;
            }
            default: {
                this.jj_la1[64] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        TransformBlock result = new TransformBlock(exp, args, content);
        result.setLocation(this.template, start, end);
        return result;
    }

    public final SwitchBlock Switch() throws ParseException {
        boolean defaultFound = false;
        Token start = this.jj_consume_token(12);
        Expression switchExp = this.Expression();
        this.jj_consume_token(123);
        ++this.switchNesting;
        SwitchBlock switchBlock = new SwitchBlock(switchExp);
        while (this.jj_2_15(2)) {
            Case caseIns = this.Case();
            if (caseIns.isDefault) {
                if (defaultFound) {
                    String msg = this.getErrorStart(start) + "\nYou can only have one default case in a switch statement";
                    throw new ParseException(msg, start.beginLine, start.beginColumn);
                }
                defaultFound = true;
            }
            switchBlock.addCase(caseIns);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 68: {
                this.jj_consume_token(68);
                break;
            }
            default: {
                this.jj_la1[65] = this.jj_gen;
            }
        }
        Token end = this.jj_consume_token(43);
        --this.switchNesting;
        switchBlock.setLocation(this.template, start, end);
        return switchBlock;
    }

    public final Case Case() throws ParseException {
        Token start;
        Expression exp = null;
        boolean isDefault = false;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 68: {
                this.jj_consume_token(68);
                break;
            }
            default: {
                this.jj_la1[66] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 13: {
                start = this.jj_consume_token(13);
                exp = this.Expression();
                this.jj_consume_token(123);
                break;
            }
            case 53: {
                start = this.jj_consume_token(53);
                isDefault = true;
                break;
            }
            default: {
                this.jj_la1[67] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        TemplateElement block = this.OptionalBlock();
        Case result = new Case(exp, block, isDefault);
        result.setLocation(this.template, start, (TemplateObject)block);
        return result;
    }

    public final EscapeBlock Escape() throws ParseException {
        Token start = this.jj_consume_token(59);
        Token variable = this.jj_consume_token(120);
        this.jj_consume_token(118);
        Expression escapeExpr = this.Expression();
        this.jj_consume_token(123);
        EscapeBlock result = new EscapeBlock(variable.image, escapeExpr, this.escapedExpression(escapeExpr));
        this.escapes.addFirst(result);
        TemplateElement content = this.OptionalBlock();
        result.setContent(content);
        this.escapes.removeFirst();
        Token end = this.jj_consume_token(60);
        result.setLocation(this.template, start, end);
        return result;
    }

    public final NoEscapeBlock NoEscape() throws ParseException {
        Token start = this.jj_consume_token(61);
        if (this.escapes.isEmpty()) {
            String msg = this.getErrorStart(start) + "\nnoescape with no matching escape encountered.";
            throw new ParseException(msg, start.beginLine, start.beginColumn);
        }
        Object escape = this.escapes.removeFirst();
        TemplateElement content = this.OptionalBlock();
        Token end = this.jj_consume_token(62);
        this.escapes.addFirst(escape);
        NoEscapeBlock result = new NoEscapeBlock(content);
        result.setLocation(this.template, start, end);
        return result;
    }

    public final Token LooseDirectiveEnd() throws ParseException {
        Token t;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 123: {
                t = this.jj_consume_token(123);
                break;
            }
            case 124: {
                t = this.jj_consume_token(124);
                break;
            }
            default: {
                this.jj_la1[68] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return t;
    }

    public final PropertySetting Setting() throws ParseException {
        Token start = this.jj_consume_token(26);
        Token key = this.jj_consume_token(120);
        this.jj_consume_token(91);
        Expression value = this.Expression();
        Token end = this.LooseDirectiveEnd();
        PropertySetting result = new PropertySetting(key.image, value);
        result.setLocation(this.template, start, end);
        return result;
    }

    public final TemplateElement FreemarkerDirective() throws ParseException {
        TemplateElement tp;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: {
                tp = this.If();
                break;
            }
            case 10: {
                tp = this.List();
                break;
            }
            case 11: {
                tp = this.ForEach();
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                tp = this.Assign();
                break;
            }
            case 17: {
                tp = this.Include();
                break;
            }
            case 18: {
                tp = this.Import();
                break;
            }
            case 19: 
            case 20: {
                tp = this.Macro();
                break;
            }
            case 27: {
                tp = this.Compress();
                break;
            }
            case 63: {
                tp = this.UnifiedMacroTransform();
                break;
            }
            case 25: {
                tp = this.Call();
                break;
            }
            case 28: 
            case 29: {
                tp = this.Comment();
                break;
            }
            case 30: {
                tp = this.NoParse();
                break;
            }
            case 21: {
                tp = this.Transform();
                break;
            }
            case 12: {
                tp = this.Switch();
                break;
            }
            case 26: {
                tp = this.Setting();
                break;
            }
            case 45: {
                tp = this.Break();
                break;
            }
            case 24: 
            case 46: {
                tp = this.Return();
                break;
            }
            case 23: 
            case 47: {
                tp = this.Stop();
                break;
            }
            case 48: {
                tp = this.Flush();
                break;
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: {
                tp = this.Trim();
                break;
            }
            case 54: 
            case 55: {
                tp = this.Nested();
                break;
            }
            case 59: {
                tp = this.Escape();
                break;
            }
            case 61: {
                tp = this.NoEscape();
                break;
            }
            case 22: {
                tp = this.Visit();
                break;
            }
            case 56: 
            case 57: {
                tp = this.Recurse();
                break;
            }
            case 58: {
                tp = this.FallBack();
                break;
            }
            case 6: {
                tp = this.Attempt();
                break;
            }
            default: {
                this.jj_la1[69] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return tp;
    }

    public final TextBlock PCData() throws ParseException {
        StringBuffer buf = new StringBuffer();
        Token t = null;
        Token start = null;
        Token prevToken = null;
        do {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 68: {
                    prevToken = t;
                    t = this.jj_consume_token(68);
                    break;
                }
                case 69: {
                    t = this.jj_consume_token(69);
                    break;
                }
                case 70: {
                    t = this.jj_consume_token(70);
                    break;
                }
                default: {
                    this.jj_la1[70] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            buf.append(t.image);
            if (start == null) {
                start = t;
            }
            if (prevToken == null) continue;
            prevToken.next = null;
        } while (this.jj_2_16(Integer.MAX_VALUE));
        if (this.stripText && this.contentNesting == 1) {
            return TextBlock.EMPTY_BLOCK;
        }
        TextBlock result = new TextBlock(buf.toString(), false);
        result.setLocation(this.template, start, t);
        return result;
    }

    public final Token UnparsedContent(StringBuffer buf) throws ParseException {
        Token t;
        block9: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 131: {
                    t = this.jj_consume_token(131);
                    break;
                }
                case 130: {
                    t = this.jj_consume_token(130);
                    break;
                }
                case 129: {
                    t = this.jj_consume_token(129);
                    break;
                }
                case 132: {
                    t = this.jj_consume_token(132);
                    break;
                }
                default: {
                    this.jj_la1[71] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            buf.append(t.image);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 129: 
                case 130: 
                case 131: 
                case 132: {
                    continue block9;
                }
            }
            break;
        }
        this.jj_la1[72] = this.jj_gen;
        buf.setLength(buf.length() - t.image.length());
        return t;
    }

    public final TemplateElement Content() throws ParseException {
        TemplateElement elem;
        MixedContent nodes = new MixedContent();
        TemplateElement begin = null;
        ++this.contentNesting;
        block9: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 68: 
                case 69: 
                case 70: {
                    elem = this.PCData();
                    break;
                }
                case 71: {
                    elem = this.StringOutput();
                    break;
                }
                case 72: {
                    elem = this.NumericalOutput();
                    break;
                }
                case 6: 
                case 8: 
                case 10: 
                case 11: 
                case 12: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 61: 
                case 63: {
                    elem = this.FreemarkerDirective();
                    break;
                }
                default: {
                    this.jj_la1[73] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            if (begin == null) {
                begin = elem;
            }
            nodes.addElement(elem);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 6: 
                case 8: 
                case 10: 
                case 11: 
                case 12: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 61: 
                case 63: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: {
                    continue block9;
                }
            }
            break;
        }
        this.jj_la1[74] = this.jj_gen;
        --this.contentNesting;
        nodes.setLocation(this.template, (TemplateObject)begin, (TemplateObject)elem);
        return nodes;
    }

    public final TemplateElement FreeMarkerText() throws ParseException {
        TemplateElement elem;
        MixedContent nodes = new MixedContent();
        TemplateElement begin = null;
        block8: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 68: 
                case 69: 
                case 70: {
                    elem = this.PCData();
                    break;
                }
                case 71: {
                    elem = this.StringOutput();
                    break;
                }
                case 72: {
                    elem = this.NumericalOutput();
                    break;
                }
                default: {
                    this.jj_la1[75] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            if (begin == null) {
                begin = elem;
            }
            nodes.addElement(elem);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: {
                    continue block8;
                }
            }
            break;
        }
        this.jj_la1[76] = this.jj_gen;
        nodes.setLocation(this.template, (TemplateObject)begin, (TemplateObject)elem);
        return nodes;
    }

    public final TemplateElement OptionalBlock() throws ParseException {
        TemplateElement tp = TextBlock.EMPTY_BLOCK;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 61: 
            case 63: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: {
                tp = this.Content();
                break;
            }
            default: {
                this.jj_la1[77] = this.jj_gen;
            }
        }
        return tp;
    }

    /*
     * Unable to fully structure code
     */
    public final void HeaderElement() throws ParseException {
        exp = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 68: {
                this.jj_consume_token(68);
                break;
            }
            default: {
                this.jj_la1[78] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 66: {
                this.jj_consume_token(66);
                break;
            }
            case 65: {
                this.jj_consume_token(65);
                block20: while (true) lbl-1000:
                // 10 sources

                {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 120: {
                            break;
                        }
                        default: {
                            this.jj_la1[79] = this.jj_gen;
                            ** GOTO lbl96
                        }
                    }
                    key = this.jj_consume_token(120);
                    this.jj_consume_token(91);
                    exp = this.Expression();
                    ks = key.image;
                    value = null;
                    try {
                        value = exp.getAsTemplateModel(null);
                    }
                    catch (Exception e) {
                        throw new ParseException("Could not evaluate expression: " + exp.getCanonicalForm() + " " + exp.getStartLocation() + "\nUnderlying cause: " + e.getMessage(), exp);
                    }
                    vs = null;
                    if (value instanceof TemplateScalarModel) {
                        try {
                            vs = ((TemplateScalarModel)exp).getAsString();
                        }
                        catch (TemplateModelException tme) {
                            // empty catch block
                        }
                    }
                    if (this.template == null) continue;
                    if (ks.equalsIgnoreCase("encoding")) {
                        if (vs == null) {
                            throw new ParseException("expecting encoding string here: " + exp.getStartLocation(), exp);
                        }
                        encoding = this.template.getEncoding();
                        if (encoding == null || encoding.equals(vs)) continue;
                        throw new Template.WrongEncodingException(vs);
                    }
                    if (ks.equalsIgnoreCase("STRIP_WHITESPACE")) {
                        this.stripWhitespace = this.getBoolean(exp);
                        continue;
                    }
                    if (ks.equalsIgnoreCase("STRIP_TEXT")) {
                        this.stripText = this.getBoolean(exp);
                        continue;
                    }
                    if (ks.equalsIgnoreCase("STRICT_SYNTAX")) {
                        this.token_source.strictEscapeSyntax = this.getBoolean(exp);
                        continue;
                    }
                    if (ks.equalsIgnoreCase("ns_prefixes")) {
                        if (!(value instanceof TemplateHashModelEx)) {
                            throw new ParseException("Expecting a hash of prefixes to namespace URI's here. " + exp.getStartLocation(), exp);
                        }
                        prefixMap = (TemplateHashModelEx)value;
                        try {
                            keys = prefixMap.keys();
                            it = keys.iterator();
                            while (true) lbl-1000:
                            // 2 sources

                            {
                                if (!it.hasNext()) ** GOTO lbl-1000
                                prefix = ((TemplateScalarModel)it.next()).getAsString();
                                valueModel = prefixMap.get(prefix);
                                if (!(valueModel instanceof TemplateScalarModel)) {
                                    throw new ParseException("Non-string value in prefix to namespace hash. " + exp.getStartLocation(), exp);
                                }
                                nsURI = ((TemplateScalarModel)valueModel).getAsString();
                                try {
                                    this.template.addPrefixNSMapping(prefix, nsURI);
                                    continue;
                                }
                                catch (IllegalArgumentException iae) {
                                    throw new ParseException(iae.getMessage() + " " + exp.getStartLocation(), exp);
                                }
                                break;
                            }
                        }
                        catch (TemplateModelException tme) {}
                        {
                            ** while (true)
                        }
                        continue;
                    }
                    if (!ks.equalsIgnoreCase("attributes")) break;
                    if (!(value instanceof TemplateHashModelEx)) {
                        throw new ParseException("Expecting a hash of attribute names to values here. " + exp.getStartLocation(), exp);
                    }
                    attributeMap = (TemplateHashModelEx)value;
                    try {
                        keys = attributeMap.keys();
                        it = keys.iterator();
                        while (true) {
                            if (!it.hasNext()) continue block20;
                            attName = ((TemplateScalarModel)it.next()).getAsString();
                            attValue = DeepUnwrap.unwrap(attributeMap.get(attName));
                            this.template.setCustomAttribute(attName, attValue);
                        }
                    }
                    catch (TemplateModelException tme) {
                        continue;
                    }
                    break;
                }
                throw new ParseException("Unknown FTL header parameter: " + key.image, key.beginLine, key.beginColumn);
lbl96:
                // 1 sources

                this.LooseDirectiveEnd();
                break;
            }
            default: {
                this.jj_la1[80] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final Map ParamList() throws ParseException {
        HashMap<String, Expression> result = new HashMap<String, Expression>();
        block6: while (true) {
            Identifier id = this.Identifier();
            this.jj_consume_token(91);
            Expression exp = this.Expression();
            result.put(id.toString(), exp);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 108: {
                    this.jj_consume_token(108);
                    break;
                }
                default: {
                    this.jj_la1[81] = this.jj_gen;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 120: {
                    continue block6;
                }
            }
            break;
        }
        this.jj_la1[82] = this.jj_gen;
        return result;
    }

    public final TemplateElement Root() throws ParseException {
        if (this.jj_2_17(Integer.MAX_VALUE)) {
            this.HeaderElement();
        }
        TemplateElement doc = this.OptionalBlock();
        this.jj_consume_token(0);
        doc.setParentRecursively(null);
        return doc.postParseCleanup(this.stripWhitespace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_5(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(4, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_6(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_6();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(5, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_7(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_7();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(6, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_8(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_8();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(7, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_9(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_9();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(8, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_10(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_10();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(9, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_11(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_11();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(10, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_12(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_12();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(11, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_13(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_13();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(12, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_14(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_14();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(13, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_15(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_15();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(14, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_16(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_16();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(15, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_17(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_17();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(16, xla);
        }
    }

    private final boolean jj_3R_32() {
        if (this.jj_3R_35()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_36()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private final boolean jj_3R_110() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(56)) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_132()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_108() {
        return this.jj_scan_token(61);
    }

    private final boolean jj_3R_170() {
        if (this.jj_scan_token(111)) {
            return true;
        }
        if (this.jj_3R_23()) {
            return true;
        }
        return this.jj_scan_token(112);
    }

    private final boolean jj_3R_122() {
        return this.jj_scan_token(19);
    }

    private final boolean jj_3_3() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(100)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(103)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(104)) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_118() {
        return this.jj_scan_token(104);
    }

    private final boolean jj_3R_92() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(20)) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_122()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_117() {
        return this.jj_scan_token(103);
    }

    private final boolean jj_3R_109() {
        return this.jj_scan_token(22);
    }

    private final boolean jj_3R_116() {
        return this.jj_scan_token(100);
    }

    private final boolean jj_3R_82() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_116()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_117()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_118()) {
                    return true;
                }
            }
        }
        return this.jj_3R_81();
    }

    private final boolean jj_3R_107() {
        return this.jj_scan_token(59);
    }

    private final boolean jj_3R_50() {
        Token xsp;
        if (this.jj_3R_81()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_82());
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_88() {
        return this.jj_scan_token(11);
    }

    private final boolean jj_3R_176() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(94)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(95)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(96)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(97)) {
                        this.jj_scanpos = xsp;
                        if (this.jj_scan_token(83)) {
                            this.jj_scanpos = xsp;
                            if (this.jj_scan_token(84)) {
                                this.jj_scanpos = xsp;
                                if (this.jj_scan_token(117)) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_scan_token(118)) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_scan_token(119)) {
                                            return true;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_27() {
        return this.jj_scan_token(53);
    }

    private final boolean jj_3R_26() {
        if (this.jj_scan_token(13)) {
            return true;
        }
        return this.jj_3R_23();
    }

    private final boolean jj_3R_91() {
        return this.jj_scan_token(18);
    }

    private final boolean jj_3R_169() {
        if (this.jj_scan_token(87)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(120)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(100)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(101)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_176()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_24() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(68)) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_26()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_27()) {
                return true;
            }
        }
        return this.jj_3R_28();
    }

    private final boolean jj_3_2() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(98)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(99)) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_84() {
        return this.jj_scan_token(99);
    }

    private final boolean jj_3R_83() {
        return this.jj_scan_token(98);
    }

    private final boolean jj_3R_87() {
        return this.jj_scan_token(10);
    }

    private final boolean jj_3R_51() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_83()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_84()) {
                return true;
            }
        }
        return this.jj_3R_50();
    }

    private final boolean jj_3R_44() {
        Token xsp;
        if (this.jj_3R_50()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_51());
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_172() {
        if (this.jj_scan_token(89)) {
            return true;
        }
        return this.jj_scan_token(120);
    }

    private final boolean jj_3_15() {
        return this.jj_3R_24();
    }

    private final boolean jj_3R_90() {
        return this.jj_scan_token(17);
    }

    private final boolean jj_3R_136() {
        return this.jj_scan_token(99);
    }

    private final boolean jj_3R_99() {
        return this.jj_scan_token(12);
    }

    private final boolean jj_3R_174() {
        return this.jj_scan_token(90);
    }

    private final boolean jj_3R_133() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(98)) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_136()) {
                return true;
            }
        }
        return this.jj_3R_135();
    }

    private final boolean jj_3_10() {
        return this.jj_3R_23();
    }

    private final boolean jj_3R_112() {
        return this.jj_scan_token(6);
    }

    private final boolean jj_3R_178() {
        return this.jj_3R_23();
    }

    private final boolean jj_3R_137() {
        return this.jj_scan_token(107);
    }

    private final boolean jj_3R_177() {
        if (this.jj_scan_token(107)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_178()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private final boolean jj_3R_134() {
        Token xsp;
        if (this.jj_3R_137()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_137());
        this.jj_scanpos = xsp;
        return this.jj_3R_135();
    }

    private final boolean jj_3R_173() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(128)) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_177()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_98() {
        return this.jj_scan_token(21);
    }

    private final boolean jj_3R_31() {
        return this.jj_3R_34();
    }

    private final boolean jj_3_11() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(108)) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_scan_token(120)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(81)) {
                return true;
            }
        }
        return this.jj_scan_token(91);
    }

    private final boolean jj_3R_28() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_31()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private final boolean jj_3R_166() {
        return this.jj_3R_174();
    }

    private final boolean jj_3R_165() {
        return this.jj_3R_173();
    }

    private final boolean jj_3R_164() {
        return this.jj_3R_172();
    }

    private final boolean jj_3R_163() {
        return this.jj_3R_171();
    }

    private final boolean jj_3R_162() {
        return this.jj_3R_170();
    }

    private final boolean jj_3R_161() {
        return this.jj_3R_169();
    }

    private final boolean jj_3R_97() {
        return this.jj_scan_token(30);
    }

    private final boolean jj_3R_155() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_161()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_162()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_163()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_164()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_165()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_166()) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_86() {
        return this.jj_scan_token(8);
    }

    private final boolean jj_3R_115() {
        return this.jj_3R_135();
    }

    private final boolean jj_3R_114() {
        return this.jj_3R_134();
    }

    private final boolean jj_3R_113() {
        return this.jj_3R_133();
    }

    private final boolean jj_3R_81() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_113()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_114()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_115()) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_96() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(28)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(29)) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_121() {
        return this.jj_scan_token(16);
    }

    private final boolean jj_3R_120() {
        return this.jj_scan_token(15);
    }

    private final boolean jj_3R_119() {
        return this.jj_scan_token(14);
    }

    private final boolean jj_3R_154() {
        if (this.jj_scan_token(87)) {
            return true;
        }
        return this.jj_scan_token(120);
    }

    private final boolean jj_3R_89() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_119()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_120()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_121()) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_175() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(108)) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_23();
    }

    private final boolean jj_3R_168() {
        Token xsp;
        if (this.jj_3R_23()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_175());
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_153() {
        if (this.jj_scan_token(113)) {
            return true;
        }
        if (this.jj_3R_23()) {
            return true;
        }
        return this.jj_scan_token(114);
    }

    private final boolean jj_3R_160() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_168()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private final boolean jj_3R_43() {
        return this.jj_3R_49();
    }

    private final boolean jj_3R_42() {
        return this.jj_3R_48();
    }

    private final boolean jj_3_1() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(87)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(111)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(113)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(89)) {
                        this.jj_scanpos = xsp;
                        if (this.jj_scan_token(107)) {
                            this.jj_scanpos = xsp;
                            if (this.jj_scan_token(128)) {
                                this.jj_scanpos = xsp;
                                if (this.jj_scan_token(90)) {
                                    return true;
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_41() {
        return this.jj_3R_47();
    }

    private final boolean jj_3R_40() {
        return this.jj_3R_46();
    }

    private final boolean jj_3R_129() {
        return this.jj_scan_token(52);
    }

    private final boolean jj_3R_37() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_40()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_41()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_42()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_43()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_128() {
        return this.jj_scan_token(51);
    }

    private final boolean jj_3R_127() {
        return this.jj_scan_token(50);
    }

    private final boolean jj_3R_146() {
        return this.jj_3R_155();
    }

    private final boolean jj_3R_34() {
        Token xsp;
        if (this.jj_3R_37()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_37());
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_126() {
        return this.jj_scan_token(49);
    }

    private final boolean jj_3R_152() {
        return this.jj_scan_token(120);
    }

    private final boolean jj_3R_145() {
        return this.jj_3R_154();
    }

    private final boolean jj_3R_105() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_126()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_127()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_128()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_129()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_144() {
        return this.jj_3R_153();
    }

    private final boolean jj_3R_143() {
        return this.jj_3R_152();
    }

    private final boolean jj_3R_142() {
        return this.jj_3R_151();
    }

    private final boolean jj_3R_141() {
        return this.jj_3R_150();
    }

    private final boolean jj_3R_140() {
        return this.jj_3R_149();
    }

    private final boolean jj_3R_139() {
        return this.jj_3R_148();
    }

    private final boolean jj_3R_138() {
        return this.jj_3R_147();
    }

    private final boolean jj_3R_104() {
        return this.jj_scan_token(48);
    }

    private final boolean jj_3_13() {
        return this.jj_scan_token(113);
    }

    private final boolean jj_3R_135() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_138()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_139()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_140()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_141()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_142()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_143()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_144()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3R_145()) {
                                        return true;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_146());
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_147() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(85)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(86)) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3_14() {
        if (this.jj_scan_token(120)) {
            return true;
        }
        return this.jj_scan_token(91);
    }

    private final boolean jj_3R_151() {
        if (this.jj_scan_token(111)) {
            return true;
        }
        if (this.jj_3R_160()) {
            return true;
        }
        return this.jj_scan_token(112);
    }

    private final boolean jj_3R_23() {
        return this.jj_3R_25();
    }

    private final boolean jj_3R_131() {
        return this.jj_scan_token(55);
    }

    private final boolean jj_3_16() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(68)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(69)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(70)) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_48() {
        return this.jj_scan_token(72);
    }

    private final boolean jj_3R_95() {
        return this.jj_scan_token(25);
    }

    private final boolean jj_3_9() {
        return this.jj_scan_token(106);
    }

    private final boolean jj_3R_85() {
        return this.jj_scan_token(68);
    }

    private final boolean jj_3R_130() {
        return this.jj_scan_token(54);
    }

    private final boolean jj_3R_53() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_85()) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(69)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(70)) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_106() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_130()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_131()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_46() {
        Token xsp;
        if (this.jj_3R_53()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_53());
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_30() {
        if (this.jj_scan_token(106)) {
            return true;
        }
        return this.jj_3R_29();
    }

    private final boolean jj_3R_25() {
        Token xsp;
        if (this.jj_3R_29()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_30());
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_47() {
        return this.jj_scan_token(71);
    }

    private final boolean jj_3R_125() {
        return this.jj_scan_token(23);
    }

    private final boolean jj_3_8() {
        return this.jj_scan_token(105);
    }

    private final boolean jj_3R_103() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(47)) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_125()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_80() {
        return this.jj_3R_112();
    }

    private final boolean jj_3R_79() {
        return this.jj_3R_111();
    }

    private final boolean jj_3R_78() {
        return this.jj_3R_110();
    }

    private final boolean jj_3R_33() {
        if (this.jj_scan_token(105)) {
            return true;
        }
        return this.jj_3R_32();
    }

    private final boolean jj_3R_77() {
        return this.jj_3R_109();
    }

    private final boolean jj_3R_76() {
        return this.jj_3R_108();
    }

    private final boolean jj_3R_75() {
        return this.jj_3R_107();
    }

    private final boolean jj_3R_29() {
        Token xsp;
        if (this.jj_3R_32()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_33());
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3_12() {
        if (this.jj_scan_token(120)) {
            return true;
        }
        return this.jj_scan_token(91);
    }

    private final boolean jj_3R_74() {
        return this.jj_3R_106();
    }

    private final boolean jj_3R_73() {
        return this.jj_3R_105();
    }

    private final boolean jj_3R_167() {
        if (this.jj_scan_token(108)) {
            return true;
        }
        if (this.jj_3R_23()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(108)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(110)) {
                return true;
            }
        }
        return this.jj_3R_23();
    }

    private final boolean jj_3R_72() {
        return this.jj_3R_104();
    }

    private final boolean jj_3R_71() {
        return this.jj_3R_103();
    }

    private final boolean jj_3R_70() {
        return this.jj_3R_102();
    }

    private final boolean jj_3R_69() {
        return this.jj_3R_101();
    }

    private final boolean jj_3R_68() {
        return this.jj_3R_100();
    }

    private final boolean jj_3_6() {
        return this.jj_3R_23();
    }

    private final boolean jj_3R_67() {
        return this.jj_3R_99();
    }

    private final boolean jj_3R_156() {
        if (this.jj_3R_23()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(108)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(110)) {
                return true;
            }
        }
        if (this.jj_3R_23()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_167());
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_66() {
        return this.jj_3R_98();
    }

    private final boolean jj_3R_65() {
        return this.jj_3R_97();
    }

    private final boolean jj_3_7() {
        return this.jj_scan_token(88);
    }

    private final boolean jj_3R_64() {
        return this.jj_3R_96();
    }

    private final boolean jj_3R_148() {
        if (this.jj_scan_token(115)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_156()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(116);
    }

    private final boolean jj_3R_124() {
        return this.jj_scan_token(24);
    }

    private final boolean jj_3R_94() {
        return this.jj_scan_token(63);
    }

    private final boolean jj_3R_63() {
        return this.jj_3R_95();
    }

    private final boolean jj_3R_123() {
        return this.jj_scan_token(46);
    }

    private final boolean jj_3R_52() {
        return this.jj_3R_44();
    }

    private final boolean jj_3R_62() {
        return this.jj_3R_94();
    }

    private final boolean jj_3R_61() {
        return this.jj_3R_93();
    }

    private final boolean jj_3R_102() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_123()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_124()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_60() {
        return this.jj_3R_92();
    }

    private final boolean jj_3R_45() {
        if (this.jj_scan_token(88)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_52()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private final boolean jj_3R_59() {
        return this.jj_3R_91();
    }

    private final boolean jj_3R_58() {
        return this.jj_3R_90();
    }

    private final boolean jj_3R_38() {
        if (this.jj_3R_44()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_45()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private final boolean jj_3R_159() {
        return this.jj_scan_token(84);
    }

    private final boolean jj_3R_57() {
        return this.jj_3R_89();
    }

    private final boolean jj_3R_158() {
        return this.jj_scan_token(83);
    }

    private final boolean jj_3R_56() {
        return this.jj_3R_88();
    }

    private final boolean jj_3R_55() {
        return this.jj_3R_87();
    }

    private final boolean jj_3R_54() {
        return this.jj_3R_86();
    }

    private final boolean jj_3R_150() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_158()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_159()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_93() {
        return this.jj_scan_token(27);
    }

    private final boolean jj_3R_49() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_54()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_55()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_56()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_57()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_58()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_59()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_60()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3R_61()) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_3R_62()) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_3R_63()) {
                                                this.jj_scanpos = xsp;
                                                if (this.jj_3R_64()) {
                                                    this.jj_scanpos = xsp;
                                                    if (this.jj_3R_65()) {
                                                        this.jj_scanpos = xsp;
                                                        if (this.jj_3R_66()) {
                                                            this.jj_scanpos = xsp;
                                                            if (this.jj_3R_67()) {
                                                                this.jj_scanpos = xsp;
                                                                if (this.jj_3R_68()) {
                                                                    this.jj_scanpos = xsp;
                                                                    if (this.jj_3R_69()) {
                                                                        this.jj_scanpos = xsp;
                                                                        if (this.jj_3R_70()) {
                                                                            this.jj_scanpos = xsp;
                                                                            if (this.jj_3R_71()) {
                                                                                this.jj_scanpos = xsp;
                                                                                if (this.jj_3R_72()) {
                                                                                    this.jj_scanpos = xsp;
                                                                                    if (this.jj_3R_73()) {
                                                                                        this.jj_scanpos = xsp;
                                                                                        if (this.jj_3R_74()) {
                                                                                            this.jj_scanpos = xsp;
                                                                                            if (this.jj_3R_75()) {
                                                                                                this.jj_scanpos = xsp;
                                                                                                if (this.jj_3R_76()) {
                                                                                                    this.jj_scanpos = xsp;
                                                                                                    if (this.jj_3R_77()) {
                                                                                                        this.jj_scanpos = xsp;
                                                                                                        if (this.jj_3R_78()) {
                                                                                                            this.jj_scanpos = xsp;
                                                                                                            if (this.jj_3R_79()) {
                                                                                                                this.jj_scanpos = xsp;
                                                                                                                if (this.jj_3R_80()) {
                                                                                                                    return true;
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_101() {
        return this.jj_scan_token(45);
    }

    private final boolean jj_3_5() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(126)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(97)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(125)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(96)) {
                        this.jj_scanpos = xsp;
                        if (this.jj_scan_token(95)) {
                            this.jj_scanpos = xsp;
                            if (this.jj_scan_token(95)) {
                                this.jj_scanpos = xsp;
                                if (this.jj_scan_token(94)) {
                                    return true;
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_100() {
        return this.jj_scan_token(26);
    }

    private final boolean jj_3R_39() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(126)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(97)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(125)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(96)) {
                        this.jj_scanpos = xsp;
                        if (this.jj_scan_token(95)) {
                            this.jj_scanpos = xsp;
                            if (this.jj_scan_token(94)) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return this.jj_3R_38();
    }

    private final boolean jj_3R_157() {
        return this.jj_scan_token(82);
    }

    private final boolean jj_3R_35() {
        if (this.jj_3R_38()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_39()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private final boolean jj_3R_111() {
        return this.jj_scan_token(58);
    }

    private final boolean jj_3R_149() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(81)) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_157()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3_17() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(68)) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_scan_token(66)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(65)) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3_4() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(93)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(91)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(92)) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_171() {
        if (this.jj_scan_token(113)) {
            return true;
        }
        if (this.jj_3R_160()) {
            return true;
        }
        return this.jj_scan_token(114);
    }

    private final boolean jj_3R_36() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(93)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(91)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(92)) {
                    return true;
                }
            }
        }
        return this.jj_3R_35();
    }

    private final boolean jj_3R_132() {
        return this.jj_scan_token(57);
    }

    private static void jj_la1_0() {
        jj_la1_0 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 512, 0, 0, 0, 0, 0, 0, 0x1000000, 0x800000, 0, 0, 114688, 0, 0, 0, 0, 0, 0, 0, 0x180000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x30000000, 0, 0, 0, 0, 0, 8192, 0, 2147474752, 0, 0, 0, 2147474752, 2147474752, 0, 0, 2147474752, 0, 0, 0, 0, 0};
    }

    private static void jj_la1_1() {
        jj_la1_1 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4096, 6, 0, 0, 0, 0x3000000, 16384, 32768, 0xC00000, 0x1E0000, 0, 0, 0, 0, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 384, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x200000, 0, -1344282624, 0, 0, 0, -1344282624, -1344282624, 0, 0, -1344282624, 0, 0, 0, 0, 0};
    }

    private static void jj_la1_2() {
        jj_la1_2 = new int[]{0xFE0000, 0xFE0000, 0, 0, 0, 0, 0x38000000, -1073741824, 0x600000, 393216, 0x6800000, 0, -1072168960, -1072168960, 393216, 0x180000, 0, 0, 0, 0xFE0000, 0, 0, 0, 0, 0, 0xFE0000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x8000000, 0, 0, 0, 0, 0, 0, 0x8000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0xFE0000, 0, 0xFE0000, 0, 0, 0, 0, 16, 16, 0, 0, 0, 112, 0, 0, 496, 496, 496, 496, 496, 16, 0, 6, 0, 0};
    }

    private static void jj_la1_3() {
        jj_la1_3 = new int[]{17465344, 17467404, 2048, 12, 12, 400, 0, 0x60000003, 0, 0x1000000, 165888, 2048, 0xE00003, 31457331, 0, 0, 20480, 4096, 20480, 17467404, 8192, 0, 0, 0, 0x800000, 17467404, 0x800000, 0, 0, 0, 0, 0, 0, 4096, 0x200000, 0x200000, 0, 0x8200000, 8192, 0x1000000, 0, 131072, 0x1000000, 64, 0, 4096, 262144, 0, Integer.MIN_VALUE, Integer.MIN_VALUE, -2147479552, Integer.MIN_VALUE, Integer.MIN_VALUE, -2130706432, 8192, 0x18000000, 262144, 0x1000000, 17471500, 4096, 17467404, 0, 8192, 0x1000000, 0x18000000, 0, 0, 0, 0x18000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x1000000, 0, 4096, 0x1000000};
    }

    private static void jj_la1_4() {
        jj_la1_4 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    public FMParser(InputStream stream) {
        int i;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new FMParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 83; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 83; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public FMParser(Reader stream) {
        int i;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new FMParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 83; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 83; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public FMParser(FMParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 83; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(FMParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 83; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private final Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private final boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.lookingAhead ? this.jj_scanpos : this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            boolean exists = false;
            Enumeration e = this.jj_expentries.elements();
            while (e.hasMoreElements()) {
                int[] oldentry = (int[])e.nextElement();
                if (oldentry.length != this.jj_expentry.length) continue;
                exists = true;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] == this.jj_expentry[i]) continue;
                    exists = false;
                    break;
                }
                if (!exists) continue;
                break;
            }
            if (!exists) {
                this.jj_expentries.addElement(this.jj_expentry);
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.removeAllElements();
        boolean[] la1tokens = new boolean[133];
        for (i = 0; i < 133; ++i) {
            la1tokens[i] = false;
        }
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 83; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) != 0) {
                    la1tokens[32 + j] = true;
                }
                if ((jj_la1_2[i] & 1 << j) != 0) {
                    la1tokens[64 + j] = true;
                }
                if ((jj_la1_3[i] & 1 << j) != 0) {
                    la1tokens[96 + j] = true;
                }
                if ((jj_la1_4[i] & 1 << j) == 0) continue;
                la1tokens[128 + j] = true;
            }
        }
        for (i = 0; i < 133; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.addElement(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = (int[])this.jj_expentries.elementAt(i2);
        }
        return new ParseException(this.token, exptokseq, FMParserConstants.tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private final void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 17; ++i) {
            JJCalls p = this.jj_2_rtns[i];
            do {
                if (p.gen <= this.jj_gen) continue;
                this.jj_la = p.arg;
                this.jj_lastpos = this.jj_scanpos = p.first;
                switch (i) {
                    case 0: {
                        this.jj_3_1();
                        break;
                    }
                    case 1: {
                        this.jj_3_2();
                        break;
                    }
                    case 2: {
                        this.jj_3_3();
                        break;
                    }
                    case 3: {
                        this.jj_3_4();
                        break;
                    }
                    case 4: {
                        this.jj_3_5();
                        break;
                    }
                    case 5: {
                        this.jj_3_6();
                        break;
                    }
                    case 6: {
                        this.jj_3_7();
                        break;
                    }
                    case 7: {
                        this.jj_3_8();
                        break;
                    }
                    case 8: {
                        this.jj_3_9();
                        break;
                    }
                    case 9: {
                        this.jj_3_10();
                        break;
                    }
                    case 10: {
                        this.jj_3_11();
                        break;
                    }
                    case 11: {
                        this.jj_3_12();
                        break;
                    }
                    case 12: {
                        this.jj_3_13();
                        break;
                    }
                    case 13: {
                        this.jj_3_14();
                        break;
                    }
                    case 14: {
                        this.jj_3_15();
                        break;
                    }
                    case 15: {
                        this.jj_3_16();
                        break;
                    }
                    case 16: {
                        this.jj_3_17();
                    }
                }
            } while ((p = p.next) != null);
        }
        this.jj_rescan = false;
    }

    private final void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        FMParser.jj_la1_0();
        FMParser.jj_la1_1();
        FMParser.jj_la1_2();
        FMParser.jj_la1_3();
        FMParser.jj_la1_4();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }
}

