/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.views.pfly.listbar;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.SpanElement;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.DragStartEvent;
import com.google.gwt.event.dom.client.DragStartHandler;
import com.google.gwt.event.dom.client.MouseDownEvent;
import com.google.gwt.event.dom.client.MouseDownHandler;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.event.logical.shared.HasCloseHandlers;
import com.google.gwt.event.logical.shared.HasSelectionHandlers;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import java.util.Map;
import org.gwtbootstrap3.client.ui.Anchor;
import org.gwtbootstrap3.client.ui.Icon;
import org.gwtbootstrap3.client.ui.ListItem;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.gwtbootstrap3.client.ui.html.Span;
import org.gwtbootstrap3.client.ui.html.Text;
import org.uberfire.client.views.pfly.dropdown.ListDropdown;
import org.uberfire.client.workbench.part.WorkbenchPartPresenter;
import org.uberfire.client.workbench.widgets.dnd.DragArea;
import org.uberfire.client.workbench.widgets.dnd.WorkbenchDragAndDropManager;
import org.uberfire.workbench.model.PartDefinition;

public class PartListDropdown
extends ListDropdown
implements HasSelectionHandlers<PartDefinition>,
HasCloseHandlers<PartDefinition> {
    public static final String DEBUG_TITLE_PREFIX = "PartList-title-";
    private Map<PartDefinition, ListItem> partOptions = new HashMap<PartDefinition, ListItem>();
    private Map<PartDefinition, DragArea> partTitles = new HashMap<PartDefinition, DragArea>();
    private Map<PartDefinition, WorkbenchPartPresenter.View> partView = new HashMap<PartDefinition, WorkbenchPartPresenter.View>();
    private HandlerRegistration noDragHandler;
    private WorkbenchDragAndDropManager dndManager;
    private boolean dndEnabled = true;

    public PartListDropdown() {
        this.addDomHandler((EventHandler)new NoMouseDownHandler(), MouseDownEvent.getType());
    }

    public void setDndManager(WorkbenchDragAndDropManager dndManager) {
        this.dndManager = dndManager;
    }

    public void addPart(WorkbenchPartPresenter.View view) {
        PartDefinition part = view.getPresenter().getDefinition();
        this.partView.put(part, view);
        this.buildWidgets(part, view.getPresenter().getTitle(), view.getPresenter().getTitleDecoration());
        if (this.partTitles.size() == 1) {
            this.selectPart(part);
        }
    }

    private void buildWidgets(PartDefinition part, String partTitle, IsWidget titleDecoration) {
        ListItem option;
        DragArea title;
        if (this.partTitles.containsKey(part)) {
            title = this.partTitles.get(part);
            title.getElement().getFirstChildElement().removeFromParent();
            title.add((Element)this.buildTitleTextWidget(partTitle, titleDecoration));
        } else {
            title = this.buildTitleWidget(partTitle, titleDecoration);
            this.partTitles.put(part, title);
        }
        if (this.partOptions.containsKey(part)) {
            option = this.partOptions.get(part);
            option.setText(partTitle);
        } else {
            option = this.buildTitleDropdownMenuItem(partTitle, part);
            this.partOptions.put(part, option);
            this.add((Widget)option);
        }
    }

    public void removePart(PartDefinition part) {
        this.partTitles.remove(part);
        this.partView.remove(part);
        Widget option = (Widget)this.partOptions.remove(part);
        this.remove(option);
    }

    public void selectPart(PartDefinition part) {
        Widget title = (Widget)this.partTitles.get(part);
        this.setText(title);
        for (Map.Entry<PartDefinition, ListItem> entry : this.partOptions.entrySet()) {
            if (entry.getKey().equals(part)) {
                entry.getValue().addStyleName("uf-part-list-dropdown-selected");
                continue;
            }
            entry.getValue().removeStyleName("uf-part-list-dropdown-selected");
        }
        this.makeDraggable(title, this.partView.get(part));
    }

    public void changeTitle(PartDefinition part, String title, IsWidget titleDecoration) {
        this.buildWidgets(part, title, titleDecoration);
    }

    private DragArea buildTitleWidget(String title, IsWidget titleDecoration) {
        SpanElement spanElement = this.buildTitleTextWidget(title, titleDecoration);
        DragArea dragArea = new DragArea();
        dragArea.add((Element)spanElement);
        dragArea.ensureDebugId(DEBUG_TITLE_PREFIX + title);
        dragArea.addMouseDownHandler((MouseDownHandler)new NoMouseDownHandler());
        return dragArea;
    }

    private SpanElement buildTitleTextWidget(String title, IsWidget titleDecoration) {
        SpanElement spanElement = Document.get().createSpanElement();
        spanElement.addClassName("uf-listbar-panel-header-title-text");
        String titleWidget = titleDecoration instanceof Image ? titleDecoration.toString() : "";
        spanElement.setInnerHTML(titleWidget + " " + title.replaceAll(" ", "\u00a0"));
        spanElement.setTitle(title);
        return spanElement;
    }

    private ListItem buildTitleDropdownMenuItem(String title, final PartDefinition part) {
        final Span span = new Span();
        span.add((Widget)new Text(title));
        ListItem li = new ListItem(){

            public void setText(String text) {
                span.clear();
                span.add((Widget)new Text(text));
            }
        };
        li.addDomHandler((EventHandler)new ClickHandler(){

            public void onClick(ClickEvent event) {
                SelectionEvent.fire((HasSelectionHandlers)PartListDropdown.this, (Object)part);
            }
        }, ClickEvent.getType());
        Icon icon = new Icon(IconType.TIMES);
        icon.addDomHandler((EventHandler)new ClickHandler(){

            public void onClick(ClickEvent event) {
                CloseEvent.fire((HasCloseHandlers)PartListDropdown.this, (Object)part);
                boolean openMenu = PartListDropdown.this.getElement().hasClassName("open");
                if (openMenu) {
                    Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                        public void execute() {
                            PartListDropdown.this.getElement().addClassName("open");
                        }
                    });
                }
            }
        }, ClickEvent.getType());
        icon.addStyleName("pull-right");
        Anchor anchor = new Anchor();
        anchor.add((Widget)icon);
        anchor.add((Widget)span);
        li.add((Widget)anchor);
        return li;
    }

    public void enableDragAndDrop() {
        this.dndEnabled = true;
        if (this.noDragHandler != null) {
            this.noDragHandler.removeHandler();
            this.noDragHandler = null;
        }
        for (Map.Entry<PartDefinition, DragArea> entry : this.partTitles.entrySet()) {
            Widget title = (Widget)entry.getValue();
            WorkbenchPartPresenter.View view = this.partView.get(entry.getKey());
            this.makeDraggable(title, view);
        }
    }

    private void makeDraggable(Widget title, WorkbenchPartPresenter.View view) {
        if (this.dndManager == null || !this.dndEnabled) {
            return;
        }
        this.dndManager.makeDraggable((IsWidget)view, (IsWidget)title);
    }

    public void disableDragAndDrop() {
        this.dndEnabled = false;
        if (this.noDragHandler == null) {
            this.noDragHandler = this.addDomHandler((EventHandler)new DragStartHandler(){

                public void onDragStart(DragStartEvent event) {
                    event.preventDefault();
                }
            }, DragStartEvent.getType());
        }
    }

    public boolean isDndEnabled() {
        return this.dndEnabled;
    }

    @Override
    public void clear() {
        super.clear();
        this.partOptions.clear();
        this.partTitles.clear();
        this.partView.clear();
    }

    public HandlerRegistration addSelectionHandler(SelectionHandler<PartDefinition> handler) {
        return super.addHandler(handler, SelectionEvent.getType());
    }

    public HandlerRegistration addCloseHandler(CloseHandler<PartDefinition> handler) {
        return super.addHandler(handler, CloseEvent.getType());
    }

    private class NoMouseDownHandler
    implements MouseDownHandler {
        private NoMouseDownHandler() {
        }

        public void onMouseDown(MouseDownEvent event) {
            event.preventDefault();
        }
    }
}

