/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.rdf.core.impl;

import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.clerezza.rdf.core.NonLiteral;
import org.apache.clerezza.rdf.core.Resource;
import org.apache.clerezza.rdf.core.Triple;
import org.apache.clerezza.rdf.core.TripleCollection;
import org.apache.clerezza.rdf.core.UriRef;
import org.apache.clerezza.rdf.core.event.AddEvent;
import org.apache.clerezza.rdf.core.event.FilterTriple;
import org.apache.clerezza.rdf.core.event.GraphEvent;
import org.apache.clerezza.rdf.core.event.GraphListener;
import org.apache.clerezza.rdf.core.event.RemoveEvent;
import org.apache.clerezza.rdf.core.impl.DelayedNotificator;

public abstract class AbstractTripleCollection
extends AbstractCollection<Triple>
implements TripleCollection {
    private final Set<ListenerConfiguration> listenerConfigs = Collections.synchronizedSet(new HashSet());
    private DelayedNotificator delayedNotificator = new DelayedNotificator();

    @Override
    public Iterator<Triple> iterator() {
        return this.filter(null, null, null);
    }

    @Override
    public boolean contains(Object o) {
        if (!(o instanceof Triple)) {
            return false;
        }
        Triple t = (Triple)o;
        return this.filter(t.getSubject(), t.getPredicate(), t.getObject()).hasNext();
    }

    @Override
    public Iterator<Triple> filter(NonLiteral subject, UriRef predicate, Resource object) {
        final Iterator<Triple> baseIter = this.performFilter(subject, predicate, object);
        return new Iterator<Triple>(){
            Triple currentTriple = null;

            @Override
            public boolean hasNext() {
                return baseIter.hasNext();
            }

            @Override
            public Triple next() {
                this.currentTriple = (Triple)baseIter.next();
                return this.currentTriple;
            }

            @Override
            public void remove() {
                baseIter.remove();
                AbstractTripleCollection.this.dispatchEvent(new RemoveEvent(AbstractTripleCollection.this, this.currentTriple));
            }
        };
    }

    protected abstract Iterator<Triple> performFilter(NonLiteral var1, UriRef var2, Resource var3);

    @Override
    public boolean add(Triple triple) {
        boolean success = this.performAdd(triple);
        if (success) {
            this.dispatchEvent(new AddEvent(this, triple));
        }
        return success;
    }

    protected boolean performAdd(Triple e) {
        return super.add(e);
    }

    @Override
    public boolean remove(Object o) {
        Triple triple = (Triple)o;
        boolean success = this.performRemove(triple);
        if (success) {
            this.dispatchEvent(new RemoveEvent(this, triple));
        }
        return success;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean modified = false;
        for (Object object : c) {
            if (!this.remove(object)) continue;
            modified = true;
        }
        return modified;
    }

    protected boolean performRemove(Triple triple) {
        Iterator<Triple> e = this.performFilter(null, null, null);
        while (e.hasNext()) {
            if (!((Object)triple).equals(e.next())) continue;
            e.remove();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispatchEvent(GraphEvent event) {
        Set<ListenerConfiguration> set = this.listenerConfigs;
        synchronized (set) {
            Iterator<ListenerConfiguration> iter = this.listenerConfigs.iterator();
            while (iter.hasNext()) {
                ListenerConfiguration config = iter.next();
                GraphListener registeredListener = config.getListener();
                if (registeredListener == null) {
                    iter.remove();
                    continue;
                }
                if (!config.getFilter().match(event.getTriple())) continue;
                this.delayedNotificator.sendEventToListener(registeredListener, event);
            }
        }
    }

    @Override
    public void addGraphListener(GraphListener listener, FilterTriple filter) {
        this.addGraphListener(listener, filter, 0L);
    }

    @Override
    public void addGraphListener(GraphListener listener, FilterTriple filter, long delay) {
        this.listenerConfigs.add(new ListenerConfiguration(listener, filter));
        if (delay > 0L) {
            this.delayedNotificator.addDelayedListener(listener, delay);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeGraphListener(GraphListener listener) {
        Set<ListenerConfiguration> set = this.listenerConfigs;
        synchronized (set) {
            Iterator<ListenerConfiguration> iter = this.listenerConfigs.iterator();
            while (iter.hasNext()) {
                ListenerConfiguration listenerConfig = iter.next();
                GraphListener registeredListener = listenerConfig.getListener();
                if (registeredListener != null && !registeredListener.equals(listener)) continue;
                iter.remove();
            }
        }
        this.delayedNotificator.removeDelayedListener(listener);
    }

    private static class ListenerConfiguration {
        private WeakReference<GraphListener> listenerRef;
        private FilterTriple filter;

        private ListenerConfiguration(GraphListener listener, FilterTriple filter) {
            this.listenerRef = new WeakReference<GraphListener>(listener);
            this.filter = filter;
        }

        GraphListener getListener() {
            GraphListener listener = (GraphListener)this.listenerRef.get();
            return listener;
        }

        FilterTriple getFilter() {
            return this.filter;
        }
    }
}

