/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.rdf.core.serializedform;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import org.apache.clerezza.rdf.core.Graph;
import org.apache.clerezza.rdf.core.MGraph;
import org.apache.clerezza.rdf.core.UriRef;
import org.apache.clerezza.rdf.core.impl.SimpleMGraph;
import org.apache.clerezza.rdf.core.serializedform.ParsingProvider;
import org.apache.clerezza.rdf.core.serializedform.SupportedFormat;
import org.apache.clerezza.rdf.core.serializedform.UnsupportedFormatException;
import org.apache.clerezza.rdf.core.serializedform.UnsupportedParsingFormatException;

public class Parser {
    private List<ParsingProvider> providerList = new ArrayList<ParsingProvider>();
    private volatile Map<String, ParsingProvider> providerMap = new HashMap<String, ParsingProvider>();
    private static volatile Parser instance;

    public Parser() {
        instance = this;
    }

    Parser(Object dummy) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Parser getInstance() {
        if (instance != null) return instance;
        Class<Parser> clazz = Parser.class;
        synchronized (Parser.class) {
            if (instance != null) return instance;
            new Parser();
            for (ParsingProvider parsingProvider : ServiceLoader.load(ParsingProvider.class)) {
                instance.bindParsingProvider(parsingProvider);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public Graph parse(InputStream serializedGraph, String formatIdentifier) throws UnsupportedFormatException {
        return this.parse(serializedGraph, formatIdentifier, null);
    }

    public void parse(MGraph target, InputStream serializedGraph, String formatIdentifier) throws UnsupportedFormatException {
        this.parse(target, serializedGraph, formatIdentifier, null);
    }

    public Graph parse(InputStream serializedGraph, String formatIdentifier, UriRef baseUri) throws UnsupportedFormatException {
        SimpleMGraph mGraph = new SimpleMGraph();
        this.parse(mGraph, serializedGraph, formatIdentifier, baseUri);
        return mGraph.getGraph();
    }

    public void parse(MGraph target, InputStream serializedGraph, String formatIdentifier, UriRef baseUri) throws UnsupportedFormatException {
        int semicolonPos = formatIdentifier.indexOf(59);
        String deParameterizedIdentifier = semicolonPos > -1 ? formatIdentifier.substring(0, semicolonPos) : formatIdentifier;
        ParsingProvider provider = this.providerMap.get(deParameterizedIdentifier);
        if (provider == null) {
            throw new UnsupportedParsingFormatException(formatIdentifier);
        }
        provider.parse(target, serializedGraph, formatIdentifier, baseUri);
    }

    public Set<String> getSupportedFormats() {
        return Collections.unmodifiableSet(this.providerMap.keySet());
    }

    public void bindParsingProvider(ParsingProvider provider) {
        this.providerList.add(provider);
        this.refreshProviderMap();
    }

    public void unbindParsingProvider(ParsingProvider provider) {
        this.providerList.remove(provider);
        this.refreshProviderMap();
    }

    private void refreshProviderMap() {
        HashMap<String, ParsingProvider> newProviderMap = new HashMap<String, ParsingProvider>();
        for (ParsingProvider provider : this.providerList) {
            String[] formatIdentifiers;
            for (String formatIdentifier : formatIdentifiers = this.getFormatIdentifiers(provider)) {
                newProviderMap.put(formatIdentifier, provider);
            }
        }
        this.providerMap = newProviderMap;
    }

    private String[] getFormatIdentifiers(ParsingProvider parsingProvider) {
        Class<?> clazz = parsingProvider.getClass();
        SupportedFormat supportedFormatAnnotation = clazz.getAnnotation(SupportedFormat.class);
        String[] formatIdentifiers = supportedFormatAnnotation.value();
        return formatIdentifiers;
    }
}

