/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.strategy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.helix.HelixManager;
import org.apache.helix.ZNRecord;
import org.apache.log4j.Logger;

public class AutoRebalanceStrategy {
    private static Logger logger = Logger.getLogger(AutoRebalanceStrategy.class);
    private final String _resourceName;
    private final List<String> _partitions;
    private final LinkedHashMap<String, Integer> _states;
    private final int _maximumPerNode;
    private final ReplicaPlacementScheme _placementScheme;
    private Map<String, Node> _nodeMap;
    private List<Node> _liveNodesList;
    private Map<Integer, String> _stateMap;
    private Map<Replica, Node> _preferredAssignment;
    private Map<Replica, Node> _existingPreferredAssignment;
    private Map<Replica, Node> _existingNonPreferredAssignment;
    private Set<Replica> _orphaned;

    public AutoRebalanceStrategy(String resourceName, List<String> partitions, LinkedHashMap<String, Integer> states, int maximumPerNode, ReplicaPlacementScheme placementScheme) {
        this._resourceName = resourceName;
        this._partitions = partitions;
        this._states = states;
        this._maximumPerNode = maximumPerNode;
        this._placementScheme = placementScheme != null ? placementScheme : new DefaultPlacementScheme();
    }

    public AutoRebalanceStrategy(String resourceName, List<String> partitions, LinkedHashMap<String, Integer> states) {
        this(resourceName, partitions, states, Integer.MAX_VALUE, new DefaultPlacementScheme());
    }

    public ZNRecord computePartitionAssignment(List<String> liveNodes, Map<String, Map<String, String>> currentMapping, List<String> allNodes) {
        int numReplicas = this.countStateReplicas();
        ZNRecord znRecord = new ZNRecord(this._resourceName);
        if (liveNodes.size() == 0) {
            return znRecord;
        }
        int distRemainder = numReplicas * this._partitions.size() % liveNodes.size();
        int distFloor = numReplicas * this._partitions.size() / liveNodes.size();
        this._nodeMap = new HashMap<String, Node>();
        this._liveNodesList = new ArrayList<Node>();
        for (String id : allNodes) {
            Node node = new Node(id);
            node.capacity = 0;
            node.hasCeilingCapacity = false;
            this._nodeMap.put(id, node);
        }
        for (int i = 0; i < liveNodes.size(); ++i) {
            int targetSize;
            boolean usingCeiling = false;
            int n = targetSize = this._maximumPerNode > 0 ? Math.min(distFloor, this._maximumPerNode) : distFloor;
            if (distRemainder > 0 && targetSize < this._maximumPerNode) {
                --distRemainder;
                usingCeiling = true;
            }
            Node node = this._nodeMap.get(liveNodes.get(i));
            node.isAlive = true;
            node.capacity = ++targetSize;
            node.hasCeilingCapacity = usingCeiling;
            this._liveNodesList.add(node);
        }
        this._stateMap = this.generateStateMap();
        this._preferredAssignment = this.computePreferredPlacement(allNodes);
        this._existingPreferredAssignment = this.computeExistingPreferredPlacement(currentMapping);
        this._existingNonPreferredAssignment = this.computeExistingNonPreferredPlacement(currentMapping);
        this._orphaned = this.computeOrphaned();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("orphan = " + this._orphaned));
        }
        this.moveNonPreferredReplicasToPreferred();
        this.assignOrphans();
        this.moveExcessReplicas();
        this.prepareResult(znRecord);
        return znRecord;
    }

    private void moveNonPreferredReplicasToPreferred() {
        Iterator<Map.Entry<Replica, Node>> iterator = this._existingNonPreferredAssignment.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Replica, Node> entry = iterator.next();
            Replica replica = entry.getKey();
            Node donor = entry.getValue();
            Node receiver = this._preferredAssignment.get(replica);
            if (donor.capacity >= donor.currentlyAssigned || receiver.capacity <= receiver.currentlyAssigned || !receiver.canAdd(replica)) continue;
            --donor.currentlyAssigned;
            ++receiver.currentlyAssigned;
            donor.nonPreferred.remove(replica);
            receiver.preferred.add(replica);
            donor.newReplicas.remove(replica);
            receiver.newReplicas.add(replica);
            iterator.remove();
        }
    }

    private void assignOrphans() {
        Iterator<Replica> it = this._orphaned.iterator();
        while (it.hasNext()) {
            int startIndex;
            Replica replica = it.next();
            boolean added = false;
            for (int index = startIndex = this.computeRandomStartIndex(replica); index < startIndex + this._liveNodesList.size(); ++index) {
                Node receiver = this._liveNodesList.get(index % this._liveNodesList.size());
                if (receiver.capacity <= receiver.currentlyAssigned || !receiver.canAdd(replica)) continue;
                ++receiver.currentlyAssigned;
                receiver.nonPreferred.add(replica);
                receiver.newReplicas.add(replica);
                added = true;
                break;
            }
            if (!added) {
                added = this.assignOrphanByMakingRoom(replica);
            }
            if (!added) continue;
            it.remove();
        }
        if (this._orphaned.size() > 0 && logger.isInfoEnabled()) {
            logger.info((Object)("could not assign nodes to partitions: " + this._orphaned));
        }
    }

    private boolean assignOrphanByMakingRoom(Replica replica) {
        int startIndex;
        Node capacityDonor = null;
        Node capacityAcceptor = null;
        for (int index = startIndex = this.computeRandomStartIndex(replica); index < startIndex + this._liveNodesList.size(); ++index) {
            Node current = this._liveNodesList.get(index % this._liveNodesList.size());
            if (current.hasCeilingCapacity && current.capacity > current.currentlyAssigned && !current.canAddIfCapacity(replica) && capacityDonor == null) {
                capacityDonor = current;
            } else if (!current.hasCeilingCapacity && current.capacity == current.currentlyAssigned && current.canAddIfCapacity(replica) && capacityAcceptor == null) {
                capacityAcceptor = current;
            }
            if (capacityDonor != null && capacityAcceptor != null) break;
        }
        if (capacityDonor != null && capacityAcceptor != null) {
            capacityAcceptor.steal(capacityDonor, replica);
            return true;
        }
        return false;
    }

    private void moveExcessReplicas() {
        for (Node donor : this._liveNodesList) {
            if (donor.capacity >= donor.currentlyAssigned) continue;
            Collections.sort(donor.nonPreferred);
            Iterator it = donor.nonPreferred.iterator();
            while (it.hasNext()) {
                int startIndex;
                Replica replica = (Replica)it.next();
                for (int index = startIndex = this.computeRandomStartIndex(replica); index < startIndex + this._liveNodesList.size(); ++index) {
                    Node receiver = this._liveNodesList.get(index % this._liveNodesList.size());
                    if (!receiver.canAdd(replica)) continue;
                    ++receiver.currentlyAssigned;
                    receiver.nonPreferred.add(replica);
                    --donor.currentlyAssigned;
                    it.remove();
                    break;
                }
                if (donor.capacity < donor.currentlyAssigned) continue;
                break;
            }
            if (donor.capacity >= donor.currentlyAssigned) continue;
            logger.warn((Object)("Could not take partitions out of node:" + donor.id));
        }
    }

    private void prepareResult(ZNRecord znRecord) {
        TreeMap<String, List<String>> newPreferences = new TreeMap<String, List<String>>();
        for (String partition : this._partitions) {
            znRecord.setMapField(partition, new TreeMap<String, String>());
            znRecord.setListField(partition, new ArrayList<String>());
            newPreferences.put(partition, new ArrayList());
        }
        for (Node node : this._liveNodesList) {
            for (Replica replica : node.preferred) {
                if (node.newReplicas.contains(replica)) {
                    ((List)newPreferences.get(replica.partition)).add(node.id);
                    continue;
                }
                znRecord.getListField(replica.partition).add(node.id);
            }
        }
        for (Node node : this._liveNodesList) {
            for (Replica replica : node.nonPreferred) {
                if (node.newReplicas.contains(replica)) {
                    ((List)newPreferences.get(replica.partition)).add(node.id);
                    continue;
                }
                znRecord.getListField(replica.partition).add(node.id);
            }
        }
        this.normalizePreferenceLists(znRecord.getListFields(), newPreferences);
        for (String partition : this._partitions) {
            List<String> preferenceList = znRecord.getListField(partition);
            int i = 0;
            for (String participant : preferenceList) {
                znRecord.getMapField(partition).put(participant, this._stateMap.get(i));
                ++i;
            }
        }
    }

    private void normalizePreferenceLists(Map<String, List<String>> preferenceLists, Map<String, List<String>> newPreferences) {
        HashMap<String, Map<String, Integer>> nodeReplicaCounts = new HashMap<String, Map<String, Integer>>();
        for (String partition : preferenceLists.keySet()) {
            this.normalizePreferenceList(preferenceLists.get(partition), nodeReplicaCounts);
        }
        for (String partition : newPreferences.keySet()) {
            this.normalizePreferenceList(newPreferences.get(partition), nodeReplicaCounts);
            preferenceLists.get(partition).addAll((Collection<String>)newPreferences.get(partition));
        }
    }

    private void normalizePreferenceList(List<String> preferenceList, Map<String, Map<String, Integer>> nodeReplicaCounts) {
        ArrayList<String> newPreferenceList = new ArrayList<String>();
        int replicas = Math.min(this.countStateReplicas(), preferenceList.size());
        LinkedHashSet<String> notAssigned = new LinkedHashSet<String>(preferenceList);
        for (int i = 0; i < replicas; ++i) {
            String state = this._stateMap.get(i);
            String node = this.getMinimumNodeForReplica(state, notAssigned, nodeReplicaCounts);
            newPreferenceList.add(node);
            notAssigned.remove(node);
            Map<String, Integer> counts = nodeReplicaCounts.get(node);
            counts.put(state, counts.get(state) + 1);
        }
        preferenceList.clear();
        preferenceList.addAll(newPreferenceList);
    }

    private String getMinimumNodeForReplica(String state, Set<String> nodes, Map<String, Map<String, Integer>> nodeReplicaCounts) {
        String minimalNode = null;
        int minimalCount = Integer.MAX_VALUE;
        for (String node : nodes) {
            int count = this.getReplicaCountForNode(state, node, nodeReplicaCounts);
            if (count >= minimalCount) continue;
            minimalCount = count;
            minimalNode = node;
        }
        return minimalNode;
    }

    private int getReplicaCountForNode(String state, String node, Map<String, Map<String, Integer>> nodeReplicaCounts) {
        if (!nodeReplicaCounts.containsKey(node)) {
            HashMap<String, Integer> replicaCounts = new HashMap<String, Integer>();
            replicaCounts.put(state, 0);
            nodeReplicaCounts.put(node, replicaCounts);
            return 0;
        }
        Map<String, Integer> replicaCounts = nodeReplicaCounts.get(node);
        if (!replicaCounts.containsKey(state)) {
            replicaCounts.put(state, 0);
            return 0;
        }
        return replicaCounts.get(state);
    }

    private Map<Replica, Node> computeExistingNonPreferredPlacement(Map<String, Map<String, String>> currentMapping) {
        TreeMap<Replica, Node> existingNonPreferredAssignment = new TreeMap<Replica, Node>();
        int count = this.countStateReplicas();
        for (String partition : currentMapping.keySet()) {
            Map<String, String> nodeStateMap = currentMapping.get(partition);
            nodeStateMap.keySet().retainAll(this._nodeMap.keySet());
            block1: for (String nodeId : nodeStateMap.keySet()) {
                Node node = this._nodeMap.get(nodeId);
                boolean skip = false;
                for (Replica replica : node.preferred) {
                    if (!replica.partition.equals(partition)) continue;
                    skip = true;
                    break;
                }
                if (skip) continue;
                for (int replicaId = 0; replicaId < count; ++replicaId) {
                    Replica replica;
                    replica = new Replica(partition, replicaId);
                    if (!this._preferredAssignment.containsKey(replica)) {
                        logger.info((Object)("partitions: " + this._partitions));
                        logger.info((Object)("currentMapping.keySet: " + currentMapping.keySet()));
                        throw new IllegalArgumentException("partition: " + replica + " is in currentMapping but not in partitions");
                    }
                    if (this._preferredAssignment.get(replica).id == node.id || this._existingPreferredAssignment.containsKey(replica) || existingNonPreferredAssignment.containsKey(replica)) continue;
                    existingNonPreferredAssignment.put(replica, node);
                    node.nonPreferred.add(replica);
                    continue block1;
                }
            }
        }
        return existingNonPreferredAssignment;
    }

    private int computeRandomStartIndex(Replica replica) {
        return (replica.hashCode() & Integer.MAX_VALUE) % this._liveNodesList.size();
    }

    private Set<Replica> computeOrphaned() {
        TreeSet<Replica> orphanedPartitions = new TreeSet<Replica>(this._preferredAssignment.keySet());
        for (Replica r : this._existingPreferredAssignment.keySet()) {
            if (!orphanedPartitions.contains(r)) continue;
            orphanedPartitions.remove(r);
        }
        for (Replica r : this._existingNonPreferredAssignment.keySet()) {
            if (!orphanedPartitions.contains(r)) continue;
            orphanedPartitions.remove(r);
        }
        return orphanedPartitions;
    }

    private Map<Replica, Node> computeExistingPreferredPlacement(Map<String, Map<String, String>> currentMapping) {
        TreeMap<Replica, Node> existingPreferredAssignment = new TreeMap<Replica, Node>();
        int count = this.countStateReplicas();
        for (String partition : currentMapping.keySet()) {
            Map<String, String> nodeStateMap = currentMapping.get(partition);
            nodeStateMap.keySet().retainAll(this._nodeMap.keySet());
            block1: for (String nodeId : nodeStateMap.keySet()) {
                Node node = this._nodeMap.get(nodeId);
                ++node.currentlyAssigned;
                for (int replicaId = 0; replicaId < count; ++replicaId) {
                    Replica replica = new Replica(partition, replicaId);
                    if (!this._preferredAssignment.containsKey(replica) || existingPreferredAssignment.containsKey(replica) || this._preferredAssignment.get(replica).id != node.id) continue;
                    existingPreferredAssignment.put(replica, node);
                    node.preferred.add(replica);
                    continue block1;
                }
            }
        }
        return existingPreferredAssignment;
    }

    private Map<Replica, Node> computePreferredPlacement(List<String> allNodes) {
        HashMap<Replica, Node> preferredMapping = new HashMap<Replica, Node>();
        int partitionId = 0;
        int numReplicas = this.countStateReplicas();
        int count = this.countStateReplicas();
        for (String partition : this._partitions) {
            for (int replicaId = 0; replicaId < count; ++replicaId) {
                Replica replica = new Replica(partition, replicaId);
                String nodeName = this._placementScheme.getLocation(partitionId, replicaId, this._partitions.size(), numReplicas, allNodes);
                preferredMapping.put(replica, this._nodeMap.get(nodeName));
            }
            ++partitionId;
        }
        return preferredMapping;
    }

    private int countStateReplicas() {
        int total = 0;
        for (Integer count : this._states.values()) {
            total += count.intValue();
        }
        return total;
    }

    private Map<Integer, String> generateStateMap() {
        int replicaId = 0;
        HashMap<Integer, String> stateMap = new HashMap<Integer, String>();
        for (String state : this._states.keySet()) {
            Integer count = this._states.get(state);
            for (int i = 0; i < count; ++i) {
                stateMap.put(replicaId, state);
                ++replicaId;
            }
        }
        return stateMap;
    }

    public static class DefaultPlacementScheme
    implements ReplicaPlacementScheme {
        @Override
        public void init(HelixManager manager) {
        }

        @Override
        public String getLocation(int partitionId, int replicaId, int numPartitions, int numReplicas, List<String> nodeNames) {
            int index = nodeNames.size() > numPartitions ? (partitionId + replicaId * numPartitions) % nodeNames.size() : (nodeNames.size() == numPartitions ? ((partitionId + replicaId * numPartitions) % nodeNames.size() + replicaId) % nodeNames.size() : (partitionId + replicaId) % nodeNames.size());
            return nodeNames.get(index);
        }
    }

    public static interface ReplicaPlacementScheme {
        public void init(HelixManager var1);

        public String getLocation(int var1, int var2, int var3, int var4, List<String> var5);
    }

    class Replica
    implements Comparable<Replica> {
        private String partition;
        private int replicaId;
        private String format;

        public Replica(String partition, int replicaId) {
            this.partition = partition;
            this.replicaId = replicaId;
            this.format = this.partition + "|" + this.replicaId;
        }

        public String toString() {
            return this.format;
        }

        public boolean equals(Object that) {
            if (that instanceof Replica) {
                return this.format.equals(((Replica)that).format);
            }
            return false;
        }

        public int hashCode() {
            return this.format.hashCode();
        }

        @Override
        public int compareTo(Replica that) {
            if (that instanceof Replica) {
                return this.format.compareTo(that.format);
            }
            return -1;
        }
    }

    class Node {
        public int currentlyAssigned = 0;
        public int capacity;
        public boolean hasCeilingCapacity;
        private final String id;
        boolean isAlive = false;
        private final List<Replica> preferred = new ArrayList<Replica>();
        private final List<Replica> nonPreferred = new ArrayList<Replica>();
        private final Set<Replica> newReplicas = new TreeSet<Replica>();

        public Node(String id) {
            this.id = id;
        }

        public boolean canAdd(Replica replica) {
            if (this.currentlyAssigned >= this.capacity) {
                return false;
            }
            return this.canAddIfCapacity(replica);
        }

        public boolean canAddIfCapacity(Replica replica) {
            if (!this.isAlive) {
                return false;
            }
            for (Replica r : this.preferred) {
                if (!r.partition.equals(replica.partition)) continue;
                return false;
            }
            for (Replica r : this.nonPreferred) {
                if (!r.partition.equals(replica.partition)) continue;
                return false;
            }
            return true;
        }

        public void steal(Node donor, Replica replica) {
            donor.hasCeilingCapacity = false;
            --donor.capacity;
            this.hasCeilingCapacity = true;
            ++this.capacity;
            ++this.currentlyAssigned;
            this.nonPreferred.add(replica);
            this.newReplicas.add(replica);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("##########\nname=").append(this.id).append("\npreferred:").append(this.preferred.size()).append("\nnonpreferred:").append(this.nonPreferred.size());
            return sb.toString();
        }
    }
}

