/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.task;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.text.ParseException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.helix.AccessOption;
import org.apache.helix.ConfigAccessor;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixManager;
import org.apache.helix.HelixProperty;
import org.apache.helix.PropertyKey;
import org.apache.helix.ZNRecord;
import org.apache.helix.model.CurrentState;
import org.apache.helix.model.HelixConfigScope;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.ResourceAssignment;
import org.apache.helix.model.builder.HelixConfigScopeBuilder;
import org.apache.helix.store.HelixPropertyStore;
import org.apache.helix.task.JobConfig;
import org.apache.helix.task.JobContext;
import org.apache.helix.task.JobDag;
import org.apache.helix.task.ScheduleConfig;
import org.apache.helix.task.TaskConfig;
import org.apache.helix.task.TaskPartitionState;
import org.apache.helix.task.Workflow;
import org.apache.helix.task.WorkflowConfig;
import org.apache.helix.task.WorkflowContext;
import org.apache.log4j.Logger;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;

public class TaskUtil {
    private static final Logger LOG = Logger.getLogger(TaskUtil.class);
    public static final String CONTEXT_NODE = "Context";
    public static final String PREV_RA_NODE = "PreviousResourceAssignment";

    public static JobConfig getJobCfg(HelixDataAccessor accessor, String jobResource) {
        HelixProperty jobResourceConfig = TaskUtil.getResourceConfig(accessor, jobResource);
        if (jobResourceConfig == null) {
            return null;
        }
        JobConfig.Builder b = JobConfig.Builder.fromMap(jobResourceConfig.getRecord().getSimpleFields());
        Map<String, Map<String, String>> rawTaskConfigMap = jobResourceConfig.getRecord().getMapFields();
        HashMap taskConfigMap = Maps.newHashMap();
        for (Map<String, String> rawTaskConfig : rawTaskConfigMap.values()) {
            TaskConfig taskConfig = TaskConfig.from(rawTaskConfig);
            taskConfigMap.put(taskConfig.getId(), taskConfig);
        }
        b.addTaskConfigMap(taskConfigMap);
        return b.build();
    }

    public static JobConfig getJobCfg(HelixManager manager, String jobResource) {
        return TaskUtil.getJobCfg(manager.getHelixDataAccessor(), jobResource);
    }

    public static WorkflowConfig getWorkflowCfg(ConfigAccessor cfgAccessor, HelixDataAccessor accessor, String clusterName, String workflowResource) {
        Map<String, String> workflowCfg = TaskUtil.getResourceConfigMap(cfgAccessor, accessor, clusterName, workflowResource);
        if (workflowCfg == null) {
            return null;
        }
        WorkflowConfig.Builder b = WorkflowConfig.Builder.fromMap(workflowCfg);
        return b.build();
    }

    public static WorkflowConfig getWorkflowCfg(HelixManager manager, String workflowResource) {
        return TaskUtil.getWorkflowCfg(manager.getConfigAccessor(), manager.getHelixDataAccessor(), manager.getClusterName(), workflowResource);
    }

    public static boolean setRequestedState(HelixDataAccessor accessor, String instance, String sessionId, String resource, String partition, TaskPartitionState state) {
        LOG.debug((Object)String.format("Requesting a state transition to %s for partition %s.", new Object[]{state, partition}));
        try {
            PropertyKey.Builder keyBuilder = accessor.keyBuilder();
            PropertyKey key = keyBuilder.currentState(instance, sessionId, resource);
            CurrentState currStateDelta = new CurrentState(resource);
            currStateDelta.setRequestedState(partition, state.name());
            return accessor.updateProperty(key, currStateDelta);
        }
        catch (Exception e) {
            LOG.error((Object)String.format("Error when requesting a state transition to %s for partition %s.", new Object[]{state, partition}), (Throwable)e);
            return false;
        }
    }

    public static HelixConfigScope getResourceConfigScope(String clusterName, String resource) {
        return new HelixConfigScopeBuilder(HelixConfigScope.ConfigScopeProperty.RESOURCE).forCluster(clusterName).forResource(resource).build();
    }

    public static ResourceAssignment getPrevResourceAssignment(HelixManager manager, String resourceName) {
        ZNRecord r = (ZNRecord)manager.getHelixPropertyStore().get(Joiner.on((String)"/").join((Object)"/TaskRebalancer", (Object)resourceName, new Object[]{PREV_RA_NODE}), null, AccessOption.PERSISTENT);
        return r != null ? new ResourceAssignment(r) : null;
    }

    public static void setPrevResourceAssignment(HelixManager manager, String resourceName, ResourceAssignment ra) {
        manager.getHelixPropertyStore().set(Joiner.on((String)"/").join((Object)"/TaskRebalancer", (Object)resourceName, new Object[]{PREV_RA_NODE}), ra.getRecord(), AccessOption.PERSISTENT);
    }

    public static JobContext getJobContext(HelixPropertyStore<ZNRecord> propertyStore, String jobResource) {
        ZNRecord r = (ZNRecord)propertyStore.get(Joiner.on((String)"/").join((Object)"/TaskRebalancer", (Object)jobResource, new Object[]{CONTEXT_NODE}), null, AccessOption.PERSISTENT);
        return r != null ? new JobContext(r) : null;
    }

    public static JobContext getJobContext(HelixManager manager, String jobResource) {
        return TaskUtil.getJobContext(manager.getHelixPropertyStore(), jobResource);
    }

    public static void setJobContext(HelixManager manager, String jobResource, JobContext ctx) {
        manager.getHelixPropertyStore().set(Joiner.on((String)"/").join((Object)"/TaskRebalancer", (Object)jobResource, new Object[]{CONTEXT_NODE}), ctx.getRecord(), AccessOption.PERSISTENT);
    }

    public static WorkflowContext getWorkflowContext(HelixPropertyStore<ZNRecord> propertyStore, String workflowResource) {
        ZNRecord r = (ZNRecord)propertyStore.get(Joiner.on((String)"/").join((Object)"/TaskRebalancer", (Object)workflowResource, new Object[]{CONTEXT_NODE}), null, AccessOption.PERSISTENT);
        return r != null ? new WorkflowContext(r) : null;
    }

    public static WorkflowContext getWorkflowContext(HelixManager manager, String workflowResource) {
        return TaskUtil.getWorkflowContext(manager.getHelixPropertyStore(), workflowResource);
    }

    public static void setWorkflowContext(HelixManager manager, String workflowResource, WorkflowContext ctx) {
        manager.getHelixPropertyStore().set(Joiner.on((String)"/").join((Object)"/TaskRebalancer", (Object)workflowResource, new Object[]{CONTEXT_NODE}), ctx.getRecord(), AccessOption.PERSISTENT);
    }

    public static String getNamespacedJobName(String singleJobWorkflow) {
        return TaskUtil.getNamespacedJobName(singleJobWorkflow, singleJobWorkflow);
    }

    public static String getNamespacedJobName(String workflowResource, String jobName) {
        return workflowResource + "_" + jobName;
    }

    public static String getDenamespacedJobName(String workflowResource, String jobName) {
        if (jobName.contains(workflowResource)) {
            return jobName.substring(jobName.indexOf(workflowResource) + workflowResource.length() + 1);
        }
        return jobName;
    }

    public static String serializeJobCommandConfigMap(Map<String, String> commandConfig) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            String serializedMap = mapper.writeValueAsString(commandConfig);
            return serializedMap;
        }
        catch (IOException e) {
            LOG.error((Object)("Error serializing " + commandConfig), (Throwable)e);
            return null;
        }
    }

    public static Map<String, String> deserializeJobCommandConfigMap(String commandConfig) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            Map commandConfigMap = (Map)mapper.readValue(commandConfig, (TypeReference)new TypeReference<HashMap<String, String>>(){});
            return commandConfigMap;
        }
        catch (IOException e) {
            LOG.error((Object)("Error deserializing " + commandConfig), (Throwable)e);
            return Collections.emptyMap();
        }
    }

    public static void invokeRebalance(HelixManager manager, String resource) {
        HelixDataAccessor accessor = manager.getHelixDataAccessor();
        accessor.updateProperty(accessor.keyBuilder().idealStates(resource), new IdealState(resource));
    }

    public static ScheduleConfig parseScheduleFromConfigMap(Map<String, String> cfg) {
        Date startTime = null;
        if (cfg.containsKey("StartTime")) {
            try {
                startTime = WorkflowConfig.DEFAULT_DATE_FORMAT.parse(cfg.get("StartTime"));
            }
            catch (ParseException e) {
                LOG.error((Object)("Unparseable date " + cfg.get("StartTime")), (Throwable)e);
                return null;
            }
        }
        if (cfg.containsKey("RecurrenceUnit") && cfg.containsKey("RecurrenceInterval")) {
            return ScheduleConfig.recurringFromDate(startTime, TimeUnit.valueOf(cfg.get("RecurrenceUnit")), Long.parseLong(cfg.get("RecurrenceInterval")));
        }
        if (startTime != null) {
            return ScheduleConfig.oneTimeDelayedStart(startTime);
        }
        return null;
    }

    public static Workflow cloneWorkflow(HelixManager manager, String origWorkflowName, String newWorkflowName, Date newStartTime) {
        PropertyKey.Builder keyBuilder;
        HelixDataAccessor accessor = manager.getHelixDataAccessor();
        Map resourceConfigMap = accessor.getChildValuesMap((keyBuilder = accessor.keyBuilder()).resourceConfigs());
        if (!resourceConfigMap.containsKey(origWorkflowName)) {
            LOG.error((Object)("No such workflow named " + origWorkflowName));
            return null;
        }
        if (resourceConfigMap.containsKey(newWorkflowName)) {
            LOG.error((Object)("Workflow with name " + newWorkflowName + " already exists!"));
            return null;
        }
        HelixProperty workflowConfig = (HelixProperty)resourceConfigMap.get(origWorkflowName);
        Map<String, String> wfSimpleFields = workflowConfig.getRecord().getSimpleFields();
        JobDag jobDag = JobDag.fromJson(wfSimpleFields.get("Dag"));
        Map<String, Set<String>> parentsToChildren = jobDag.getParentsToChildren();
        Workflow.Builder builder = new Workflow.Builder(newWorkflowName);
        builder.setExpiry(Long.parseLong(wfSimpleFields.get("Expiry")));
        ScheduleConfig scheduleConfig = newStartTime != null ? ScheduleConfig.oneTimeDelayedStart(newStartTime) : TaskUtil.parseScheduleFromConfigMap(wfSimpleFields);
        if (scheduleConfig != null) {
            builder.setScheduleConfig(scheduleConfig);
        }
        Set<String> namespacedJobs = jobDag.getAllNodes();
        for (String namespacedJob : namespacedJobs) {
            if (!resourceConfigMap.containsKey(namespacedJob)) continue;
            String job = TaskUtil.getDenamespacedJobName(origWorkflowName, namespacedJob);
            HelixProperty jobConfig = (HelixProperty)resourceConfigMap.get(namespacedJob);
            Map<String, String> jobSimpleFields = jobConfig.getRecord().getSimpleFields();
            jobSimpleFields.put("WorkflowID", newWorkflowName);
            for (Map.Entry<String, String> e : jobSimpleFields.entrySet()) {
                builder.addConfig(job, e.getKey(), e.getValue());
            }
            Map<String, Map<String, String>> rawTaskConfigMap = jobConfig.getRecord().getMapFields();
            LinkedList taskConfigs = Lists.newLinkedList();
            for (Map<String, String> rawTaskConfig : rawTaskConfigMap.values()) {
                TaskConfig taskConfig = TaskConfig.from(rawTaskConfig);
                taskConfigs.add(taskConfig);
            }
            builder.addTaskConfigs(job, taskConfigs);
            Set<String> children = parentsToChildren.get(namespacedJob);
            if (children == null) continue;
            for (String namespacedChild : children) {
                String child = TaskUtil.getDenamespacedJobName(origWorkflowName, namespacedChild);
                builder.addParentChildDependency(job, child);
            }
        }
        return builder.build();
    }

    private static Map<String, String> getResourceConfigMap(ConfigAccessor cfgAccessor, HelixDataAccessor accessor, String clusterName, String resource) {
        HelixConfigScope scope = TaskUtil.getResourceConfigScope(clusterName, resource);
        List<String> cfgKeys = cfgAccessor.getKeys(scope);
        if (cfgKeys == null || cfgKeys.isEmpty()) {
            return null;
        }
        return TaskUtil.getResourceConfig(accessor, resource).getRecord().getSimpleFields();
    }

    private static HelixProperty getResourceConfig(HelixDataAccessor accessor, String resource) {
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        return accessor.getProperty(keyBuilder.resourceConfig(resource));
    }
}

