/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.activation.DataSource;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.plugins.providers.AbstractEntityProvider;
import org.jboss.resteasy.plugins.providers.ProviderHelper;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;

@Provider
@Consumes(value={"*/*"})
@Produces(value={"*/*"})
public class DataSourceProvider
extends AbstractEntityProvider<DataSource> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataSource readDataSource(InputStream in, MediaType mediaType) throws IOException {
        byte[] buffer;
        int count;
        byte[] memoryBuffer = new byte[4096];
        int readCount = in.read(memoryBuffer, 0, memoryBuffer.length);
        File tempFile = null;
        if (readCount > 0 && (count = in.read(buffer = new byte[4096], 0, buffer.length)) > -1) {
            tempFile = File.createTempFile("resteasy-provider-datasource", null);
            tempFile.deleteOnExit();
            FileOutputStream fos = new FileOutputStream(tempFile);
            fos.write(buffer, 0, count);
            try {
                ProviderHelper.writeTo(in, fos);
            }
            finally {
                fos.close();
            }
        }
        if (readCount == -1) {
            readCount = 0;
        }
        return new SequencedDataSource(memoryBuffer, 0, readCount, tempFile, mediaType.toString());
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return DataSource.class.isAssignableFrom(type);
    }

    public DataSource readFrom(Class<DataSource> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        return DataSourceProvider.readDataSource(entityStream, mediaType);
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return DataSource.class.isAssignableFrom(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(DataSource dataSource, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        InputStream in = dataSource.getInputStream();
        try {
            ProviderHelper.writeTo(in, entityStream);
        }
        finally {
            in.close();
        }
    }

    protected static class SequencedDataSource
    implements DataSource {
        private final byte[] byteBuffer;
        private final int byteBufferOffset;
        private final int byteBufferLength;
        private final File tempFile;
        private final String type;

        protected SequencedDataSource(byte[] byteBuffer, int byteBufferOffset, int byteBufferLength, File tempFile, String type) {
            this.byteBuffer = byteBuffer;
            this.byteBufferOffset = byteBufferOffset;
            this.byteBufferLength = byteBufferLength;
            this.tempFile = tempFile;
            this.type = type;
        }

        public String getContentType() {
            return this.type;
        }

        public InputStream getInputStream() throws IOException {
            ByteArrayInputStream bis = new ByteArrayInputStream(this.byteBuffer, this.byteBufferOffset, this.byteBufferLength);
            if (this.tempFile == null) {
                return bis;
            }
            FileInputStream fis = new FileInputStream(this.tempFile);
            return new SequenceInputStream(bis, fis){

                @Override
                public int read(byte[] b, int off, int len) throws IOException {
                    int r = super.read(b, off, len);
                    if (r == -1) {
                        SequencedDataSource.this.deleteTempFile();
                    }
                    return r;
                }

                @Override
                public int read() throws IOException {
                    int r = super.read();
                    if (r == -1) {
                        SequencedDataSource.this.deleteTempFile();
                    }
                    return r;
                }
            };
        }

        private void deleteTempFile() {
            if (this.tempFile.exists()) {
                this.tempFile.delete();
            }
        }

        public String getName() {
            return "";
        }

        public OutputStream getOutputStream() throws IOException {
            throw new IOException(Messages.MESSAGES.noOutputStreamAllowed());
        }
    }
}

