/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.mvp;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Named;
import org.jboss.errai.ioc.client.container.IOC;
import org.jboss.errai.ioc.client.container.IOCBeanDef;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.uberfire.client.mvp.PerspectiveActivity;
import org.uberfire.client.mvp.SplashScreenActivity;
import org.uberfire.client.mvp.WorkbenchEditorActivity;
import org.uberfire.client.mvp.WorkbenchScreenActivity;

@ApplicationScoped
public class ActivityBeansInfo {
    private static Comparator<String> ALPHABETICAL_ORDER = new Comparator<String>(){

        @Override
        public int compare(String str1, String str2) {
            int res = String.CASE_INSENSITIVE_ORDER.compare(str1, str2);
            if (res == 0) {
                res = str1.compareTo(str2);
            }
            return res;
        }
    };

    public List<String> getAvailableWorkbenchScreensIds() {
        return this.lookupBeansId(WorkbenchScreenActivity.class);
    }

    public List<String> getAvailablePerspectivesIds() {
        return this.lookupBeansId(PerspectiveActivity.class);
    }

    public List<String> getAvailableSplashScreensIds() {
        return this.lookupBeansId(SplashScreenActivity.class);
    }

    public List<String> getAvailableWorkbenchEditorsIds() {
        return this.lookupBeansId(WorkbenchEditorActivity.class);
    }

    private List<String> lookupBeansId(Class<?> activityClass) {
        Collection screens = this.getBeanManager().lookupBeans(activityClass);
        ArrayList<String> result = new ArrayList<String>();
        for (IOCBeanDef beanDef : screens) {
            result.add(this.getId(beanDef));
        }
        Collections.sort(result, ALPHABETICAL_ORDER);
        return result;
    }

    SyncBeanManager getBeanManager() {
        return IOC.getBeanManager();
    }

    private String getId(IOCBeanDef<?> beanDef) {
        for (Annotation annotation : beanDef.getQualifiers()) {
            if (!this.isNamed(annotation)) continue;
            return ((Named)annotation).value();
        }
        if (this.hasBeanName(beanDef)) {
            return beanDef.getName();
        }
        return "";
    }

    boolean isNamed(Annotation annotation) {
        return annotation instanceof Named;
    }

    private boolean hasBeanName(IOCBeanDef<?> beanDef) {
        return beanDef.getName() != null && !beanDef.getName().isEmpty();
    }
}

