/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.plugin;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.Collection;
import java.util.Collections;
import javax.inject.Inject;
import org.uberfire.client.jsapi.JSPlaceRequest;
import org.uberfire.client.plugin.RuntimePluginsServiceProxy;
import org.uberfire.mvp.ParameterizedCommand;
import org.uberfire.mvp.PlaceRequest;

public abstract class JSNativePlugin {
    @Inject
    protected RuntimePluginsServiceProxy runtimePluginsService;
    protected JavaScriptObject obj;
    protected Element element = null;
    private static final Collection<String> ROLES = Collections.emptyList();
    private static final Collection<String> TRAITS = Collections.emptyList();

    public void build(JavaScriptObject obj) {
        if (this.obj != null) {
            throw new RuntimeException("Can't build more than once.");
        }
        this.obj = obj;
        this.buildElement();
    }

    public native String getId();

    public Element getElement() {
        return this.element;
    }

    public String getContextId() {
        String contextId = null;
        if (JSNativePlugin.hasMethod(this.obj, "context_id")) {
            contextId = JSNativePlugin.getContextIdFunctionResult(this.obj);
        } else if (JSNativePlugin.hasStringProperty(this.obj, "context_id")) {
            contextId = JSNativePlugin.getContextId(this.obj);
        }
        return contextId;
    }

    public String getTitle() {
        String title = null;
        if (JSNativePlugin.hasMethod(this.obj, "title")) {
            title = JSNativePlugin.getTitleFunctionResult(this.obj);
        } else if (JSNativePlugin.hasStringProperty(this.obj, "title")) {
            title = JSNativePlugin.getTitle(this.obj);
        }
        if (title == null) {
            title = this.getId();
        }
        return title;
    }

    public String getType() {
        String type = null;
        if (JSNativePlugin.hasMethod(this.obj, "type")) {
            type = JSNativePlugin.getTypeFunctionResult(this.obj);
        } else if (JSNativePlugin.hasStringProperty(this.obj, "type")) {
            type = JSNativePlugin.getType(this.obj);
        }
        if (type == null) {
            type = "";
        }
        return type;
    }

    public void onOpen() {
        if (JSNativePlugin.hasMethod(this.obj, "on_open")) {
            JSNativePlugin.executeOnOpen(this.obj);
        }
    }

    public void onOpen(String URI) {
        if (JSNativePlugin.hasMethod(this.obj, "on_open")) {
            JSNativePlugin.executeOnOpen(this.obj, URI);
        }
    }

    public void onClose() {
        if (JSNativePlugin.hasMethod(this.obj, "on_close")) {
            JSNativePlugin.executeOnClose(this.obj);
        }
    }

    public void onFocus() {
        if (JSNativePlugin.hasMethod(this.obj, "on_focus")) {
            JSNativePlugin.executeOnFocus(this.obj);
        }
    }

    public void onLostFocus() {
        if (JSNativePlugin.hasMethod(this.obj, "on_lost_focus")) {
            JSNativePlugin.executeOnLostFocus(this.obj);
        }
    }

    public boolean onMayClose() {
        if (JSNativePlugin.hasMethod(this.obj, "on_may_close")) {
            return JSNativePlugin.executeOnMayClose(this.obj);
        }
        return true;
    }

    public Collection<String> getRoles() {
        return ROLES;
    }

    public Collection<String> getTraits() {
        return TRAITS;
    }

    protected void buildElement() {
        String content;
        String contentUrl;
        if (JSNativePlugin.hasMethod(this.obj, "templateUrl")) {
            contentUrl = JSNativePlugin.getTemplateUrlFunctionResult(this.obj);
            content = null;
        } else if (JSNativePlugin.hasMethod(this.obj, "template")) {
            content = JSNativePlugin.getTemplateFunctionResult(this.obj);
            contentUrl = null;
        } else if (JSNativePlugin.hasStringProperty(this.obj, "templateUrl")) {
            contentUrl = JSNativePlugin.getTemplateUrl(this.obj);
            content = null;
        } else if (JSNativePlugin.hasStringProperty(this.obj, "template")) {
            content = JSNativePlugin.getTemplate(this.obj);
            contentUrl = null;
        } else {
            content = null;
            contentUrl = null;
        }
        this.element = new SimplePanel((Widget)new Label("Loading")).getElement();
        if (content != null) {
            this.element = new HTML(new SafeHtmlBuilder().appendHtmlConstant(content).toSafeHtml()).getElement();
        } else if (contentUrl != null) {
            this.runtimePluginsService.getTemplateContent(contentUrl, new ParameterizedCommand<String>(){

                public void execute(String parameter) {
                    JSNativePlugin.this.element = new HTML(new SafeHtmlBuilder().appendHtmlConstant(parameter).toSafeHtml()).getElement();
                }
            });
        } else {
            this.element = null;
        }
    }

    public static boolean hasTemplate(JavaScriptObject obj) {
        if (JSNativePlugin.hasMethod(obj, "template") || JSNativePlugin.hasMethod(obj, "templateUrl")) {
            return true;
        }
        return JSNativePlugin.hasStringProperty(obj, "template") || JSNativePlugin.hasStringProperty(obj, "templateUrl");
    }

    public static native boolean hasMethod(JavaScriptObject var0, String var1);

    public static native boolean hasStringProperty(JavaScriptObject var0, String var1);

    public static native boolean hasIntProperty(JavaScriptObject var0, String var1);

    public static native boolean hasBooleanProperty(JavaScriptObject var0, String var1);

    public static native boolean hasArrayProperty(JavaScriptObject var0, String var1);

    private static native String getTemplateUrlFunctionResult(JavaScriptObject var0);

    private static native String getTemplateFunctionResult(JavaScriptObject var0);

    private static native String getContextIdFunctionResult(JavaScriptObject var0);

    private static native String getTypeFunctionResult(JavaScriptObject var0);

    private static native String getTitleFunctionResult(JavaScriptObject var0);

    private static native void executeOnOpen(JavaScriptObject var0, String var1);

    private static native void executeOnOpen(JavaScriptObject var0);

    private static native void executeOnClose(JavaScriptObject var0);

    private static native void executeOnShutdown(JavaScriptObject var0);

    private static native void executeOnStartup(JavaScriptObject var0, String var1);

    private static native void executeOnStartup(JavaScriptObject var0, JSPlaceRequest var1);

    private static native void executeOnFocus(JavaScriptObject var0);

    private static native void executeOnLostFocus(JavaScriptObject var0);

    private static native boolean executeOnMayClose(JavaScriptObject var0);

    private static native String getType(JavaScriptObject var0);

    private static native String getTitle(JavaScriptObject var0);

    private static native String getContextId(JavaScriptObject var0);

    private static native String getTemplate(JavaScriptObject var0);

    private static native String getTemplateUrl(JavaScriptObject var0);

    public void onStartup(String URI) {
        if (JSNativePlugin.hasMethod(this.obj, "on_startup")) {
            JSNativePlugin.executeOnStartup(this.obj, URI);
        }
    }

    public void onStartup(PlaceRequest place) {
        if (JSNativePlugin.hasMethod(this.obj, "on_startup")) {
            JSNativePlugin.executeOnStartup(this.obj, JSPlaceRequest.fromPlaceRequest(place));
        }
    }

    public void onShutdown() {
        if (JSNativePlugin.hasMethod(this.obj, "on_shutdown")) {
            JSNativePlugin.executeOnShutdown(this.obj);
        }
    }
}

