/*
 * Copyright 2012 JBoss, by Red Hat, Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jboss.errai.bus.server.servlet;

/**
 * @author Mike Brock
 */
public enum ServletInitAttribs {
  SERVICE_LOCATOR("service-locator"),
  WEBSOCKETS_PATH_ELEMENT("websocket-path-element"),
  WEBSOCKETS_ENABLED("websockets-enabled"),
  FORCE_SECURE_WEBSOCKETS("force-secure-websockets"),
  AUTO_DISCOVER_SERVICES("auto-discover-services");

  private final String attributeName;

  private ServletInitAttribs(String attributeName) {
    this.attributeName = attributeName;
  }

  public String getAttributeName() {
    return attributeName;
  }

  public String getInitOrContextValue(final InitConfig config, final String defaultValue) {
    String value = getInitOrContextValue(config);
    if (value == null) {
      value = defaultValue;
    }
    return value;
  }

  public String getInitOrContextValue(final InitConfig config) {
    return config.getInitOrContextParameter(getAttributeName());
  }

  public String getInitValue(final InitConfig config) {
    return config.getInitParameter(getAttributeName());
  }

  public String getContextValue(final InitConfig config) {
    return config.getInitParameter(getAttributeName());
  }
}
