/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefDatabase;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevWalk;

public abstract class RefUpdate {
    private ObjectId newValue;
    private boolean force;
    private PersonIdent refLogIdent;
    private String refLogMessage;
    private boolean refLogIncludeResult;
    private ObjectId oldValue;
    private ObjectId expValue;
    private Result result = Result.NOT_ATTEMPTED;
    private final Ref ref;
    private boolean detachingSymbolicRef;
    private boolean checkConflicting = true;

    protected RefUpdate(Ref ref) {
        this.ref = ref;
        this.oldValue = ref.getObjectId();
        this.refLogMessage = "";
    }

    protected abstract RefDatabase getRefDatabase();

    protected abstract Repository getRepository();

    protected abstract boolean tryLock(boolean var1) throws IOException;

    protected abstract void unlock();

    protected abstract Result doUpdate(Result var1) throws IOException;

    protected abstract Result doDelete(Result var1) throws IOException;

    protected abstract Result doLink(String var1) throws IOException;

    public String getName() {
        return this.getRef().getName();
    }

    public Ref getRef() {
        return this.ref;
    }

    public ObjectId getNewObjectId() {
        return this.newValue;
    }

    public void setDetachingSymbolicRef() {
        this.detachingSymbolicRef = true;
    }

    public void setNewObjectId(AnyObjectId id) {
        this.newValue = id.copy();
    }

    public ObjectId getExpectedOldObjectId() {
        return this.expValue;
    }

    public void setExpectedOldObjectId(AnyObjectId id) {
        this.expValue = id != null ? id.toObjectId() : null;
    }

    public boolean isForceUpdate() {
        return this.force;
    }

    public void setForceUpdate(boolean b) {
        this.force = b;
    }

    public PersonIdent getRefLogIdent() {
        return this.refLogIdent;
    }

    public void setRefLogIdent(PersonIdent pi) {
        this.refLogIdent = pi;
    }

    public String getRefLogMessage() {
        return this.refLogMessage;
    }

    protected boolean isRefLogIncludingResult() {
        return this.refLogIncludeResult;
    }

    public void setRefLogMessage(String msg, boolean appendStatus) {
        if (msg == null && !appendStatus) {
            this.disableRefLog();
        } else if (msg == null && appendStatus) {
            this.refLogMessage = "";
            this.refLogIncludeResult = true;
        } else {
            this.refLogMessage = msg;
            this.refLogIncludeResult = appendStatus;
        }
    }

    public void disableRefLog() {
        this.refLogMessage = null;
        this.refLogIncludeResult = false;
    }

    public ObjectId getOldObjectId() {
        return this.oldValue;
    }

    protected void setOldObjectId(ObjectId old) {
        this.oldValue = old;
    }

    public Result getResult() {
        return this.result;
    }

    private void requireCanDoUpdate() {
        if (this.newValue == null) {
            throw new IllegalStateException(JGitText.get().aNewObjectIdIsRequired);
        }
    }

    public Result forceUpdate() throws IOException {
        this.force = true;
        return this.update();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result update() throws IOException {
        RevWalk rw = new RevWalk(this.getRepository());
        try {
            Result result = this.update(rw);
            Object var4_3 = null;
            rw.release();
            return result;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            rw.release();
            throw throwable;
        }
    }

    public Result update(RevWalk walk) throws IOException {
        this.requireCanDoUpdate();
        try {
            this.result = this.updateImpl(walk, new Store(){

                Result execute(Result status) throws IOException {
                    if (status == Result.NO_CHANGE) {
                        return status;
                    }
                    return RefUpdate.this.doUpdate(status);
                }
            });
            return this.result;
        }
        catch (IOException x) {
            this.result = Result.IO_FAILURE;
            throw x;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result delete() throws IOException {
        RevWalk rw = new RevWalk(this.getRepository());
        try {
            Result result = this.delete(rw);
            Object var4_3 = null;
            rw.release();
            return result;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            rw.release();
            throw throwable;
        }
    }

    public Result delete(RevWalk walk) throws IOException {
        String myName = this.getRef().getLeaf().getName();
        if (myName.startsWith("refs/heads/")) {
            Ref head = this.getRefDatabase().getRef("HEAD");
            while (head != null && head.isSymbolic()) {
                if (!myName.equals((head = head.getTarget()).getName())) continue;
                this.result = Result.REJECTED_CURRENT_BRANCH;
                return this.result;
            }
        }
        try {
            this.result = this.updateImpl(walk, new Store(){

                Result execute(Result status) throws IOException {
                    return RefUpdate.this.doDelete(status);
                }
            });
            return this.result;
        }
        catch (IOException x) {
            this.result = Result.IO_FAILURE;
            throw x;
        }
    }

    public Result link(String target) throws IOException {
        Ref dst;
        Ref old;
        block11: {
            block10: {
                if (!target.startsWith("refs/")) {
                    throw new IllegalArgumentException(MessageFormat.format(JGitText.get().illegalArgumentNotA, "refs/"));
                }
                if (this.checkConflicting && this.getRefDatabase().isNameConflicting(this.getName())) {
                    return Result.LOCK_FAILURE;
                }
                if (this.tryLock(false)) break block10;
                Result result = Result.LOCK_FAILURE;
                Object var6_5 = null;
                this.unlock();
                return result;
            }
            old = this.getRefDatabase().getRef(this.getName());
            if (old == null || !old.isSymbolic() || !target.equals((dst = old.getTarget()).getName())) break block11;
            Result result = this.result = Result.NO_CHANGE;
            Object var6_6 = null;
            this.unlock();
            return result;
        }
        try {
            if (old != null && old.getObjectId() != null) {
                this.setOldObjectId(old.getObjectId());
            }
            if ((dst = this.getRefDatabase().getRef(target)) != null && dst.getObjectId() != null) {
                this.setNewObjectId(dst.getObjectId());
            }
            Result result = this.result = this.doLink(target);
            Object var6_7 = null;
            this.unlock();
            return result;
        }
        catch (IOException x) {
            try {
                this.result = Result.IO_FAILURE;
                throw x;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                this.unlock();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result updateImpl(RevWalk walk, Store store) throws IOException {
        Result result;
        block14: {
            RevObject oldObj;
            RevObject newObj;
            block13: {
                block12: {
                    block11: {
                        block10: {
                            ObjectId o;
                            block9: {
                                if (this.oldValue == null && this.checkConflicting && this.getRefDatabase().isNameConflicting(this.getName())) {
                                    return Result.LOCK_FAILURE;
                                }
                                try {
                                    if (this.tryLock(true)) break block9;
                                    Result result2 = Result.LOCK_FAILURE;
                                    Object var8_5 = null;
                                    this.unlock();
                                    return result2;
                                }
                                catch (Throwable throwable) {
                                    Object var8_12 = null;
                                    this.unlock();
                                    throw throwable;
                                }
                            }
                            if (this.expValue == null) break block10;
                            ObjectId objectId = o = this.oldValue != null ? this.oldValue : ObjectId.zeroId();
                            if (AnyObjectId.equals(this.expValue, o)) break block10;
                            Result result3 = Result.LOCK_FAILURE;
                            Object var8_6 = null;
                            this.unlock();
                            return result3;
                        }
                        if (this.oldValue != null) break block11;
                        result = store.execute(Result.NEW);
                        Object var8_7 = null;
                        this.unlock();
                        return result;
                    }
                    newObj = RefUpdate.safeParse(walk, this.newValue);
                    oldObj = RefUpdate.safeParse(walk, this.oldValue);
                    if (newObj != oldObj || this.detachingSymbolicRef) break block12;
                    result = store.execute(Result.NO_CHANGE);
                    Object var8_8 = null;
                    this.unlock();
                    return result;
                }
                if (!this.isForceUpdate()) break block13;
                result = store.execute(Result.FORCED);
                Object var8_9 = null;
                this.unlock();
                return result;
            }
            if (!(newObj instanceof RevCommit) || !(oldObj instanceof RevCommit) || !walk.isMergedInto((RevCommit)oldObj, (RevCommit)newObj)) break block14;
            result = store.execute(Result.FAST_FORWARD);
            Object var8_10 = null;
            this.unlock();
            return result;
        }
        result = Result.REJECTED;
        Object var8_11 = null;
        this.unlock();
        return result;
    }

    public void setCheckConflicting(boolean check) {
        this.checkConflicting = check;
    }

    private static RevObject safeParse(RevWalk rw, AnyObjectId id) throws IOException {
        try {
            return id != null ? rw.parseAny(id) : null;
        }
        catch (MissingObjectException e) {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Result {
        NOT_ATTEMPTED,
        LOCK_FAILURE,
        NO_CHANGE,
        NEW,
        FORCED,
        FAST_FORWARD,
        REJECTED,
        REJECTED_CURRENT_BRANCH,
        IO_FAILURE,
        RENAMED;

    }

    private abstract class Store {
        private Store() {
        }

        abstract Result execute(Result var1) throws IOException;
    }
}

