/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.editor;

import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.IsWidget;
import java.util.Collection;
import java.util.Collections;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.client.editor.JSNativeEditor;
import org.uberfire.client.mvp.AbstractWorkbenchEditorActivity;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;
import org.uberfire.mvp.PlaceRequest;

public class JSEditorActivity
extends AbstractWorkbenchEditorActivity {
    private static final Collection<String> ROLES = Collections.emptyList();
    private static final Collection<String> TRAITS = Collections.emptyList();
    private JSNativeEditor nativeEditor;

    public JSEditorActivity() {
        super(null);
    }

    public JSEditorActivity(JSNativeEditor nativeEditor, PlaceManager placeManager) {
        super(placeManager);
        this.nativeEditor = nativeEditor;
    }

    public void onStartup(ObservablePath path, PlaceRequest place) {
        super.onStartup(path, place);
        this.setupObservablePathCallBacks();
        this.nativeEditor.onStartup(path.toURI());
    }

    public void onOpen() {
        super.onOpen();
        this.nativeEditor.onOpen(this.path.toURI());
    }

    public void onClose() {
        super.onClose();
        this.nativeEditor.onClose();
    }

    public void onShutdown() {
        super.onShutdown();
        this.nativeEditor.onShutdown();
    }

    public String getIdentifier() {
        return this.nativeEditor.getId();
    }

    private void setupObservablePathCallBacks() {
        this.path.onConcurrentUpdate((ParameterizedCommand)new ParameterizedCommand<ObservablePath.OnConcurrentUpdateEvent>(){

            public void execute(ObservablePath.OnConcurrentUpdateEvent parameter) {
                JSEditorActivity.this.nativeEditor.onConcurrentUpdate();
            }
        });
        this.path.onConcurrentDelete((ParameterizedCommand)new ParameterizedCommand<ObservablePath.OnConcurrentDelete>(){

            public void execute(ObservablePath.OnConcurrentDelete parameter) {
                JSEditorActivity.this.nativeEditor.onConcurrentDelete();
            }
        });
        this.path.onConcurrentRename((ParameterizedCommand)new ParameterizedCommand<ObservablePath.OnConcurrentRenameEvent>(){

            public void execute(ObservablePath.OnConcurrentRenameEvent parameter) {
                JSEditorActivity.this.nativeEditor.onConcurrentRename();
            }
        });
        this.path.onConcurrentCopy((ParameterizedCommand)new ParameterizedCommand<ObservablePath.OnConcurrentCopyEvent>(){

            public void execute(ObservablePath.OnConcurrentCopyEvent parameter) {
                JSEditorActivity.this.nativeEditor.onConcurrentCopy();
            }
        });
        this.path.onRename(new Command(){

            public void execute() {
                JSEditorActivity.this.nativeEditor.onRename();
            }
        });
        this.path.onDelete(new Command(){

            public void execute() {
                JSEditorActivity.this.nativeEditor.onDelete();
            }
        });
        this.path.onUpdate(new Command(){

            public void execute() {
                JSEditorActivity.this.nativeEditor.onUpdate();
            }
        });
        this.path.onCopy(new Command(){

            public void execute() {
                JSEditorActivity.this.nativeEditor.onCopy();
            }
        });
    }

    public String getTitle() {
        return this.nativeEditor.getTitle();
    }

    public IsWidget getWidget() {
        return new HTML(this.nativeEditor.getElement().getInnerHTML());
    }

    public String getSignatureId() {
        return null;
    }

    public Collection<String> getRoles() {
        return ROLES;
    }

    public Collection<String> getTraits() {
        return TRAITS;
    }

    public JSNativeEditor getNativeEditor() {
        return this.nativeEditor;
    }
}

