/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.monitoring;

import java.lang.management.ManagementFactory;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.helix.monitoring.StateTransitionContext;
import org.apache.helix.monitoring.StateTransitionDataPoint;
import org.apache.helix.monitoring.mbeans.StateTransitionStatMonitor;
import org.apache.log4j.Logger;

public class ParticipantMonitor {
    private final ConcurrentHashMap<StateTransitionContext, StateTransitionStatMonitor> _monitorMap = new ConcurrentHashMap();
    private static final Logger LOG = Logger.getLogger(ParticipantMonitor.class);
    private MBeanServer _beanServer;

    public ParticipantMonitor() {
        try {
            this._beanServer = ManagementFactory.getPlatformMBeanServer();
        }
        catch (Exception e) {
            LOG.warn((Object)e);
            e.printStackTrace();
            this._beanServer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportTransitionStat(StateTransitionContext cxt, StateTransitionDataPoint data) {
        if (this._beanServer == null) {
            LOG.warn((Object)"bean server is null, skip reporting");
            return;
        }
        try {
            if (!this._monitorMap.containsKey(cxt)) {
                ParticipantMonitor participantMonitor = this;
                synchronized (participantMonitor) {
                    if (!this._monitorMap.containsKey(cxt)) {
                        StateTransitionStatMonitor bean = new StateTransitionStatMonitor(cxt, TimeUnit.MILLISECONDS);
                        this._monitorMap.put(cxt, bean);
                        String beanName = cxt.toString();
                        this.register(bean, this.getObjectName(beanName));
                    }
                }
            }
            this._monitorMap.get(cxt).addDataPoint(data);
        }
        catch (Exception e) {
            LOG.warn((Object)e);
            e.printStackTrace();
        }
    }

    private ObjectName getObjectName(String name) throws MalformedObjectNameException {
        LOG.info((Object)("Registering bean: " + name));
        return new ObjectName("CLMParticipantReport:" + name);
    }

    private void register(Object bean, ObjectName name) {
        if (this._beanServer == null) {
            LOG.warn((Object)"bean server is null, skip reporting");
            return;
        }
        try {
            this._beanServer.unregisterMBean(name);
        }
        catch (Exception e1) {
            // empty catch block
        }
        try {
            this._beanServer.registerMBean(bean, name);
        }
        catch (Exception e) {
            LOG.warn((Object)"Could not register MBean", (Throwable)e);
        }
    }

    public void shutDown() {
        for (StateTransitionContext cxt : this._monitorMap.keySet()) {
            try {
                ObjectName name = this.getObjectName(cxt.toString());
                if (!this._beanServer.isRegistered(name)) continue;
                this._beanServer.unregisterMBean(name);
            }
            catch (Exception e) {
                LOG.warn((Object)("fail to unregister " + cxt.toString()), (Throwable)e);
            }
        }
        this._monitorMap.clear();
    }
}

