/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.jgroups.Address;
import org.jgroups.util.Streamable;
import org.jgroups.util.Util;

public class Digest
implements Streamable,
Iterable<DigestEntry> {
    protected Address[] members;
    protected long[] seqnos;

    protected Digest(Address[] members, long[] seqnos) {
        this.members = members;
        this.seqnos = seqnos;
    }

    public Digest() {
    }

    public Digest(Map<Address, long[]> map) {
        this.createArrays(map);
    }

    public Digest(Digest digest) {
        if (digest == null) {
            return;
        }
        this.createArrays(digest.size());
        System.arraycopy(digest.members, 0, this.members, 0, digest.size());
        System.arraycopy(digest.seqnos, 0, this.seqnos, 0, digest.size() * 2);
    }

    public Digest(Address sender, long highest_delivered, long highest_received) {
        this.members = new Address[]{sender};
        this.seqnos = new long[]{highest_delivered, highest_received};
    }

    public Digest(Address sender, long highest_delivered) {
        this(sender, highest_delivered, highest_delivered);
    }

    public boolean contains(Address member) {
        for (int i = 0; i < this.size(); ++i) {
            Address addr = this.members[i];
            if (addr == null || !addr.equals(member)) continue;
            return true;
        }
        return false;
    }

    public boolean containsAll(Digest other) {
        if (other == null) {
            return false;
        }
        for (int i = 0; i < other.size(); ++i) {
            Address member = other.members[i];
            if (this.contains(member)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        Digest other = (Digest)obj;
        if (!this.sameSenders(other)) {
            return false;
        }
        for (DigestEntry entry : this) {
            Address addr = entry.getMember();
            long[] tmp = other.get(addr);
            if (entry.getHighestDeliveredSeqno() == tmp[0] && entry.getHighestReceivedSeqno() == tmp[1]) continue;
            return false;
        }
        return true;
    }

    public long[] get(Address member) {
        int index = this.find(member);
        if (index < 0) {
            return null;
        }
        return new long[]{this.seqnos[index * 2], this.seqnos[index * 2 + 1]};
    }

    public Set<Address> getMembers() {
        HashSet<Address> retval = new HashSet<Address>(this.size());
        for (int i = 0; i < this.size(); ++i) {
            Address tmp = this.members[i];
            if (tmp == null) continue;
            retval.add(tmp);
        }
        return retval;
    }

    public boolean sameSenders(Digest other) {
        return other != null && this.size() == other.size() && this.containsAll(other);
    }

    public Digest difference(Digest other) {
        long[] tmp;
        if (other == null) {
            return this.copy();
        }
        if (this.equals(other)) {
            return null;
        }
        ConcurrentHashMap<Address, long[]> resultMap = new ConcurrentHashMap<Address, long[]>(7);
        TreeSet<Address> intersection = new TreeSet<Address>(this.getMembers());
        intersection.retainAll(other.getMembers());
        for (Address address : intersection) {
            long[] e2;
            long[] e1 = this.get(address);
            if (e1[0] == (e2 = other.get(address))[0]) continue;
            long low = Math.min(e1[0], e2[0]);
            long high = Math.max(e1[0], e2[0]);
            long[] r = new long[]{low, high};
            resultMap.put(address, r);
        }
        if (intersection.size() != this.size()) {
            TreeSet<Address> thisMinusInteresection = new TreeSet<Address>(this.getMembers());
            thisMinusInteresection.removeAll(intersection);
            for (Address address : thisMinusInteresection) {
                tmp = this.get(address);
                if (tmp == null) continue;
                resultMap.put(address, tmp);
            }
        }
        if (intersection.size() != other.size()) {
            TreeSet<Address> otherMinusInteresection = new TreeSet<Address>(other.getMembers());
            otherMinusInteresection.removeAll(intersection);
            for (Address address : otherMinusInteresection) {
                tmp = other.get(address);
                if (tmp == null) continue;
                resultMap.put(address, tmp);
            }
        }
        return new Digest(resultMap);
    }

    public Digest highestSequence(Digest other) {
        long[] tmp;
        if (other == null) {
            return this.copy();
        }
        if (this.equals(other)) {
            return this;
        }
        ConcurrentHashMap<Address, long[]> resultMap = new ConcurrentHashMap<Address, long[]>(7);
        TreeSet<Address> intersection = new TreeSet<Address>(this.getMembers());
        intersection.retainAll(other.getMembers());
        for (Address address : intersection) {
            long[] e1 = this.get(address);
            long[] e2 = other.get(address);
            long high = Math.max(e1[0], e2[0]);
            long[] r = new long[]{0L, high};
            resultMap.put(address, r);
        }
        if (intersection.size() != this.size()) {
            TreeSet<Address> thisMinusInteresection = new TreeSet<Address>(this.getMembers());
            thisMinusInteresection.removeAll(intersection);
            for (Address address : thisMinusInteresection) {
                tmp = this.get(address);
                if (tmp == null) continue;
                resultMap.put(address, tmp);
            }
        }
        if (intersection.size() != other.size()) {
            TreeSet<Address> otherMinusInteresection = new TreeSet<Address>(other.getMembers());
            otherMinusInteresection.removeAll(intersection);
            for (Address address : otherMinusInteresection) {
                tmp = other.get(address);
                if (tmp == null) continue;
                resultMap.put(address, tmp);
            }
        }
        return new Digest(resultMap);
    }

    public int size() {
        return this.members.length;
    }

    public long highestDeliveredSeqnoAt(Address sender) {
        long[] entry = this.get(sender);
        if (entry == null) {
            return -1L;
        }
        return entry[0];
    }

    public long highestReceivedSeqnoAt(Address sender) {
        long[] entry = this.get(sender);
        if (entry == null) {
            return -1L;
        }
        return entry[1];
    }

    public boolean isGreaterThanOrEqual(Digest other) {
        if (other == null) {
            return true;
        }
        for (DigestEntry entry : this) {
            long their_highest;
            long my_highest;
            Address sender = entry.getMember();
            long[] their_entry = other.get(sender);
            if (their_entry == null || (my_highest = entry.getHighest()) >= (their_highest = Math.max(their_entry[0], their_entry[1]))) continue;
            return false;
        }
        return true;
    }

    public Digest copy() {
        return new Digest(Arrays.copyOf(this.members, this.members.length), Arrays.copyOf(this.seqnos, this.seqnos.length));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        if (this.size() == 0) {
            return "[]";
        }
        int count = 0;
        int size = this.size();
        for (DigestEntry entry : this) {
            Address key = entry.getMember();
            if (!first) {
                sb.append(", ");
            } else {
                first = false;
            }
            sb.append(key).append(": ").append('[').append(entry.getHighestDeliveredSeqno());
            if (entry.getHighestReceivedSeqno() >= 0L) {
                sb.append(" (").append(entry.getHighestReceivedSeqno()).append(")");
            }
            sb.append("]");
            if (Util.MAX_LIST_PRINT_SIZE <= 0 || ++count < Util.MAX_LIST_PRINT_SIZE) continue;
            if (size <= count) break;
            sb.append(", ...");
            break;
        }
        return sb.toString();
    }

    public String toStringSorted() {
        return this.toStringSorted(true);
    }

    public String toStringSorted(boolean print_highest_received) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        if (this.size() == 0) {
            return "[]";
        }
        TreeMap<Address, long[]> copy = new TreeMap<Address, long[]>();
        for (int i = 0; i < this.size(); ++i) {
            Address addr = this.members[i];
            long[] tmp = new long[]{this.seqnos[i * 2], this.seqnos[i * 2 + 1]};
            copy.put(addr, tmp);
        }
        int count = 0;
        int size = copy.size();
        for (Map.Entry entry : copy.entrySet()) {
            Address key = (Address)entry.getKey();
            long[] val = (long[])entry.getValue();
            if (!first) {
                sb.append(", ");
            } else {
                first = false;
            }
            sb.append(key).append(": ").append('[').append(val[0]);
            if (print_highest_received) {
                sb.append(" (").append(val[1]).append(")");
            }
            sb.append("]");
            if (Util.MAX_LIST_PRINT_SIZE <= 0 || ++count < Util.MAX_LIST_PRINT_SIZE) continue;
            if (size <= count) break;
            sb.append(", ...");
            break;
        }
        return sb.toString();
    }

    public String printHighestDeliveredSeqnos() {
        return this.toStringSorted(false);
    }

    @Override
    public void writeTo(DataOutput out) throws Exception {
        int i;
        out.writeShort(this.size());
        for (i = 0; i < this.size(); ++i) {
            Util.writeAddress(this.members[i], out);
        }
        for (i = 0; i < this.size(); ++i) {
            Util.writeLongSequence(this.seqnos[i * 2], this.seqnos[i * 2 + 1], out);
        }
    }

    @Override
    public void readFrom(DataInput in) throws Exception {
        int i;
        int size = in.readShort();
        this.createArrays(size);
        for (i = 0; i < size; ++i) {
            Address addr;
            this.members[i] = addr = Util.readAddress(in);
        }
        for (i = 0; i < size; ++i) {
            long[] tmp = Util.readLongSequence(in);
            this.seqnos[i * 2] = tmp[0];
            this.seqnos[i * 2 + 1] = tmp[1];
        }
    }

    public long serializedSize() {
        long retval = 2L;
        if (this.size() > 0) {
            Address addr = this.members[0];
            retval += (long)(Util.size(addr) * this.size());
        }
        for (int i = 0; i < this.size() * 2; i += 2) {
            retval += (long)Util.size(this.seqnos[i], this.seqnos[i + 1]);
        }
        return retval;
    }

    protected int find(Address member) {
        for (int i = 0; i < this.size(); ++i) {
            Address addr = this.members[i];
            if (addr == null || !addr.equals(member)) continue;
            return i;
        }
        return -1;
    }

    protected void createArrays(int size) {
        this.members = new Address[size];
        this.seqnos = new long[size * 2];
    }

    protected void createArrays(Map<Address, long[]> map) {
        this.createArrays(map.size());
        int index = 0;
        for (Map.Entry<Address, long[]> entry : map.entrySet()) {
            this.members[index] = entry.getKey();
            this.seqnos[index * 2] = entry.getValue()[0];
            this.seqnos[index * 2 + 1] = entry.getValue()[1];
            ++index;
        }
    }

    @Override
    public Iterator<DigestEntry> iterator() {
        return new MyIterator();
    }

    public static class DigestEntry {
        protected final Address member;
        protected final long highest_delivered;
        protected final long highest_received;

        public DigestEntry(Address member, long highest_delivered, long highest_received) {
            this.member = member;
            this.highest_delivered = highest_delivered;
            this.highest_received = highest_received;
        }

        public Address getMember() {
            return this.member;
        }

        public long getHighestDeliveredSeqno() {
            return this.highest_delivered;
        }

        public long getHighestReceivedSeqno() {
            return this.highest_received;
        }

        public long getHighest() {
            return Math.max(this.highest_delivered, this.highest_received);
        }

        public boolean equals(Object obj) {
            DigestEntry other = (DigestEntry)obj;
            return this.member.equals(other.member) && this.highest_delivered == other.highest_delivered && this.highest_received == other.highest_received;
        }

        public String toString() {
            return this.member + ": [" + this.highest_delivered + " (" + this.highest_received + ")]";
        }
    }

    protected class MyIterator
    implements Iterator<DigestEntry> {
        int index = 0;

        protected MyIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.index < Digest.this.size();
        }

        @Override
        public DigestEntry next() {
            if (this.index >= Digest.this.size()) {
                throw new NoSuchElementException("index=" + this.index + ", members.length=" + Digest.this.members.length);
            }
            DigestEntry entry = new DigestEntry(Digest.this.members[this.index], Digest.this.seqnos[this.index * 2], Digest.this.seqnos[this.index * 2 + 1]);
            ++this.index;
            return entry;
        }

        @Override
        public void remove() {
            Digest.this.members[this.index] = null;
        }
    }
}

