/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.examples;

import org.apache.helix.NotificationContext;
import org.apache.helix.model.Message;
import org.apache.helix.participant.statemachine.StateModel;
import org.apache.helix.participant.statemachine.StateModelFactory;

public class LeaderStandbyStateModelFactory
extends StateModelFactory<StateModel> {
    int _delay;

    public LeaderStandbyStateModelFactory(int delay) {
        this._delay = delay;
    }

    @Override
    public StateModel createNewStateModel(String resourceName, String stateUnitKey) {
        LeaderStandbyStateModel stateModel = new LeaderStandbyStateModel();
        stateModel.setDelay(this._delay);
        return stateModel;
    }

    public static class LeaderStandbyStateModel
    extends StateModel {
        int _transDelay = 0;

        public void setDelay(int delay) {
            this._transDelay = delay > 0 ? delay : 0;
        }

        public void onBecomeLeaderFromStandby(Message message, NotificationContext context) {
            System.out.println("LeaderStandbyStateModel.onBecomeLeaderFromStandby()");
            this.sleep();
        }

        public void onBecomeStandbyFromLeader(Message message, NotificationContext context) {
            System.out.println("LeaderStandbyStateModel.onBecomeStandbyFromLeader()");
            this.sleep();
        }

        private void sleep() {
            try {
                Thread.sleep(this._transDelay);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

