/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.manager.zk;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.I0Itec.zkclient.exception.ZkInterruptedException;
import org.apache.log4j.Logger;

public class ZkCacheEventThread
extends Thread {
    private static final Logger LOG = Logger.getLogger(ZkCacheEventThread.class);
    private final BlockingQueue<ZkCacheEvent> _events = new LinkedBlockingQueue<ZkCacheEvent>();
    private static AtomicInteger _eventId = new AtomicInteger(0);

    ZkCacheEventThread(String name) {
        this.setDaemon(true);
        this.setName("ZkCache-EventThread-" + this.getId() + "-" + name);
    }

    @Override
    public void run() {
        LOG.info((Object)"Starting ZkCache event thread.");
        try {
            while (!this.isInterrupted()) {
                ZkCacheEvent zkEvent = this._events.take();
                int eventId = _eventId.incrementAndGet();
                LOG.debug((Object)("Delivering event #" + eventId + " " + zkEvent));
                try {
                    zkEvent.run();
                }
                catch (InterruptedException e) {
                    this.interrupt();
                }
                catch (ZkInterruptedException e) {
                    this.interrupt();
                }
                catch (ThreadDeath death) {
                    throw death;
                }
                catch (Throwable e) {
                    LOG.error((Object)("Error handling event " + zkEvent), e);
                }
                LOG.debug((Object)("Delivering event #" + eventId + " done"));
            }
        }
        catch (InterruptedException e) {
            LOG.info((Object)"Terminate ZkClient event thread.");
        }
    }

    public void send(ZkCacheEvent event) {
        if (!this.isInterrupted()) {
            LOG.debug((Object)("New event: " + event));
            this._events.add(event);
        }
    }

    static abstract class ZkCacheEvent {
        private final String _description;

        public ZkCacheEvent(String description) {
            this._description = description;
        }

        public abstract void run() throws Exception;

        public String toString() {
            return "ZkCacheEvent[" + this._description + "]";
        }
    }
}

