/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.rdf.core.sparql.query.impl;

import java.util.List;
import java.util.Set;
import org.apache.clerezza.rdf.core.BNode;
import org.apache.clerezza.rdf.core.Resource;
import org.apache.clerezza.rdf.core.UriRef;
import org.apache.clerezza.rdf.core.sparql.StringQuerySerializer;
import org.apache.clerezza.rdf.core.sparql.query.AlternativeGraphPattern;
import org.apache.clerezza.rdf.core.sparql.query.AskQuery;
import org.apache.clerezza.rdf.core.sparql.query.BasicGraphPattern;
import org.apache.clerezza.rdf.core.sparql.query.BinaryOperation;
import org.apache.clerezza.rdf.core.sparql.query.BuiltInCall;
import org.apache.clerezza.rdf.core.sparql.query.ConstructQuery;
import org.apache.clerezza.rdf.core.sparql.query.DataSet;
import org.apache.clerezza.rdf.core.sparql.query.DescribeQuery;
import org.apache.clerezza.rdf.core.sparql.query.Expression;
import org.apache.clerezza.rdf.core.sparql.query.FunctionCall;
import org.apache.clerezza.rdf.core.sparql.query.GraphGraphPattern;
import org.apache.clerezza.rdf.core.sparql.query.GraphPattern;
import org.apache.clerezza.rdf.core.sparql.query.GroupGraphPattern;
import org.apache.clerezza.rdf.core.sparql.query.LiteralExpression;
import org.apache.clerezza.rdf.core.sparql.query.OptionalGraphPattern;
import org.apache.clerezza.rdf.core.sparql.query.OrderCondition;
import org.apache.clerezza.rdf.core.sparql.query.ResourceOrVariable;
import org.apache.clerezza.rdf.core.sparql.query.SelectQuery;
import org.apache.clerezza.rdf.core.sparql.query.TriplePattern;
import org.apache.clerezza.rdf.core.sparql.query.UnaryOperation;
import org.apache.clerezza.rdf.core.sparql.query.UriRefExpression;
import org.apache.clerezza.rdf.core.sparql.query.Variable;
import org.apache.clerezza.rdf.core.sparql.query.impl.SimpleQuery;
import org.apache.clerezza.rdf.core.sparql.query.impl.SimpleQueryWithSolutionModifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleStringQuerySerializer
extends StringQuerySerializer {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public String serialize(SelectQuery selectQuery) {
        StringBuffer s = new StringBuffer("SELECT ");
        if (selectQuery.isDistinct()) {
            s.append("DISTINCT\n");
        }
        if (selectQuery.isReduced()) {
            s.append("REDUCED\n");
        }
        if (selectQuery.isSelectAll()) {
            s.append("*");
        } else {
            for (Variable v : selectQuery.getSelection()) {
                this.appendVariable(s, v);
                s.append(" ");
            }
        }
        s.append("\n");
        this.appendDataSet(s, (SimpleQuery)((Object)selectQuery));
        this.appendWhere(s, (SimpleQuery)((Object)selectQuery));
        this.appendModifier(s, (SimpleQueryWithSolutionModifier)((Object)selectQuery));
        return s.toString();
    }

    private void appendVariable(StringBuffer s, Variable v) {
        s.append("?").append(v.getName());
    }

    private void appendDataSet(StringBuffer s, SimpleQuery q) {
        DataSet dataSet = q.getDataSet();
        if (dataSet != null) {
            for (UriRef dg : dataSet.getDefaultGraphs()) {
                s.append("FROM ").append(dg.toString()).append("\n");
            }
            for (UriRef ng : dataSet.getNamedGraphs()) {
                s.append("FROM NAMED ").append(ng.toString()).append("\n");
            }
        }
    }

    private void appendWhere(StringBuffer s, SimpleQuery q) {
        GroupGraphPattern queryPattern = q.getQueryPattern();
        if (queryPattern == null) {
            return;
        }
        s.append("WHERE\n");
        this.appendGroupGraphPattern(s, q.getQueryPattern());
    }

    private void appendGroupGraphPattern(StringBuffer s, GroupGraphPattern groupGraphPattern) {
        s.append("{ ");
        for (GraphPattern graphPattern : groupGraphPattern.getGraphPatterns()) {
            this.appendGraphPattern(s, graphPattern);
        }
        for (Expression e : groupGraphPattern.getFilter()) {
            boolean brackettedExpr = !(e instanceof BuiltInCall) && !(e instanceof FunctionCall);
            s.append("FILTER ");
            if (brackettedExpr) {
                s.append("(");
            }
            this.appendExpression(s, e);
            if (brackettedExpr) {
                s.append(")");
            }
            s.append("\n");
        }
        s.append("} ");
    }

    private void appendGraphPattern(StringBuffer s, GraphPattern graphPattern) {
        if (graphPattern instanceof BasicGraphPattern) {
            this.appendTriplePatterns(s, ((BasicGraphPattern)graphPattern).getTriplePatterns());
        } else if (graphPattern instanceof GroupGraphPattern) {
            this.appendGroupGraphPattern(s, (GroupGraphPattern)graphPattern);
        } else if (graphPattern instanceof OptionalGraphPattern) {
            this.appendGraphPattern(s, ((OptionalGraphPattern)graphPattern).getMainGraphPattern());
            s.append(" OPTIONAL ");
            this.appendGroupGraphPattern(s, ((OptionalGraphPattern)graphPattern).getOptionalGraphPattern());
        } else if (graphPattern instanceof AlternativeGraphPattern) {
            List<GroupGraphPattern> alternativeGraphPatterns = ((AlternativeGraphPattern)graphPattern).getAlternativeGraphPatterns();
            if (alternativeGraphPatterns != null && !alternativeGraphPatterns.isEmpty()) {
                this.appendGroupGraphPattern(s, alternativeGraphPatterns.get(0));
                int size = alternativeGraphPatterns.size();
                for (int i = 1; i < size; ++i) {
                    s.append(" UNION ");
                    this.appendGroupGraphPattern(s, alternativeGraphPatterns.get(i));
                }
            }
        } else if (graphPattern instanceof GraphGraphPattern) {
            s.append("GRAPH ");
            this.appendResourceOrVariable(s, ((GraphGraphPattern)graphPattern).getGraph());
            s.append(" ");
            this.appendGroupGraphPattern(s, ((GraphGraphPattern)graphPattern).getGroupGraphPattern());
        } else {
            this.logger.warn("Unsupported GraphPattern {}", graphPattern.getClass());
        }
    }

    private void appendTriplePatterns(StringBuffer s, Set<TriplePattern> triplePatterns) {
        for (TriplePattern p : triplePatterns) {
            this.appendResourceOrVariable(s, p.getSubject());
            s.append(" ");
            this.appendResourceOrVariable(s, p.getPredicate());
            s.append(" ");
            this.appendResourceOrVariable(s, p.getObject());
            s.append(" .\n");
        }
    }

    private void appendResourceOrVariable(StringBuffer s, ResourceOrVariable n) {
        if (n.isVariable()) {
            this.appendVariable(s, n.getVariable());
        } else {
            Resource r = n.getResource();
            if (r instanceof BNode) {
                s.append("_:").append(r.toString().replace("@", "."));
            } else {
                s.append(r.toString());
            }
        }
    }

    private void appendExpression(StringBuffer s, Expression e) {
        if (e instanceof Variable) {
            this.appendVariable(s, (Variable)e);
        } else if (e instanceof BinaryOperation) {
            BinaryOperation bo = (BinaryOperation)e;
            s.append("(");
            this.appendExpression(s, bo.getLhsOperand());
            s.append(") ").append(bo.getOperatorString()).append(" (");
            this.appendExpression(s, bo.getRhsOperand());
            s.append(")");
        } else if (e instanceof UnaryOperation) {
            UnaryOperation uo = (UnaryOperation)e;
            s.append(uo.getOperatorString()).append(" (");
            this.appendExpression(s, uo.getOperand());
            s.append(")");
        } else if (e instanceof BuiltInCall) {
            BuiltInCall b = (BuiltInCall)e;
            this.appendCall(s, b.getName(), b.getArguements());
        } else if (e instanceof FunctionCall) {
            FunctionCall f = (FunctionCall)e;
            this.appendCall(s, f.getName().getUnicodeString(), f.getArguements());
        } else if (e instanceof LiteralExpression) {
            this.appendLiteralExpression(s, (LiteralExpression)e);
        } else if (e instanceof UriRefExpression) {
            s.append(((UriRefExpression)e).getUriRef().toString());
        }
    }

    private void appendCall(StringBuffer s, String name, List<Expression> expr) {
        s.append(name).append("(");
        for (Expression e : expr) {
            this.appendExpression(s, e);
            s.append(",");
        }
        if (expr.isEmpty()) {
            s.append(")");
        } else {
            s.setCharAt(s.length() - 1, ')');
        }
    }

    private void appendLiteralExpression(StringBuffer s, LiteralExpression le) {
        s.append(le.getLiteral().toString());
    }

    private void appendModifier(StringBuffer s, SimpleQueryWithSolutionModifier q) {
        List<OrderCondition> orderConditions = q.getOrderConditions();
        if (orderConditions != null && !orderConditions.isEmpty()) {
            s.append("ORDER BY ");
            for (OrderCondition oc : orderConditions) {
                this.appendOrderCondition(s, oc);
                s.append("\n");
            }
        }
        if (q.getOffset() > 0) {
            s.append("OFFSET ").append(q.getOffset()).append("\n");
        }
        if (q.getLimit() >= 0) {
            s.append("LIMIT ").append(q.getLimit()).append("\n");
        }
    }

    private void appendOrderCondition(StringBuffer s, OrderCondition oc) {
        if (!oc.isAscending()) {
            s.append("DESC(");
        }
        this.appendExpression(s, oc.getExpression());
        if (!oc.isAscending()) {
            s.append(")");
        }
        s.append(" ");
    }

    @Override
    public String serialize(ConstructQuery constructQuery) {
        StringBuffer s = new StringBuffer("CONSTRUCT\n");
        Set<TriplePattern> triplePatterns = constructQuery.getConstructTemplate();
        s.append("{ ");
        if (triplePatterns != null && !triplePatterns.isEmpty()) {
            this.appendTriplePatterns(s, triplePatterns);
        }
        s.append("}\n");
        this.appendDataSet(s, (SimpleQuery)((Object)constructQuery));
        this.appendWhere(s, (SimpleQuery)((Object)constructQuery));
        this.appendModifier(s, (SimpleQueryWithSolutionModifier)((Object)constructQuery));
        return s.toString();
    }

    @Override
    public String serialize(DescribeQuery describeQuery) {
        StringBuffer s = new StringBuffer("DESCRIBE\n");
        if (describeQuery.isDescribeAll()) {
            s.append("*");
        } else {
            for (ResourceOrVariable n : describeQuery.getResourcesToDescribe()) {
                this.appendResourceOrVariable(s, n);
                s.append(" ");
            }
        }
        this.appendDataSet(s, (SimpleQuery)((Object)describeQuery));
        this.appendWhere(s, (SimpleQuery)((Object)describeQuery));
        this.appendModifier(s, (SimpleQueryWithSolutionModifier)((Object)describeQuery));
        return s.toString();
    }

    @Override
    public String serialize(AskQuery askQuery) {
        StringBuffer s = new StringBuffer("ASK\n");
        this.appendDataSet(s, (SimpleQuery)((Object)askQuery));
        this.appendWhere(s, (SimpleQuery)((Object)askQuery));
        return s.toString();
    }
}

