/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.relocated.freemarker.core;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.uberfire.relocated.freemarker.core.Environment;
import org.uberfire.relocated.freemarker.core.Expression;
import org.uberfire.relocated.freemarker.core.LocalContext;
import org.uberfire.relocated.freemarker.core.Macro;
import org.uberfire.relocated.freemarker.core.TemplateElement;
import org.uberfire.relocated.freemarker.template.TemplateException;
import org.uberfire.relocated.freemarker.template.TemplateModel;
import org.uberfire.relocated.freemarker.template.TemplateModelException;

final class BodyInstruction
extends TemplateElement {
    private List bodyParameters;

    BodyInstruction(List bodyParameters) {
        this.bodyParameters = bodyParameters;
    }

    List getBodyParameters() {
        return this.bodyParameters;
    }

    void accept(Environment env) throws IOException, TemplateException {
        Context bodyContext = new Context(env);
        env.visit(bodyContext);
    }

    public String getCanonicalForm() {
        StringBuffer buf = new StringBuffer("<#nested");
        if (this.bodyParameters != null) {
            for (int i = 0; i < this.bodyParameters.size(); ++i) {
                buf.append(' ');
                buf.append(this.bodyParameters.get(i));
            }
        }
        buf.append('>');
        return buf.toString();
    }

    public String getDescription() {
        return "nested macro content";
    }

    class Context
    implements LocalContext {
        Macro.Context invokingMacroContext;
        Environment.Namespace bodyVars;

        Context(Environment env) throws TemplateException {
            this.invokingMacroContext = env.getCurrentMacroContext();
            List bodyParameterNames = this.invokingMacroContext.bodyParameterNames;
            if (BodyInstruction.this.bodyParameters != null) {
                for (int i = 0; i < BodyInstruction.this.bodyParameters.size(); ++i) {
                    Expression exp = (Expression)BodyInstruction.this.bodyParameters.get(i);
                    TemplateModel tm = exp.getAsTemplateModel(env);
                    if (bodyParameterNames == null || i >= bodyParameterNames.size()) continue;
                    String bodyParameterName = (String)bodyParameterNames.get(i);
                    if (this.bodyVars == null) {
                        this.bodyVars = new Environment.Namespace(env);
                    }
                    this.bodyVars.put(bodyParameterName, tm);
                }
            }
        }

        public TemplateModel getLocalVariable(String name) throws TemplateModelException {
            return this.bodyVars == null ? null : this.bodyVars.get(name);
        }

        public Collection getLocalVariableNames() {
            List bodyParameterNames = this.invokingMacroContext.bodyParameterNames;
            return bodyParameterNames == null ? Collections.EMPTY_LIST : bodyParameterNames;
        }
    }
}

