/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletContext;
import org.jboss.resteasy.cdi.CdiConstructorInjector;
import org.jboss.resteasy.cdi.CdiPropertyInjector;
import org.jboss.resteasy.cdi.ResteasyCdiExtension;
import org.jboss.resteasy.cdi.i18n.LogMessages;
import org.jboss.resteasy.cdi.i18n.Messages;
import org.jboss.resteasy.core.ValueInjector;
import org.jboss.resteasy.spi.ConstructorInjector;
import org.jboss.resteasy.spi.InjectorFactory;
import org.jboss.resteasy.spi.MethodInjector;
import org.jboss.resteasy.spi.PropertyInjector;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public class CdiInjectorFactory
implements InjectorFactory {
    public static final String BEAN_MANAGER_ATTRIBUTE_PREFIX = "org.jboss.weld.environment.servlet.";
    private ResteasyProviderFactory providerFactory;
    private InjectorFactory delegate;
    private BeanManager manager;
    private ResteasyCdiExtension extension;
    private Map<Class<?>, Type> sessionBeanInterface;

    public CdiInjectorFactory(ResteasyProviderFactory providerFactory) {
        this.providerFactory = providerFactory;
        this.delegate = providerFactory.getInjectorFactory();
        this.manager = this.lookupBeanManager();
        this.extension = this.lookupResteasyCdiExtension();
        this.sessionBeanInterface = this.extension.getSessionBeanInterface();
    }

    public ConstructorInjector createConstructor(Constructor constructor) {
        Class clazz = constructor.getDeclaringClass();
        if (!this.manager.getBeans(clazz, new Annotation[0]).isEmpty()) {
            LogMessages.LOGGER.debug(Messages.MESSAGES.usingCdiConstructorInjector(clazz));
            return new CdiConstructorInjector(clazz, this.manager);
        }
        if (this.sessionBeanInterface.containsKey(clazz)) {
            Type intfc = this.sessionBeanInterface.get(clazz);
            LogMessages.LOGGER.debug(Messages.MESSAGES.usingInterfaceForLookup(intfc, clazz));
            return new CdiConstructorInjector(intfc, this.manager);
        }
        LogMessages.LOGGER.debug(Messages.MESSAGES.noCDIBeansFound(clazz));
        return this.delegate.createConstructor(constructor);
    }

    public MethodInjector createMethodInjector(Class root, Method method) {
        return this.delegate.createMethodInjector(root, method);
    }

    public PropertyInjector createPropertyInjector(Class resourceClass) {
        return new CdiPropertyInjector(this.delegate.createPropertyInjector(resourceClass), resourceClass, this.sessionBeanInterface, this.manager);
    }

    public ValueInjector createParameterExtractor(Class injectTargetClass, AccessibleObject injectTarget, Class type, Type genericType, Annotation[] annotations) {
        return this.delegate.createParameterExtractor(injectTargetClass, injectTarget, type, genericType, annotations);
    }

    public ValueInjector createParameterExtractor(Class injectTargetClass, AccessibleObject injectTarget, Class type, Type genericType, Annotation[] annotations, boolean useDefault) {
        return this.delegate.createParameterExtractor(injectTargetClass, injectTarget, type, genericType, annotations, useDefault);
    }

    protected BeanManager lookupBeanManager() {
        BeanManager beanManager = null;
        beanManager = this.lookupBeanManagerInJndi("java:comp/BeanManager");
        if (beanManager != null) {
            LogMessages.LOGGER.info(Messages.MESSAGES.foundBeanManagerAtJavaComp());
            return beanManager;
        }
        beanManager = this.lookupBeanManagerInJndi("java:app/BeanManager");
        if (beanManager != null) {
            LogMessages.LOGGER.info(Messages.MESSAGES.foundBeanManagerAtJavaApp());
            return beanManager;
        }
        ServletContext servletContext = (ServletContext)ResteasyProviderFactory.getContextData(ServletContext.class);
        beanManager = (BeanManager)servletContext.getAttribute(BEAN_MANAGER_ATTRIBUTE_PREFIX + BeanManager.class.getName());
        if (beanManager != null) {
            LogMessages.LOGGER.debug(Messages.MESSAGES.foundBeanManagerInServletContext());
            return beanManager;
        }
        beanManager = (BeanManager)servletContext.getAttribute(BeanManager.class.getName());
        if (beanManager != null) {
            LogMessages.LOGGER.debug(Messages.MESSAGES.foundBeanManagerInServletContext());
            return beanManager;
        }
        throw new RuntimeException(Messages.MESSAGES.unableToLookupBeanManager());
    }

    private BeanManager lookupBeanManagerInJndi(String name) {
        try {
            InitialContext ctx = new InitialContext();
            LogMessages.LOGGER.debug(Messages.MESSAGES.doingALookupForBeanManager(name));
            return (BeanManager)ctx.lookup(name);
        }
        catch (NamingException e) {
            LogMessages.LOGGER.debug(Messages.MESSAGES.unableToObtainBeanManager(name));
            return null;
        }
        catch (NoClassDefFoundError ncdfe) {
            LogMessages.LOGGER.debug(Messages.MESSAGES.unableToPerformJNDILookups());
            return null;
        }
    }

    private ResteasyCdiExtension lookupResteasyCdiExtension() {
        Set beans = this.manager.getBeans(ResteasyCdiExtension.class, new Annotation[0]);
        Bean bean = this.manager.resolve(beans);
        if (bean == null) {
            throw new IllegalStateException(Messages.MESSAGES.unableToObtainResteasyCdiExtension());
        }
        CreationalContext context = this.manager.createCreationalContext((Contextual)bean);
        return (ResteasyCdiExtension)this.manager.getReference(bean, ResteasyCdiExtension.class, context);
    }
}

