/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.command;

import org.apache.sshd.server.Command;
import org.apache.sshd.server.CommandFactory;
import org.apache.sshd.server.command.ScpCommand;

public class ScpCommandFactory
implements CommandFactory {
    private CommandFactory delegate;

    public ScpCommandFactory() {
    }

    public ScpCommandFactory(CommandFactory delegate) {
        this.delegate = delegate;
    }

    public Command createCommand(String command) {
        try {
            if (!command.startsWith("scp")) {
                throw new IllegalArgumentException("Unknown command, does not begin with 'scp'");
            }
            return new ScpCommand(command);
        }
        catch (IllegalArgumentException iae) {
            if (this.delegate != null) {
                return this.delegate.createCommand(command);
            }
            throw iae;
        }
    }
}

