/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.workbench.panels.impl;

import com.google.gwt.user.client.ui.IsWidget;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.uberfire.client.mvp.PerspectiveManager;
import org.uberfire.client.workbench.panels.WorkbenchPanelPresenter;
import org.uberfire.client.workbench.panels.WorkbenchPanelView;
import org.uberfire.client.workbench.part.WorkbenchPartPresenter;
import org.uberfire.client.workbench.pmgr.nswe.part.WorkbenchPartPresenterDefault;
import org.uberfire.debug.Debug;
import org.uberfire.workbench.model.PanelDefinition;
import org.uberfire.workbench.model.PartDefinition;
import org.uberfire.workbench.model.Position;

public abstract class AbstractWorkbenchPanelPresenter<P extends AbstractWorkbenchPanelPresenter<P>>
implements WorkbenchPanelPresenter {
    private WorkbenchPanelPresenter parent;
    private final WorkbenchPanelView<P> view;
    protected final PerspectiveManager perspectiveManager;
    private PanelDefinition definition;
    protected final Map<Position, WorkbenchPanelPresenter> childPanels = new LinkedHashMap<Position, WorkbenchPanelPresenter>();

    public AbstractWorkbenchPanelPresenter(WorkbenchPanelView<P> view, PerspectiveManager perspectiveManager) {
        this.view = view;
        this.perspectiveManager = perspectiveManager;
    }

    protected abstract P asPresenterType();

    @PostConstruct
    void init() {
        this.getPanelView().init(this.asPresenterType());
    }

    @Override
    public WorkbenchPanelPresenter getParent() {
        return this.parent;
    }

    @Override
    public void setParent(WorkbenchPanelPresenter parent) {
        this.parent = parent;
    }

    @Override
    public PanelDefinition getDefinition() {
        return this.definition;
    }

    @Override
    public String getDefaultChildType() {
        return this.getClass().getName();
    }

    @Override
    public void setDefinition(PanelDefinition definition) {
        this.definition = definition;
        this.view.setElementId(definition.getElementId());
    }

    @Override
    public void addPart(WorkbenchPartPresenter part) {
        this.addPart(part, null);
    }

    @Override
    public void addPart(WorkbenchPartPresenter part, String contextId) {
        if (!this.definition.getParts().contains(part.getDefinition())) {
            this.definition.addPart(part.getDefinition());
        }
        this.getPanelView().addPart(part.getPartView());
    }

    @Override
    public boolean removePart(PartDefinition part) {
        this.view.removePart(part);
        return this.definition.removePart(part);
    }

    @Override
    public void addPanel(WorkbenchPanelPresenter child, Position position) {
        if (this.childPanels.containsKey(position)) {
            throw new IllegalStateException("This panel already has a " + position + " child");
        }
        this.definition.insertChild(position, child.getDefinition());
        this.getPanelView().addPanel(child.getDefinition(), child.getPanelView(), position);
        this.childPanels.put(position, child);
        child.setParent(this);
    }

    @Override
    public boolean removePanel(WorkbenchPanelPresenter child) {
        Position position = this.positionOf(child);
        if (position == null) {
            return false;
        }
        this.getPanelView().removePanel(child.getPanelView());
        this.definition.removeChild(position);
        this.childPanels.remove(position);
        child.setParent(null);
        return true;
    }

    @Override
    public Map<Position, WorkbenchPanelPresenter> getPanels() {
        return Collections.unmodifiableMap(this.childPanels);
    }

    protected Position positionOf(WorkbenchPanelPresenter child) {
        for (Map.Entry<Position, WorkbenchPanelPresenter> entry : this.childPanels.entrySet()) {
            if (child != entry.getValue()) continue;
            return entry.getKey();
        }
        return null;
    }

    @Override
    public void changeTitle(PartDefinition part, String title, IsWidget titleDecorator) {
        this.getPanelView().changeTitle(part, title, titleDecorator);
    }

    @Override
    public void setFocus(boolean hasFocus) {
        this.view.setFocus(hasFocus);
    }

    @Override
    public boolean selectPart(PartDefinition part) {
        if (!this.contains(part)) {
            return false;
        }
        this.view.selectPart(part);
        return true;
    }

    private boolean contains(PartDefinition part) {
        return this.definition.getParts().contains(part);
    }

    @Override
    public void maximize() {
        this.view.maximize();
    }

    @Override
    public void unmaximize() {
        this.view.unmaximize();
    }

    @Override
    public WorkbenchPanelView<P> getPanelView() {
        return this.view;
    }

    @Override
    public void onResize(int width, int height) {
        this.getDefinition().setWidth(width == 0 ? null : Integer.valueOf(width));
        this.getDefinition().setHeight(height == 0 ? null : Integer.valueOf(height));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getName());
        sb.append(Debug.objectId((Object)this));
        if (this.getDefinition() == null) {
            sb.append(" (no definition)");
        } else {
            sb.append(" id=").append(this.getDefinition().getElementId());
        }
        return sb.toString();
    }

    @Override
    public Class<? extends WorkbenchPartPresenter> getPartType() {
        return WorkbenchPartPresenterDefault.class;
    }
}

