/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.perspective;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.core.client.JsArray;
import com.google.gwt.json.client.JSONObject;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.uberfire.client.jsapi.JSPlaceRequest;
import org.uberfire.client.mvp.ActivityManager;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.perspective.JSPanelDefinition;
import org.uberfire.client.perspective.JSPartDefinition;
import org.uberfire.client.plugin.JSNativePlugin;
import org.uberfire.client.workbench.PanelManager;
import org.uberfire.client.workbench.WorkbenchServicesProxy;
import org.uberfire.client.workbench.panels.impl.MultiTabWorkbenchPanelPresenter;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.workbench.model.CompassPosition;
import org.uberfire.workbench.model.ContextDefinition;
import org.uberfire.workbench.model.ContextDisplayMode;
import org.uberfire.workbench.model.PanelDefinition;
import org.uberfire.workbench.model.PartDefinition;
import org.uberfire.workbench.model.PerspectiveDefinition;
import org.uberfire.workbench.model.Position;
import org.uberfire.workbench.model.impl.ContextDefinitionImpl;
import org.uberfire.workbench.model.impl.PanelDefinitionImpl;
import org.uberfire.workbench.model.impl.PartDefinitionImpl;
import org.uberfire.workbench.model.impl.PerspectiveDefinitionImpl;

@Dependent
public class JSNativePerspective {
    @Inject
    private PanelManager panelManager;
    @Inject
    private PlaceManager placeManager;
    @Inject
    private ActivityManager activityManager;
    @Inject
    private WorkbenchServicesProxy wbServices;
    private JavaScriptObject obj;

    public void build(JavaScriptObject obj) {
        if (this.obj != null) {
            throw new RuntimeException("Can't build more than once.");
        }
        this.obj = obj;
    }

    public native String getId();

    public native boolean isDefault();

    public native boolean isTransient();

    private native String getPanelTypeAsString();

    private native String getContextDisplayModeAsString();

    private native String getContextId();

    public void onStartup(PlaceRequest place) {
        if (JSNativePlugin.hasMethod(this.obj, "on_startup")) {
            JSNativePerspective.executeOnStartup(this.obj, JSPlaceRequest.fromPlaceRequest(place));
        }
    }

    public void onOpen() {
        if (JSNativePlugin.hasMethod(this.obj, "on_open")) {
            JSNativePerspective.executeOnOpen(this.obj);
        }
    }

    public void onClose() {
        if (JSNativePlugin.hasMethod(this.obj, "on_close")) {
            JSNativePerspective.executeOnClose(this.obj);
        }
    }

    public void onShutdown() {
        if (JSNativePlugin.hasMethod(this.obj, "on_shutdown")) {
            JSNativePerspective.executeOnShutdown(this.obj);
        }
    }

    public PerspectiveDefinition buildPerspective() {
        PerspectiveDefinitionImpl perspectiveDefinition = new PerspectiveDefinitionImpl(this.getDefaultPanelType());
        perspectiveDefinition.setName(this.getId());
        String contextId = this.getContextId();
        if (contextId != null) {
            perspectiveDefinition.setContextDefinition((ContextDefinition)new ContextDefinitionImpl((PlaceRequest)new DefaultPlaceRequest(contextId)));
        }
        perspectiveDefinition.setContextDisplayMode(this.getContextDisplayMode());
        JSPanelDefinition view = JSNativePerspective.getView(this.obj);
        JsArray<JSPartDefinition> parts = view.getParts();
        JsArray<JSPanelDefinition> panels = view.getChildren();
        PanelDefinition root = perspectiveDefinition.getRoot();
        this.buildParts(root, parts);
        this.buildPanels(root, panels);
        return perspectiveDefinition;
    }

    private String getDefaultPanelType() {
        return this.getPanelType(this.getPanelTypeAsString(), MultiTabWorkbenchPanelPresenter.class.getName());
    }

    private ContextDisplayMode getContextDisplayMode() {
        return this.getContextDisplayMode(this.getContextDisplayModeAsString(), ContextDisplayMode.SHOW);
    }

    private ContextDisplayMode getContextDisplayMode(String contextDisplayMode, ContextDisplayMode defaultType) {
        if (contextDisplayMode == null) {
            return defaultType;
        }
        try {
            return ContextDisplayMode.valueOf((String)contextDisplayMode.toUpperCase());
        }
        catch (Exception ex) {
            return defaultType;
        }
    }

    private String getPanelType(String panelType, String defaultType) {
        if (panelType == null) {
            return defaultType;
        }
        return panelType;
    }

    private void buildParts(PanelDefinition panel, JsArray<JSPartDefinition> parts) {
        if (parts != null) {
            for (int i = 0; i < parts.length(); ++i) {
                JSPartDefinition part = (JSPartDefinition)parts.get(i);
                DefaultPlaceRequest placeRequest = new DefaultPlaceRequest(part.getPlaceName());
                if (part.getParameters() != null) {
                    JSONObject json = new JSONObject(part.getParameters());
                    for (String key : json.keySet()) {
                        placeRequest.addParameter(key, json.get(key).isString().stringValue());
                    }
                }
                PartDefinitionImpl partDefinition = new PartDefinitionImpl((PlaceRequest)placeRequest);
                partDefinition.setContextDisplayMode(this.getContextDisplayMode(part.getContextDisplayModeAsString(), ContextDisplayMode.SHOW));
                if (part.getContextId() != null) {
                    partDefinition.setContextDefinition((ContextDefinition)new ContextDefinitionImpl((PlaceRequest)new DefaultPlaceRequest(part.getContextId())));
                }
                panel.addPart((PartDefinition)partDefinition);
            }
        }
    }

    private void buildPanels(PanelDefinition panel, JsArray<JSPanelDefinition> panels) {
        if (panels != null) {
            for (int i = 0; i < panels.length(); ++i) {
                JSPanelDefinition activePanelDef = (JSPanelDefinition)panels.get(i);
                PanelDefinitionImpl newPanel = new PanelDefinitionImpl(this.getPanelType(activePanelDef.getPanelTypeAsString(), MultiTabWorkbenchPanelPresenter.class.getName()));
                newPanel.setContextDisplayMode(this.getContextDisplayMode(activePanelDef.getContextDisplayModeAsString(), ContextDisplayMode.SHOW));
                if (activePanelDef.getContextId() != null) {
                    newPanel.setContextDefinition((ContextDefinition)new ContextDefinitionImpl((PlaceRequest)new DefaultPlaceRequest(activePanelDef.getContextId())));
                }
                if (activePanelDef.getWidth() > 0) {
                    newPanel.setWidth(Integer.valueOf(activePanelDef.getWidth()));
                }
                if (activePanelDef.getMinWidth() > 0) {
                    newPanel.setMinWidth(Integer.valueOf(activePanelDef.getMinWidth()));
                }
                if (activePanelDef.getHeight() > 0) {
                    newPanel.setHeight(Integer.valueOf(activePanelDef.getHeight()));
                }
                if (activePanelDef.getMinHeight() > 0) {
                    newPanel.setHeight(Integer.valueOf(activePanelDef.getMinHeight()));
                }
                this.buildParts((PanelDefinition)newPanel, activePanelDef.getParts());
                this.buildPanels((PanelDefinition)newPanel, activePanelDef.getChildren());
                panel.insertChild((Position)CompassPosition.valueOf((String)activePanelDef.getPosition().toUpperCase()), (PanelDefinition)newPanel);
            }
        }
    }

    private static native JSPanelDefinition getView(JavaScriptObject var0);

    private static native void executeOnStartup(JavaScriptObject var0, JSPlaceRequest var1);

    private static native void executeOnOpen(JavaScriptObject var0);

    private static native void executeOnClose(JavaScriptObject var0);

    private static native void executeOnShutdown(JavaScriptObject var0);

    public PanelManager getPanelManager() {
        return this.panelManager;
    }

    public PlaceManager getPlaceManager() {
        return this.placeManager;
    }

    public ActivityManager getActivityManager() {
        return this.activityManager;
    }

    public WorkbenchServicesProxy getWbServices() {
        return this.wbServices;
    }
}

