/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multiset;
import com.google.common.graph.AbstractUndirectedNodeConnections;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

final class UndirectedMultiNodeConnections<N, E>
extends AbstractUndirectedNodeConnections<N, E> {
    private transient Reference<Multiset<N>> adjacentNodesReference;

    private UndirectedMultiNodeConnections(Map<E, N> incidentEdges) {
        super(incidentEdges);
    }

    static <N, E> UndirectedMultiNodeConnections<N, E> of() {
        return new UndirectedMultiNodeConnections(Maps.newHashMapWithExpectedSize(11));
    }

    static <N, E> UndirectedMultiNodeConnections<N, E> ofImmutable(Map<E, N> incidentEdges) {
        return new UndirectedMultiNodeConnections<N, E>(ImmutableMap.copyOf(incidentEdges));
    }

    @Override
    public Set<E> edgesConnecting(final Object node) {
        return Collections.unmodifiableSet(Maps.filterEntries(this.incidentEdgeMap, new Predicate<Map.Entry<E, N>>(){

            @Override
            public boolean apply(Map.Entry<E, N> entry) {
                return entry.getValue().equals(node);
            }
        }).keySet());
    }

    @Override
    public Set<N> adjacentNodes() {
        Multiset<N> adjacentNodes = UndirectedMultiNodeConnections.getReference(this.adjacentNodesReference);
        if (adjacentNodes == null) {
            adjacentNodes = HashMultiset.create(this.incidentEdgeMap.values());
            this.adjacentNodesReference = new SoftReference<Multiset<N>>(adjacentNodes);
        }
        return Collections.unmodifiableSet(adjacentNodes.elementSet());
    }

    @Override
    public N removeInEdge(Object edge) {
        return this.removeOutEdge(edge);
    }

    @Override
    public N removeOutEdge(Object edge) {
        Multiset<N> adjacentNodes;
        Object node = super.removeOutEdge(edge);
        if (node != null && (adjacentNodes = UndirectedMultiNodeConnections.getReference(this.adjacentNodesReference)) != null) {
            Preconditions.checkState(adjacentNodes.remove(node));
        }
        return node;
    }

    @Override
    public boolean addInEdge(E edge, N node) {
        return this.addOutEdge(edge, node);
    }

    @Override
    public boolean addOutEdge(E edge, N node) {
        if (super.addOutEdge(edge, node)) {
            Multiset<N> adjacentNodes = UndirectedMultiNodeConnections.getReference(this.adjacentNodesReference);
            if (adjacentNodes != null) {
                Preconditions.checkState(adjacentNodes.add(node));
            }
            return true;
        }
        return false;
    }

    @Nullable
    private static <T> T getReference(@Nullable Reference<T> reference) {
        if (reference == null) {
            return null;
        }
        return reference.get();
    }
}

