/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.security.client.authz.tree.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.uberfire.security.authz.Permission;
import org.uberfire.security.authz.PermissionCollection;
import org.uberfire.security.client.authz.tree.LoadCallback;
import org.uberfire.security.client.authz.tree.PermissionNode;
import org.uberfire.security.client.authz.tree.PermissionTree;
import org.uberfire.security.client.authz.tree.PermissionTreeProvider;
import org.uberfire.security.client.authz.tree.impl.DefaultLoadOptions;
import org.uberfire.security.client.authz.tree.impl.PermissionLeafNode;

public class AbstractPermissionNode
implements PermissionNode {
    private PermissionTree permissionTree = null;
    private PermissionTreeProvider permissionTreeProvider = null;
    private PermissionNode parentNode = null;
    private List<Permission> permissionList = new ArrayList<Permission>();
    private Map<String, Object> propertyMap = new HashMap<String, Object>();
    private Map<String, String> grantNameMap = new HashMap<String, String>();
    private Map<String, String> denyNameMap = new HashMap<String, String>();
    private String nodeName = null;
    private String nodeFullName = null;
    private boolean expanded = false;
    private int positionInTree = 0;

    @Override
    public PermissionTree getPermissionTree() {
        return this.permissionTree;
    }

    @Override
    public void setPermissionTree(PermissionTree permissionTree) {
        this.permissionTree = permissionTree;
    }

    @Override
    public PermissionTreeProvider getPermissionTreeProvider() {
        PermissionTreeProvider provider = this.permissionTreeProvider;
        for (PermissionNode node = this; provider == null && node != null; node = node.getParentNode()) {
            provider = node.getPermissionTreeProvider();
        }
        return provider;
    }

    @Override
    public void setPermissionTreeProvider(PermissionTreeProvider permissionTreeProvider) {
        this.permissionTreeProvider = permissionTreeProvider;
    }

    @Override
    public PermissionNode getParentNode() {
        return this.parentNode;
    }

    @Override
    public void setParentNode(PermissionNode parentNode) {
        this.parentNode = parentNode;
    }

    @Override
    public List<Permission> getPermissionList() {
        return this.permissionList;
    }

    @Override
    public void addPermission(Permission permission, String name) {
        this.addPermission(permission, name, name);
    }

    @Override
    public void addPermission(Permission permission, String grantName, String denyName) {
        this.permissionList.add(permission);
        this.setPermissionGrantName(permission, grantName);
        this.setPermissionDenyName(permission, denyName);
    }

    @Override
    public boolean isExpanded() {
        return this.expanded;
    }

    @Override
    public Object getProperty(String key) {
        return this.propertyMap.get(key);
    }

    @Override
    public void setProperty(String key, Object value) {
        this.propertyMap.put(key, value);
    }

    @Override
    public boolean propertyEquals(String key, Object value) {
        return this.propertyMap.containsKey(key) && this.propertyMap.get(key).equals(value);
    }

    @Override
    public int getPositionInTree() {
        return this.positionInTree;
    }

    public void setPositionInTree(int positionInTree) {
        this.positionInTree = positionInTree;
    }

    @Override
    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    @Override
    public String getNodeFullName() {
        return this.nodeFullName == null ? this.getNodeName() : this.nodeFullName;
    }

    public void setNodeFullName(String nodeFullName) {
        this.nodeFullName = nodeFullName;
    }

    @Override
    public String getPermissionGrantName(Permission permission) {
        return this.grantNameMap.get(permission.getName());
    }

    public void setPermissionGrantName(Permission permission, String name) {
        this.grantNameMap.put(permission.getName(), name);
    }

    @Override
    public String getPermissionDenyName(Permission permission) {
        String name = this.denyNameMap.get(permission.getName());
        return name != null ? name : this.grantNameMap.get(permission.getName());
    }

    public void setPermissionDenyName(Permission permission, String name) {
        this.denyNameMap.put(permission.getName(), name);
    }

    @Override
    public List<Permission> impliesName(PermissionNode node) {
        ArrayList<Permission> result = new ArrayList<Permission>();
        for (Permission other : node.getPermissionList()) {
            if (!this.impliesName(other)) continue;
            result.add(other);
        }
        return result;
    }

    public boolean impliesName(Permission other) {
        for (Permission p : this.permissionList) {
            if (!p.impliesName(other)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void updatePermissionList(PermissionCollection permissions) {
        if (permissions != null) {
            block0: for (Permission p : this.permissionList) {
                Permission existing = permissions.get(p.getName());
                if (existing != null) {
                    p.setResult(existing.getResult());
                    continue;
                }
                PermissionNode parent = this.getFirstParentWithPermissions();
                if (parent == null) continue;
                for (Permission parentPermission : parent.getPermissionList()) {
                    if (!parentPermission.impliesName(p)) continue;
                    p.setResult(parentPermission.getResult());
                    continue block0;
                }
            }
        }
    }

    private PermissionNode getFirstParentWithPermissions() {
        PermissionNode parent;
        for (parent = this.getParentNode(); parent != null && parent.getPermissionList().isEmpty(); parent = parent.getParentNode()) {
        }
        return parent;
    }

    @Override
    public int getLevel() {
        int level = 0;
        PermissionNode parent = this.getParentNode();
        while (parent != null) {
            parent = parent.getParentNode();
            ++level;
        }
        return level;
    }

    @Override
    public void expand(LoadCallback callback) {
        if (!(this instanceof PermissionLeafNode)) {
            Collection<String> resourceIds = this.permissionTree.getChildrenResourceIds(this);
            DefaultLoadOptions options = new DefaultLoadOptions();
            options.setResourceIds(resourceIds);
            this.getPermissionTreeProvider().loadChildren(this, options, children -> {
                this.expanded = true;
                for (PermissionNode child : children) {
                    child.setPermissionTree(this.permissionTree);
                    child.setParentNode(this);
                    child.updatePermissionList(this.permissionTree.getPermissions());
                }
                callback.afterLoad(children);
            });
        } else {
            this.expanded = true;
            callback.afterLoad(Collections.emptyList());
        }
    }

    @Override
    public void collapse() {
        this.expanded = false;
    }
}

