/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.common.graph.NodeConnections;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

abstract class AbstractDirectedNodeConnections<N, E>
implements NodeConnections<N, E> {
    protected final Map<E, N> inEdgeMap;
    protected final Map<E, N> outEdgeMap;

    protected AbstractDirectedNodeConnections(Map<E, N> inEdgeMap, Map<E, N> outEdgeMap) {
        this.inEdgeMap = Preconditions.checkNotNull(inEdgeMap, "inEdgeMap");
        this.outEdgeMap = Preconditions.checkNotNull(outEdgeMap, "outEdgeMap");
    }

    @Override
    public Set<N> adjacentNodes() {
        return Sets.union(this.predecessors(), this.successors());
    }

    @Override
    public Set<E> incidentEdges() {
        return Sets.union(this.inEdges(), this.outEdges());
    }

    @Override
    public Set<E> inEdges() {
        return Collections.unmodifiableSet(this.inEdgeMap.keySet());
    }

    @Override
    public Set<E> outEdges() {
        return Collections.unmodifiableSet(this.outEdgeMap.keySet());
    }

    @Override
    public N oppositeNode(Object edge) {
        return Preconditions.checkNotNull(this.outEdgeMap.get(edge));
    }

    @Override
    public N removeInEdge(Object edge) {
        Preconditions.checkNotNull(edge, "edge");
        return this.inEdgeMap.remove(edge);
    }

    @Override
    public N removeOutEdge(Object edge) {
        Preconditions.checkNotNull(edge, "edge");
        return this.outEdgeMap.remove(edge);
    }

    @Override
    public boolean addInEdge(E edge, N node) {
        Preconditions.checkNotNull(edge, "edge");
        Preconditions.checkNotNull(node, "node");
        N previousNode = this.inEdgeMap.put(edge, node);
        if (previousNode != null) {
            Preconditions.checkArgument(node.equals(previousNode));
            return false;
        }
        return true;
    }

    @Override
    public boolean addOutEdge(E edge, N node) {
        Preconditions.checkNotNull(edge, "edge");
        Preconditions.checkNotNull(node, "node");
        N previousNode = this.outEdgeMap.put(edge, node);
        if (previousNode != null) {
            Preconditions.checkArgument(node.equals(previousNode));
            return false;
        }
        return true;
    }
}

