/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.base.Preconditions;
import com.google.common.graph.NodeConnections;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

abstract class AbstractUndirectedNodeConnections<N, E>
implements NodeConnections<N, E> {
    protected final Map<E, N> incidentEdgeMap;

    protected AbstractUndirectedNodeConnections(Map<E, N> incidentEdgeMap) {
        this.incidentEdgeMap = Preconditions.checkNotNull(incidentEdgeMap, "incidentEdgeMap");
    }

    @Override
    public Set<N> predecessors() {
        return this.adjacentNodes();
    }

    @Override
    public Set<N> successors() {
        return this.adjacentNodes();
    }

    @Override
    public Set<E> incidentEdges() {
        return Collections.unmodifiableSet(this.incidentEdgeMap.keySet());
    }

    @Override
    public Set<E> inEdges() {
        return this.incidentEdges();
    }

    @Override
    public Set<E> outEdges() {
        return this.incidentEdges();
    }

    @Override
    public N oppositeNode(Object edge) {
        return Preconditions.checkNotNull(this.incidentEdgeMap.get(edge));
    }

    @Override
    public N removeInEdge(Object edge) {
        return this.removeOutEdge(edge);
    }

    @Override
    public N removeOutEdge(Object edge) {
        Preconditions.checkNotNull(edge, "edge");
        return this.incidentEdgeMap.remove(edge);
    }

    @Override
    public boolean addInEdge(E edge, N node) {
        return this.addOutEdge(edge, node);
    }

    @Override
    public boolean addOutEdge(E edge, N node) {
        Preconditions.checkNotNull(edge, "edge");
        Preconditions.checkNotNull(node, "node");
        N previousNode = this.incidentEdgeMap.put(edge, node);
        if (previousNode != null) {
            Preconditions.checkArgument(node.equals(previousNode));
            return false;
        }
        return true;
    }
}

