/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.channel;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.sshd.client.channel.ChannelSession;
import org.apache.sshd.common.PtyMode;
import org.apache.sshd.common.util.Buffer;
import org.apache.sshd.common.util.OsUtils;
import org.apache.sshd.common.util.SttySupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PtyCapableChannelSession
extends ChannelSession {
    private boolean agentForwarding;
    private boolean usePty;
    private String ptyType;
    private int ptyColumns;
    private int ptyLines;
    private int ptyWidth;
    private int ptyHeight;
    private Map<PtyMode, Integer> ptyModes;
    private Map<String, String> env = new LinkedHashMap<String, String>();

    public PtyCapableChannelSession(boolean usePty) {
        this.usePty = usePty;
        this.ptyType = System.getenv("TERM");
        if (this.ptyType == null) {
            this.ptyType = "dummy";
        }
        this.ptyColumns = 80;
        this.ptyLines = 24;
        this.ptyWidth = 640;
        this.ptyHeight = 480;
        this.ptyModes = new HashMap<PtyMode, Integer>();
        this.ptyModes.put(PtyMode.ISIG, 1);
        this.ptyModes.put(PtyMode.ICANON, 1);
        this.ptyModes.put(PtyMode.ECHO, 1);
        this.ptyModes.put(PtyMode.ECHOE, 1);
        this.ptyModes.put(PtyMode.ECHOK, 1);
        this.ptyModes.put(PtyMode.ECHONL, 0);
        this.ptyModes.put(PtyMode.NOFLSH, 0);
    }

    public void setupSensibleDefaultPty() {
        try {
            if (OsUtils.isUNIX()) {
                this.ptyModes = SttySupport.getUnixPtyModes();
                this.ptyColumns = SttySupport.getTerminalWidth();
                this.ptyLines = SttySupport.getTerminalHeight();
            } else {
                this.ptyType = "windows";
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public boolean isAgentForwarding() {
        return this.agentForwarding;
    }

    public void setAgentForwarding(boolean agentForwarding) {
        this.agentForwarding = agentForwarding;
    }

    public boolean isUsePty() {
        return this.usePty;
    }

    public void setUsePty(boolean usePty) {
        this.usePty = usePty;
    }

    public String getPtyType() {
        return this.ptyType;
    }

    public void setPtyType(String ptyType) {
        this.ptyType = ptyType;
    }

    public int getPtyColumns() {
        return this.ptyColumns;
    }

    public void setPtyColumns(int ptyColumns) {
        this.ptyColumns = ptyColumns;
    }

    public int getPtyLines() {
        return this.ptyLines;
    }

    public void setPtyLines(int ptyLines) {
        this.ptyLines = ptyLines;
    }

    public int getPtyWidth() {
        return this.ptyWidth;
    }

    public void setPtyWidth(int ptyWidth) {
        this.ptyWidth = ptyWidth;
    }

    public int getPtyHeight() {
        return this.ptyHeight;
    }

    public void setPtyHeight(int ptyHeight) {
        this.ptyHeight = ptyHeight;
    }

    public Map<PtyMode, Integer> getPtyModes() {
        return this.ptyModes;
    }

    public void setPtyModes(Map<PtyMode, Integer> ptyModes) {
        this.ptyModes = ptyModes;
    }

    public void setEnv(String key, String value) {
        this.env.put(key, value);
    }

    protected void doOpenPty() throws IOException {
        Buffer buffer;
        if (this.agentForwarding) {
            this.log.debug("Send agent forwarding request");
            buffer = this.session.createBuffer((byte)98);
            buffer.putInt(this.recipient);
            buffer.putString("auth-agent-req@openssh.com");
            buffer.putBoolean(false);
            this.writePacket(buffer);
        }
        if (this.usePty) {
            this.log.debug("Send SSH_MSG_CHANNEL_REQUEST pty-req");
            buffer = this.session.createBuffer((byte)98);
            buffer.putInt(this.recipient);
            buffer.putString("pty-req");
            buffer.putBoolean(false);
            buffer.putString(this.ptyType);
            buffer.putInt(this.ptyColumns);
            buffer.putInt(this.ptyLines);
            buffer.putInt(this.ptyHeight);
            buffer.putInt(this.ptyWidth);
            Buffer modes = new Buffer();
            for (PtyMode mode : this.ptyModes.keySet()) {
                modes.putByte((byte)mode.toInt());
                modes.putInt(this.ptyModes.get((Object)mode).intValue());
            }
            modes.putByte((byte)0);
            buffer.putBytes(modes.getCompactData());
            this.writePacket(buffer);
        }
        if (!this.env.isEmpty()) {
            this.log.debug("Send SSH_MSG_CHANNEL_REQUEST env");
            for (Map.Entry<String, String> entry : this.env.entrySet()) {
                buffer = this.session.createBuffer((byte)98);
                buffer.putInt(this.recipient);
                buffer.putString("env");
                buffer.putBoolean(false);
                buffer.putString(entry.getKey());
                buffer.putString(entry.getValue());
                this.writePacket(buffer);
            }
        }
    }
}

