/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.workbench.panels.impl;

import com.google.gwt.event.logical.shared.HasSelectionHandlers;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.ui.ResizeComposite;
import com.google.gwt.user.client.ui.Widget;
import javax.inject.Inject;
import org.uberfire.client.workbench.LayoutSelection;
import org.uberfire.client.workbench.PanelManager;
import org.uberfire.client.workbench.panels.MultiPartWidget;
import org.uberfire.client.workbench.panels.WorkbenchPanelPresenter;
import org.uberfire.client.workbench.panels.WorkbenchPanelView;
import org.uberfire.mvp.Command;
import org.uberfire.workbench.model.PanelDefinition;
import org.uberfire.workbench.model.PartDefinition;
import org.uberfire.workbench.model.Position;

public abstract class AbstractWorkbenchPanelView<P extends WorkbenchPanelPresenter>
extends ResizeComposite
implements WorkbenchPanelView<P> {
    @Inject
    protected PanelManager panelManager;
    @Inject
    protected LayoutSelection layoutSelection;
    protected P presenter;

    @Override
    public void addPanel(PanelDefinition panel, WorkbenchPanelView<?> view, Position position) {
        throw new UnsupportedOperationException("This panel does not support child panels");
    }

    @Override
    public boolean removePanel(WorkbenchPanelView<?> child) {
        throw new UnsupportedOperationException("This panel does not support child panels");
    }

    @Override
    public P getPresenter() {
        return this.presenter;
    }

    protected void addOnFocusHandler(MultiPartWidget widget) {
        widget.addOnFocusHandler(new Command(){

            public void execute() {
                AbstractWorkbenchPanelView.this.panelManager.onPanelFocus(AbstractWorkbenchPanelView.this.presenter.getDefinition());
            }
        });
    }

    protected void addSelectionHandler(HasSelectionHandlers<PartDefinition> widget) {
        widget.addSelectionHandler((SelectionHandler)new SelectionHandler<PartDefinition>(){

            public void onSelection(SelectionEvent<PartDefinition> event) {
                AbstractWorkbenchPanelView.this.panelManager.onPartLostFocus();
                AbstractWorkbenchPanelView.this.panelManager.onPartFocus((PartDefinition)event.getSelectedItem());
            }
        });
    }

    @Override
    public void setElementId(String elementId) {
        if (elementId == null) {
            this.getElement().removeAttribute("id");
        } else {
            this.getElement().setAttribute("id", elementId);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getName());
        sb.append("@").append(System.identityHashCode(this));
        sb.append(" id=").append(this.getElement().getAttribute("id"));
        return sb.toString();
    }

    @Override
    public Widget getPartDropRegion() {
        return null;
    }

    @Override
    public void maximize() {
        this.layoutSelection.get().maximize((Widget)this);
    }

    @Override
    public void unmaximize() {
        this.layoutSelection.get().unmaximize((Widget)this);
    }
}

