/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server;

import java.net.URI;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.errai.bus.server.annotations.Service;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.backend.vfs.DirectoryStream;
import org.uberfire.backend.vfs.VFSService;
import org.uberfire.backend.vfs.impl.DirectoryStreamImpl;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.file.AtomicMoveNotSupportedException;
import org.uberfire.java.nio.file.CopyOption;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.DirectoryNotEmptyException;
import org.uberfire.java.nio.file.FileAlreadyExistsException;
import org.uberfire.java.nio.file.FileSystemAlreadyExistsException;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.NoSuchFileException;
import org.uberfire.java.nio.file.NotDirectoryException;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.ProviderNotFoundException;
import org.uberfire.java.nio.file.attribute.FileAttribute;
import org.uberfire.java.nio.file.attribute.FileTime;

@Service
@ApplicationScoped
public class VFSServicesServerImpl
implements VFSService {
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;

    public org.uberfire.backend.vfs.Path get(String uri) {
        return Paths.convert(this.ioService.get(URI.create(uri)));
    }

    public DirectoryStream<org.uberfire.backend.vfs.Path> newDirectoryStream(org.uberfire.backend.vfs.Path dir) throws IllegalArgumentException, NotDirectoryException, IOException {
        Iterator content = this.ioService.newDirectoryStream(Paths.convert(dir)).iterator();
        return this.newDirectoryStream(content);
    }

    public DirectoryStream<org.uberfire.backend.vfs.Path> newDirectoryStream(org.uberfire.backend.vfs.Path dir, DirectoryStream.Filter<org.uberfire.backend.vfs.Path> filter) throws IllegalArgumentException, NotDirectoryException, IOException {
        Iterator content = this.ioService.newDirectoryStream(Paths.convert(dir), null).iterator();
        return this.newDirectoryStream(content);
    }

    public org.uberfire.backend.vfs.Path createDirectory(org.uberfire.backend.vfs.Path dir) throws IllegalArgumentException, UnsupportedOperationException, FileAlreadyExistsException, IOException, SecurityException {
        return Paths.convert(this.ioService.createDirectory(Paths.convert(dir), new FileAttribute[0]));
    }

    public org.uberfire.backend.vfs.Path createDirectories(org.uberfire.backend.vfs.Path dir) throws UnsupportedOperationException, FileAlreadyExistsException, IOException, SecurityException {
        return Paths.convert(this.ioService.createDirectories(Paths.convert(dir), new FileAttribute[0]));
    }

    public org.uberfire.backend.vfs.Path createDirectory(org.uberfire.backend.vfs.Path dir, Map<String, ?> attrs) throws IllegalArgumentException, UnsupportedOperationException, FileAlreadyExistsException, IOException, SecurityException {
        return Paths.convert(this.ioService.createDirectory(Paths.convert(dir), attrs));
    }

    public org.uberfire.backend.vfs.Path createDirectories(org.uberfire.backend.vfs.Path dir, Map<String, ?> attrs) throws UnsupportedOperationException, FileAlreadyExistsException, IOException, SecurityException {
        return Paths.convert(this.ioService.createDirectories(Paths.convert(dir), attrs));
    }

    public Map<String, Object> readAttributes(org.uberfire.backend.vfs.Path path) throws UnsupportedOperationException, IllegalArgumentException, IOException {
        Object _creationTime;
        Object _lastAccessTime;
        HashMap<String, Object> attributes = new HashMap<String, Object>(this.ioService.readAttributes(Paths.convert(path)));
        Object _lastModifiedTime = attributes.get("lastModifiedTime");
        if (_lastModifiedTime != null) {
            attributes.put("lastModifiedTime", new Date(((FileTime)_lastModifiedTime).toMillis()));
        }
        if ((_lastAccessTime = attributes.get("lastAccessTime")) != null) {
            attributes.put("lastAccessTime", new Date(((FileTime)_lastAccessTime).toMillis()));
        }
        if ((_creationTime = attributes.get("creationTime")) != null) {
            attributes.put("creationTime", new Date(((FileTime)_creationTime).toMillis()));
        }
        return attributes;
    }

    public void setAttributes(org.uberfire.backend.vfs.Path path, Map<String, Object> attrs) throws IllegalArgumentException, FileSystemAlreadyExistsException, ProviderNotFoundException {
        this.ioService.setAttributes(Paths.convert(path), attrs);
    }

    public void delete(org.uberfire.backend.vfs.Path path) throws IllegalArgumentException, NoSuchFileException, DirectoryNotEmptyException, IOException {
        this.ioService.delete(Paths.convert(path), new DeleteOption[0]);
    }

    public boolean deleteIfExists(org.uberfire.backend.vfs.Path path) throws IllegalArgumentException, DirectoryNotEmptyException, IOException {
        return this.ioService.deleteIfExists(Paths.convert(path), new DeleteOption[0]);
    }

    public org.uberfire.backend.vfs.Path copy(org.uberfire.backend.vfs.Path source, org.uberfire.backend.vfs.Path target) throws UnsupportedOperationException, FileAlreadyExistsException, DirectoryNotEmptyException, IOException {
        return Paths.convert(this.ioService.copy(Paths.convert(source), Paths.convert(target), new CopyOption[0]));
    }

    public org.uberfire.backend.vfs.Path move(org.uberfire.backend.vfs.Path source, org.uberfire.backend.vfs.Path target) throws UnsupportedOperationException, FileAlreadyExistsException, DirectoryNotEmptyException, AtomicMoveNotSupportedException, IOException {
        return Paths.convert(this.ioService.move(Paths.convert(source), Paths.convert(target), new CopyOption[0]));
    }

    public String readAllString(org.uberfire.backend.vfs.Path path) throws IllegalArgumentException, NoSuchFileException, IOException {
        return this.ioService.readAllString(Paths.convert(path));
    }

    public org.uberfire.backend.vfs.Path write(org.uberfire.backend.vfs.Path path, String content) throws IllegalArgumentException, IOException, UnsupportedOperationException {
        return Paths.convert(this.ioService.write(Paths.convert(path), content, new OpenOption[0]));
    }

    public org.uberfire.backend.vfs.Path write(org.uberfire.backend.vfs.Path path, String content, Map<String, ?> attrs) throws IllegalArgumentException, IOException, UnsupportedOperationException {
        return Paths.convert(this.ioService.write(Paths.convert(path), content, attrs, new OpenOption[0]));
    }

    public boolean isRegularFile(String uri) {
        return Files.isRegularFile((Path)this.ioService.get(URI.create(uri)), (LinkOption[])new LinkOption[0]);
    }

    public boolean isRegularFile(org.uberfire.backend.vfs.Path path) {
        return Files.isRegularFile((Path)Paths.convert(path), (LinkOption[])new LinkOption[0]);
    }

    public boolean isDirectory(String uri) {
        return Files.isDirectory((Path)this.ioService.get(URI.create(uri)), (LinkOption[])new LinkOption[0]);
    }

    public boolean isDirectory(org.uberfire.backend.vfs.Path path) {
        return Files.isDirectory((Path)Paths.convert(path), (LinkOption[])new LinkOption[0]);
    }

    private DirectoryStream<org.uberfire.backend.vfs.Path> newDirectoryStream(Iterator<Path> iterator) {
        LinkedList<org.uberfire.backend.vfs.Path> content = new LinkedList<org.uberfire.backend.vfs.Path>();
        while (iterator.hasNext()) {
            content.add(Paths.convert(iterator.next()));
        }
        return new DirectoryStreamImpl(content);
    }

    private DirectoryStream.Filter<Path> convert(final DirectoryStream.Filter<org.uberfire.backend.vfs.Path> filter) {
        return new DirectoryStream.Filter<Path>(){

            public boolean accept(Path entry) throws IOException {
                return filter.accept((Object)Paths.convert(entry));
            }
        };
    }
}

