/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.plugin;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.enterprise.context.Dependent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.plugin.GwtRuntimePluginLoader;

@Dependent
public class GwtRuntimePluginWatcher {
    private static final Logger LOG = LoggerFactory.getLogger(GwtRuntimePluginWatcher.class);
    boolean active;
    private ExecutorService executor;

    void start(String pluginDir, ExecutorService executor, GwtRuntimePluginLoader pluginLoader) throws IOException {
        Path pluginRootPath = Paths.get(pluginDir, new String[0]);
        if (this.active || !Files.exists(pluginRootPath, new LinkOption[0])) {
            return;
        }
        this.active = true;
        this.executor = executor;
        WatchService watchService = FileSystems.getDefault().newWatchService();
        pluginRootPath.register(watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE);
        this.startWatchService(watchService, pluginLoader);
    }

    private void startWatchService(WatchService watchService, GwtRuntimePluginLoader pluginLoader) {
        this.executor.submit(() -> {
            while (this.active) {
                try {
                    WatchKey watchKey = watchService.poll(5L, TimeUnit.SECONDS);
                    if (watchKey == null) continue;
                    List<WatchEvent<?>> events = watchKey.pollEvents();
                    for (WatchEvent<?> event : events) {
                        WatchEvent.Kind<?> kind = event.kind();
                        if (kind == StandardWatchEventKinds.OVERFLOW) continue;
                        Path file = (Path)event.context();
                        if (kind == StandardWatchEventKinds.ENTRY_CREATE || kind == StandardWatchEventKinds.ENTRY_MODIFY) {
                            if (!file.getFileName().toString().endsWith(".jar")) continue;
                            try {
                                pluginLoader.loadPlugin(file, true);
                            }
                            catch (Exception e) {
                                LOG.error("Failed to process new plugin " + file.getFileName().toString(), (Throwable)e);
                            }
                            continue;
                        }
                        if (kind != StandardWatchEventKinds.ENTRY_DELETE) continue;
                        try {
                            pluginLoader.reload();
                        }
                        catch (Exception e) {
                            LOG.error("Failed to delete plugin " + file.getFileName().toString(), (Throwable)e);
                        }
                    }
                    boolean valid = watchKey.reset();
                    if (valid) continue;
                    break;
                }
                catch (InterruptedException e) {
                    this.active = false;
                    Thread.currentThread().interrupt();
                }
            }
        });
    }

    void stop() {
        this.active = false;
        this.executor.shutdown();
    }
}

