/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.mvp;

import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.user.client.ui.IsWidget;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.uberfire.client.mvp.AbstractActivity;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.SplashScreenActivity;
import org.uberfire.client.workbench.WorkbenchServicesProxy;
import org.uberfire.client.workbench.widgets.splash.SplashView;
import org.uberfire.mvp.ParameterizedCommand;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.model.SplashScreenFilter;

public abstract class AbstractSplashScreenActivity
extends AbstractActivity
implements SplashScreenActivity {
    @Inject
    private WorkbenchServicesProxy wbServices;
    private final SplashView splash;
    private Boolean showAgain;
    private SplashScreenFilter splashFilter;

    @Inject
    public AbstractSplashScreenActivity(PlaceManager placeManager, SplashView splash) {
        super(placeManager);
        this.splash = splash;
    }

    @PostConstruct
    private void initialize() {
        this.splashFilter = this.getFilter();
        this.splash.addCloseHandler((CloseHandler)new CloseHandler<SplashView>(){

            public void onClose(CloseEvent<SplashView> event) {
                AbstractSplashScreenActivity.this.onClose();
            }
        });
    }

    @Override
    public void onOpen() {
        super.onOpen();
    }

    @Override
    public void onStartup(PlaceRequest place) {
        super.onStartup(place);
        this.wbServices.loadSplashScreenFilter(this.getFilter().getName(), new ParameterizedCommand<SplashScreenFilter>(){

            public void execute(SplashScreenFilter response) {
                if (response != null) {
                    AbstractSplashScreenActivity.this.splashFilter = response;
                }
                if (AbstractSplashScreenActivity.this.splashFilter.displayNextTime()) {
                    AbstractSplashScreenActivity.this.forceShow();
                }
            }
        });
    }

    @Override
    public abstract String getTitle();

    @Override
    public abstract IsWidget getWidget();

    @Override
    public Integer getBodyHeight() {
        return null;
    }

    @Override
    public abstract SplashScreenFilter getFilter();

    @Override
    public IsWidget getTitleDecoration() {
        return null;
    }

    @Override
    public void closeIfOpen() {
        if (this.splash.isAttached()) {
            this.splash.hide();
            this.onClose();
        }
    }

    @Override
    public void forceShow() {
        IsWidget widget = this.getWidget();
        this.splash.setContent(widget, this.getBodyHeight());
        this.splash.setTitle(this.getTitle());
        this.splash.show();
    }

    @Override
    public void onClose() {
        this.saveState();
        super.onClose();
    }

    @Override
    public Boolean intercept(PlaceRequest intercepted) {
        if (this.splashFilter == null) {
            return false;
        }
        for (String interceptPoint : this.splashFilter.getInterceptionPoints()) {
            if (!intercepted.getIdentifier().equals(interceptPoint)) continue;
            return true;
        }
        return false;
    }

    private void saveState() {
        this.showAgain = this.splash.showAgain();
        if (this.showAgain != null) {
            this.splashFilter.setDisplayNextTime(this.showAgain.booleanValue());
            this.wbServices.save(this.splashFilter);
        }
    }
}

