/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.task;

import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.ObjectMapper;

public class JobDag {
    @JsonProperty(value="parentsToChildren")
    private Map<String, Set<String>> _parentsToChildren = new TreeMap<String, Set<String>>();
    @JsonProperty(value="childrenToParents")
    private Map<String, Set<String>> _childrenToParents = new TreeMap<String, Set<String>>();
    @JsonProperty(value="allNodes")
    private Set<String> _allNodes = new TreeSet<String>();
    public static final JobDag EMPTY_DAG = new JobDag();

    public void addParentToChild(String parent, String child) {
        if (!this._parentsToChildren.containsKey(parent)) {
            this._parentsToChildren.put(parent, new TreeSet());
        }
        this._parentsToChildren.get(parent).add(child);
        if (!this._childrenToParents.containsKey(child)) {
            this._childrenToParents.put(child, new TreeSet());
        }
        this._childrenToParents.get(child).add(parent);
        this._allNodes.add(parent);
        this._allNodes.add(child);
    }

    public void removeParentToChild(String parent, String child) {
        if (this._parentsToChildren.containsKey(parent)) {
            Set<String> children = this._parentsToChildren.get(parent);
            children.remove(child);
            if (children.isEmpty()) {
                this._parentsToChildren.remove(parent);
            }
        }
        if (this._childrenToParents.containsKey(child)) {
            Set<String> parents = this._childrenToParents.get(child);
            parents.remove(parent);
            if (parents.isEmpty()) {
                this._childrenToParents.remove(child);
            }
        }
    }

    public void addNode(String node) {
        this._allNodes.add(node);
    }

    public void removeNode(String node) {
        if (this._parentsToChildren.containsKey(node) || this._childrenToParents.containsKey(node)) {
            throw new IllegalStateException("The node is either a parent or a child of other node, could not be deleted");
        }
        this._allNodes.remove(node);
    }

    public Map<String, Set<String>> getParentsToChildren() {
        return this._parentsToChildren;
    }

    public Map<String, Set<String>> getChildrenToParents() {
        return this._childrenToParents;
    }

    public Set<String> getAllNodes() {
        return this._allNodes;
    }

    public Set<String> getDirectChildren(String node) {
        if (!this._parentsToChildren.containsKey(node)) {
            return new TreeSet<String>();
        }
        return this._parentsToChildren.get(node);
    }

    public Set<String> getDirectParents(String node) {
        if (!this._childrenToParents.containsKey(node)) {
            return new TreeSet<String>();
        }
        return this._childrenToParents.get(node);
    }

    public String toJson() throws Exception {
        return new ObjectMapper().writeValueAsString((Object)this);
    }

    public static JobDag fromJson(String json) {
        try {
            return (JobDag)new ObjectMapper().readValue(json, JobDag.class);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to parse json " + json + " into job dag");
        }
    }

    public void validate() {
        int iterationCount;
        TreeSet<String> prevIteration = new TreeSet<String>();
        for (String node : this._allNodes) {
            if (!this.getDirectParents(node).isEmpty()) continue;
            prevIteration.add(node);
        }
        TreeSet<String> allNodesReached = new TreeSet<String>();
        int maxIterations = this._allNodes.size() + 1;
        for (iterationCount = 0; !prevIteration.isEmpty() && iterationCount < maxIterations; ++iterationCount) {
            TreeSet<String> thisIteration = new TreeSet<String>();
            for (String node : prevIteration) {
                thisIteration.addAll(this.getDirectChildren(node));
            }
            allNodesReached.addAll(prevIteration);
            prevIteration = thisIteration;
        }
        allNodesReached.addAll(prevIteration);
        if (iterationCount >= maxIterations) {
            throw new IllegalArgumentException("DAG invalid: cycles detected");
        }
        if (!allNodesReached.containsAll(this._allNodes)) {
            throw new IllegalArgumentException("DAG invalid: unreachable nodes found. Reachable set is " + allNodesReached);
        }
    }
}

