/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.utils.security;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.Permission;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PermissionParser {
    static final Logger logger = LoggerFactory.getLogger(PermissionParser.class);

    public static Permission getPermission(String permissionDescription) {
        return PermissionParser.getPermission(permissionDescription, PermissionParser.class.getClassLoader());
    }

    public static Permission getPermission(String permissionDescription, ClassLoader classLoader) {
        PermissionInfo permissionInfo = PermissionParser.parse(permissionDescription);
        try {
            Class<?> clazz = classLoader.loadClass(permissionInfo.className);
            Constructor<?> constructor = clazz.getConstructor(String.class, String.class);
            return (Permission)constructor.newInstance(permissionInfo.name, permissionInfo.actions);
        }
        catch (InstantiationException ie) {
            logger.warn("{}", (Throwable)ie);
            throw new RuntimeException(ie);
        }
        catch (ClassNotFoundException cnfe) {
            logger.warn("{}", (Throwable)cnfe);
            throw new RuntimeException(cnfe);
        }
        catch (NoSuchMethodException nsme) {
            logger.warn("{}", (Throwable)nsme);
            throw new RuntimeException(nsme);
        }
        catch (InvocationTargetException ite) {
            logger.warn("{}", (Throwable)ite);
            throw new RuntimeException(ite);
        }
        catch (IllegalAccessException iae) {
            logger.warn("{}", (Throwable)iae);
            throw new RuntimeException(iae);
        }
    }

    private static PermissionInfo parse(String permissionDescription) {
        StringReader reader = new StringReader(permissionDescription);
        try {
            return PermissionParser.parse(reader);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static PermissionInfo parse(StringReader reader) throws IOException {
        PermissionInfo result = new PermissionInfo();
        int ch = reader.read();
        while (ch != -1) {
            if (ch != 32) {
                if (ch == 40) {
                    PermissionParser.parseFromClassName(reader, result);
                    break;
                }
                throw new IllegalArgumentException("Permission description does not start with '('");
            }
            ch = reader.read();
        }
        ch = reader.read();
        while (ch != -1) {
            if (ch != 32) {
                throw new IllegalArgumentException("Unparsable characters after closing ')'");
            }
            ch = reader.read();
        }
        return result;
    }

    private static void parseFromClassName(StringReader StringReader2, PermissionInfo result) throws IOException {
        PushbackReader reader = new PushbackReader(StringReader2, 1);
        result.className = PermissionParser.readSection(reader);
        result.name = PermissionParser.readSection(reader);
        result.actions = PermissionParser.readSection(reader);
        int closingBracketsCount = 0;
        int ch = reader.read();
        while (ch != -1) {
            if (ch != 32) {
                if (ch == 41) {
                    if ((closingBracketsCount = (int)((byte)(closingBracketsCount + 1))) > 1) {
                        throw new IllegalArgumentException("more than 1 closing bracket");
                    }
                } else {
                    throw new IllegalArgumentException("illegal character at this position: " + ch);
                }
            }
            ch = reader.read();
        }
    }

    private static String readSection(PushbackReader reader) throws IOException {
        int ch = reader.read();
        while (ch != -1) {
            if (ch != 32) {
                reader.unread(ch);
                return PermissionParser.readSectionWithNoHeadingSpace(reader);
            }
            ch = reader.read();
        }
        return null;
    }

    private static String readSectionWithNoHeadingSpace(PushbackReader reader) throws IOException {
        StringBuilder sectionWriter = new StringBuilder();
        int ch = reader.read();
        while (ch != -1) {
            if (ch == 34) {
                if (sectionWriter.length() > 0) {
                    throw new IllegalArgumentException("Quote at wrong position, characters before quote: " + sectionWriter.toString());
                }
                sectionWriter = null;
                return PermissionParser.readTillQuote(reader);
            }
            if (ch == 32) {
                return sectionWriter.toString();
            }
            if (ch == 41) {
                reader.unread(ch);
                return sectionWriter.toString();
            }
            sectionWriter.append((char)ch);
            ch = reader.read();
        }
        throw new IllegalArgumentException("missing closing bracket (')')");
    }

    private static String readTillQuote(PushbackReader reader) throws IOException {
        StringBuilder sectionWriter = new StringBuilder();
        int ch = reader.read();
        while (ch != -1) {
            if (ch == 34) {
                return sectionWriter.toString();
            }
            sectionWriter.append((char)ch);
            ch = reader.read();
        }
        throw new IllegalArgumentException("missing closing quote ('=')");
    }

    private static class PermissionInfo {
        String className;
        String name;
        String actions;

        private PermissionInfo() {
        }
    }
}

