/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.plugin;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.PreDestroy;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.jboss.errai.cdi.server.scripts.ScriptRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.plugin.GwtRuntimePluginLoader;
import org.uberfire.backend.server.plugin.GwtRuntimePluginWatcher;
import org.uberfire.backend.server.plugin.PluginRegistry;

@Dependent
public class GwtRuntimePluginManager {
    private static final Logger LOG = LoggerFactory.getLogger(GwtRuntimePluginManager.class);
    static final String SCRIPT_REGISTRY_KEY = "UF";
    private GwtRuntimePluginWatcher pluginWatcher;
    private GwtRuntimePluginLoader pluginLoader;
    private ExecutorService executor;
    private ScriptRegistry scriptRegistry;

    @Inject
    public GwtRuntimePluginManager(GwtRuntimePluginWatcher pluginWatcher, GwtRuntimePluginLoader pluginLoader, ScriptRegistry scriptRegistry) {
        this.pluginWatcher = pluginWatcher;
        this.pluginLoader = pluginLoader;
        this.scriptRegistry = scriptRegistry;
        this.executor = Executors.newSingleThreadExecutor();
    }

    @PreDestroy
    void shutDown() {
        this.pluginWatcher.stop();
        this.scriptRegistry.removeScripts(SCRIPT_REGISTRY_KEY);
    }

    public void init(String contextRootDir, String pluginDir) {
        try {
            this.pluginLoader.init(contextRootDir, pluginDir, this.findPluginDeploymentDir(contextRootDir), this.createPluginRegistry());
            this.pluginWatcher.start(pluginDir, this.executor, this.pluginLoader);
        }
        catch (Exception e) {
            LOG.error("Failed to initialize " + GwtRuntimePluginManager.class.getName(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    String findPluginDeploymentDir(String contextRootDir) throws IOException {
        Collection gwtFiles = FileUtils.listFiles((File)new File(contextRootDir), (String[])new String[]{"nocache.js"}, (boolean)true);
        if (!gwtFiles.isEmpty()) {
            File gwtFile = (File)gwtFiles.iterator().next();
            return gwtFile.getParentFile().getCanonicalPath();
        }
        return new File(contextRootDir).getCanonicalPath();
    }

    private PluginRegistry createPluginRegistry() {
        final HashSet availablePlugins = new HashSet();
        return new PluginRegistry(){

            @Override
            public void add(String pluginName, String scriptUrl) {
                availablePlugins.add(pluginName);
                GwtRuntimePluginManager.this.scriptRegistry.addScript(GwtRuntimePluginManager.SCRIPT_REGISTRY_KEY, scriptUrl);
            }

            @Override
            public void remove(String pluginName, String scriptUrl) {
                availablePlugins.remove(pluginName);
                GwtRuntimePluginManager.this.scriptRegistry.removeScript(GwtRuntimePluginManager.SCRIPT_REGISTRY_KEY, scriptUrl);
            }

            @Override
            public void removeAll() {
                availablePlugins.clear();
                GwtRuntimePluginManager.this.scriptRegistry.removeScripts(GwtRuntimePluginManager.SCRIPT_REGISTRY_KEY);
            }

            @Override
            public boolean isRegistered(String pluginName) {
                return availablePlugins.contains(pluginName);
            }
        };
    }
}

