/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.annotations.processors;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;
import org.uberfire.annotations.processors.AbstractGenerator;
import org.uberfire.annotations.processors.GeneratorUtils;
import org.uberfire.annotations.processors.TemplateInformation;
import org.uberfire.annotations.processors.TemplateInformationHelper;
import org.uberfire.annotations.processors.exceptions.GenerationException;
import org.uberfire.annotations.processors.facades.ClientAPIModule;
import org.uberfire.relocated.freemarker.template.Template;
import org.uberfire.relocated.freemarker.template.TemplateException;

public class PerspectiveActivityGenerator
extends AbstractGenerator {
    private final Map<String, String> context = new HashMap<String, String>();

    @Override
    public StringBuffer generate(String packageName, PackageElement packageElement, String className, Element element, ProcessingEnvironment processingEnvironment) throws GenerationException {
        String onStartup1ParameterMethodName;
        String onStartup0ParameterMethodName;
        Messager messager = processingEnvironment.getMessager();
        messager.printMessage(Diagnostic.Kind.NOTE, "Starting code generation for [" + className + "]");
        Elements elementUtils = processingEnvironment.getElementUtils();
        TypeElement classElement = (TypeElement)element;
        String identifier = ClientAPIModule.getWbPerspectiveScreenIdentifierValueOnClass(classElement);
        boolean isDefault = ClientAPIModule.getWbPerspectiveScreenIsDefaultValueOnClass(classElement);
        boolean isTransient = ClientAPIModule.getWbPerspectiveScreenIsTransientValueOnClass(classElement);
        boolean isDynamic = ClientAPIModule.getWbPerspectiveScreenIsDynamicValueOnClass(classElement);
        String beanActivatorClass = GeneratorUtils.getBeanActivatorClassName(classElement, processingEnvironment);
        ExecutableElement onStartupMethod = GeneratorUtils.getOnStartupMethodForNonEditors(classElement, processingEnvironment);
        if (onStartupMethod == null) {
            onStartup0ParameterMethodName = null;
            onStartup1ParameterMethodName = null;
        } else if (onStartupMethod.getParameters().isEmpty()) {
            onStartup0ParameterMethodName = onStartupMethod.getSimpleName().toString();
            onStartup1ParameterMethodName = null;
        } else {
            onStartup0ParameterMethodName = null;
            onStartup1ParameterMethodName = onStartupMethod.getSimpleName().toString();
        }
        String onCloseMethodName = GeneratorUtils.getOnCloseMethodName(classElement, processingEnvironment);
        String onShutdownMethodName = GeneratorUtils.getOnShutdownMethodName(classElement, processingEnvironment);
        String onOpenMethodName = GeneratorUtils.getOnOpenMethodName(classElement, processingEnvironment);
        String getPerspectiveMethodName = GeneratorUtils.getPerspectiveMethodName(classElement, processingEnvironment);
        String getMenuBarMethodName = GeneratorUtils.getMenuBarMethodName(classElement, processingEnvironment);
        String getToolBarMethodName = GeneratorUtils.getToolBarMethodName(classElement, processingEnvironment);
        List<String> qualifiers = GeneratorUtils.getAllQualifiersDeclarationFromType(classElement);
        if (GeneratorUtils.debugLoggingEnabled()) {
            messager.printMessage(Diagnostic.Kind.NOTE, "Package name: " + packageName);
            messager.printMessage(Diagnostic.Kind.NOTE, "Class name: " + className);
            messager.printMessage(Diagnostic.Kind.NOTE, "Identifier: " + identifier);
            messager.printMessage(Diagnostic.Kind.NOTE, "isDefault: " + isDefault);
            messager.printMessage(Diagnostic.Kind.NOTE, "isTransient: " + isTransient);
            messager.printMessage(Diagnostic.Kind.NOTE, "onStartup0ParameterMethodName: " + onStartup0ParameterMethodName);
            messager.printMessage(Diagnostic.Kind.NOTE, "onStartup1ParameterMethodName: " + onStartup1ParameterMethodName);
            messager.printMessage(Diagnostic.Kind.NOTE, "onCloseMethodName: " + onCloseMethodName);
            messager.printMessage(Diagnostic.Kind.NOTE, "onShutdownMethodName: " + onShutdownMethodName);
            messager.printMessage(Diagnostic.Kind.NOTE, "onOpenMethodName: " + onOpenMethodName);
            messager.printMessage(Diagnostic.Kind.NOTE, "getPerspectiveMethodName: " + getPerspectiveMethodName);
            messager.printMessage(Diagnostic.Kind.NOTE, "getMenuBarMethodName: " + getMenuBarMethodName);
            messager.printMessage(Diagnostic.Kind.NOTE, "getToolBarMethodName: " + getToolBarMethodName);
            messager.printMessage(Diagnostic.Kind.NOTE, "Qualifiers: " + String.join((CharSequence)", ", qualifiers));
        }
        HashMap<String, Object> root = new HashMap<String, Object>();
        TemplateInformation helper = TemplateInformationHelper.extractWbTemplatePerspectiveInformation(elementUtils, classElement);
        if (helper.getDefaultPanel() != null) {
            root.put("defaultPanel", helper.getDefaultPanel());
        }
        root.put("wbPanels", helper.getTemplateFields());
        if (getPerspectiveMethodName == null && !helper.thereIsTemplateFields()) {
            throw new GenerationException("A WorkbenchPerspective class must have either a valid @Perspective method or at least one @WorkbenchPanel field.", packageName + "." + className);
        }
        if (getPerspectiveMethodName != null && helper.thereIsTemplateFields()) {
            throw new GenerationException("This WorkbenchPerspective has both a @Perspective method and a @WorkbenchPanel field. Only one or the other is allowed.");
        }
        if (isDefault) {
            this.warningIfMoreThanOneDefaultPerspective(processingEnvironment, identifier);
        }
        root.put("packageName", packageName);
        root.put("className", className);
        root.put("identifier", identifier);
        root.put("isTemplate", helper.thereIsTemplateFields());
        root.put("isDefault", isDefault);
        root.put("isTransient", isTransient);
        root.put("realClassName", classElement.getSimpleName().toString());
        root.put("beanActivatorClass", beanActivatorClass);
        root.put("onStartup0ParameterMethodName", onStartup0ParameterMethodName);
        root.put("onStartup1ParameterMethodName", onStartup1ParameterMethodName);
        root.put("onCloseMethodName", onCloseMethodName);
        root.put("onShutdownMethodName", onShutdownMethodName);
        root.put("onOpenMethodName", onOpenMethodName);
        root.put("getPerspectiveMethodName", getPerspectiveMethodName);
        root.put("getMenuBarMethodName", getMenuBarMethodName);
        root.put("getToolBarMethodName", getToolBarMethodName);
        root.put("isDynamic", isDynamic);
        root.put("qualifiers", qualifiers);
        StringWriter sw = new StringWriter();
        BufferedWriter bw = new BufferedWriter(sw);
        try {
            Template template = this.config.getTemplate("perspective.ftl");
            template.process(root, bw);
        }
        catch (IOException ioe) {
            throw new GenerationException(ioe);
        }
        catch (TemplateException te) {
            throw new GenerationException(te);
        }
        finally {
            try {
                bw.close();
                sw.close();
            }
            catch (IOException ioe) {
                throw new GenerationException(ioe);
            }
        }
        messager.printMessage(Diagnostic.Kind.NOTE, "Successfully generated code for [" + className + "]");
        return sw.getBuffer();
    }

    private void warningIfMoreThanOneDefaultPerspective(ProcessingEnvironment processingEnvironment, String perspectiveName) {
        String defaultPerspectivesName = "defaultPerspectivesName";
        String defaultPerspectives = this.context.get(defaultPerspectivesName);
        if (defaultPerspectives != null) {
            defaultPerspectives = defaultPerspectives + ", " + perspectiveName;
            this.generateMoreThanOneDefaultPerspectiveWarning(processingEnvironment, defaultPerspectives);
            this.context.put(defaultPerspectivesName, defaultPerspectives);
        } else {
            this.context.put(defaultPerspectivesName, perspectiveName);
        }
    }

    private void generateMoreThanOneDefaultPerspectiveWarning(ProcessingEnvironment processingEnvironment, String defaultPerspectives) {
        String msg = "Found too many default WorkbenchPerspectives (expected 1). Found: (" + defaultPerspectives + ").";
        processingEnvironment.getMessager().printMessage(Diagnostic.Kind.ERROR, msg);
    }
}

