/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.jgroups.util.Average;

public class bla {
    protected static final long MAX_CREDITS = 2000000L;
    protected static final long BYTES = 1000L;
    protected static final int THREADS = 25;
    protected static final AtomicInteger NUM_DECREMENTS = new AtomicInteger(20000000);
    protected final Credit creds = new Credit(2000000L, new Average());
    final AtomicLong credits = new AtomicLong(2000000L);

    protected boolean decrement(long bytes) {
        long next;
        long prev;
        do {
            if ((next = (prev = this.credits.get()) - bytes) > 0L) continue;
            return false;
        } while (!this.credits.compareAndSet(prev, next));
        return true;
    }

    protected boolean refill() {
        long prev = this.credits.get();
        boolean rc = this.credits.compareAndSet(prev, 2000000L);
        return rc;
    }

    protected void start(boolean lockless) throws Exception {
        Thread[] decrementers = new Thread[25];
        int num_decrs = NUM_DECREMENTS.get();
        CountDownLatch latch = new CountDownLatch(26);
        for (int i = 0; i < decrementers.length; ++i) {
            decrementers[i] = lockless ? new Decrementer(latch) : new CreditDecrementer(latch);
            decrementers[i].start();
        }
        latch.countDown();
        long start = System.currentTimeMillis();
        for (Thread thr : decrementers) {
            thr.join();
        }
        long time = System.currentTimeMillis() - start;
        double decrs_per_sec = (double)num_decrs / ((double)time / 1000.0);
        System.out.printf("%s ms: %.2f decrs/sec\n", time, decrs_per_sec);
    }

    public static void main(String[] args) throws Exception {
        new bla().start(Boolean.valueOf(args[0]));
    }

    protected static class Credit {
        protected long credits_left;
        protected int num_blockings;
        protected final Average avg_blockings;

        protected Credit(long credits, Average avg_blockings) {
            this.credits_left = credits;
            this.avg_blockings = avg_blockings;
        }

        public void reset() {
            this.num_blockings = 0;
            if (this.avg_blockings != null) {
                this.avg_blockings.clear();
            }
        }

        protected synchronized long decrementAndGet(long credits) {
            this.credits_left = Math.max(0L, this.credits_left - credits);
            if (this.credits_left <= 0L) {
                long credit_response = Math.min(2000000L, 2000000L - this.credits_left);
                this.credits_left = 2000000L;
                return credit_response;
            }
            return 0L;
        }

        protected int getNumBlockings() {
            return this.num_blockings;
        }

        protected synchronized long get() {
            return this.credits_left;
        }

        protected synchronized void set(long new_credits) {
            this.credits_left = Math.min(2000000L, new_credits);
            this.notifyAll();
        }

        public String toString() {
            return String.valueOf(this.credits_left);
        }
    }

    protected class CreditDecrementer
    extends Thread {
        protected final CountDownLatch latch;

        public CreditDecrementer(CountDownLatch latch) {
            this.latch = latch;
        }

        @Override
        public void run() {
            this.latch.countDown();
            while (NUM_DECREMENTS.decrementAndGet() >= 0) {
                long bytes = 1000L;
                bla.this.creds.decrementAndGet(bytes);
            }
        }
    }

    protected class Decrementer
    extends Thread {
        protected final CountDownLatch latch;

        public Decrementer(CountDownLatch latch) {
            this.latch = latch;
        }

        @Override
        public void run() {
            this.latch.countDown();
            while (NUM_DECREMENTS.decrementAndGet() >= 0) {
                long bytes = 1000L;
                while (!bla.this.decrement(bytes)) {
                    bla.this.refill();
                }
            }
        }
    }
}

